/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class ProgressPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String MESSAGE = "message";
    private JLabel label;
    private JProgressBar progressBar;
    private JButton cancel;
    private SwingWorker<?, ?> worker;
    private JDialog dialog;

    public ProgressPanel(SwingWorker<?, ?> swingWorker, BoundedRangeModel boundedRangeModel) {
        this.worker = swingWorker;
        this.label = new JLabel(" ");
        this.progressBar = new JProgressBar();
        if (boundedRangeModel == null) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setModel(boundedRangeModel);
            this.progressBar.setStringPainted(true);
        }
        this.cancel = new JButton(Messages.getString("Button.cancel"), Icons.getIcon("16/stop.png"));
        this.cancel.addActionListener(this);
        this.setLayout((LayoutManager)new MigLayout(new LC().fill().insetsAll("10")));
        this.add((Component)this.label, new CC().width("min:400:400").wrap());
        this.add((Component)this.progressBar, new CC().alignX("center").growX().wrap());
        this.add((Component)this.cancel, new CC().alignX("center"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWithDialogHandleError(Component component, String string, SwingWorker<?, ?> swingWorker, boolean bl, BoundedRangeModel boundedRangeModel) {
        Cursor cursor = component.getCursor();
        component.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ProgressPanel.runWithDialog(component, string, swingWorker, bl, boundedRangeModel);
            if (swingWorker.isCancelled()) {
                boolean bl2 = false;
                return bl2;
            }
            swingWorker.get();
            boolean bl3 = true;
            return bl3;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof ExecutionException) {
                throwable = exception.getCause();
            }
            UIUtility.showErrorDialog(component, throwable);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            component.setCursor(cursor);
        }
    }

    public static void runWithDialog(final Component component, final String string, final SwingWorker<?, ?> swingWorker, final boolean bl, final BoundedRangeModel boundedRangeModel) {
        swingWorker.execute();
        if (bl) {
            try {
                swingWorker.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProgressPanel.showDialog(component, string, swingWorker, bl, boundedRangeModel);
        } else {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressPanel.showDialog(component, string, swingWorker, bl, boundedRangeModel);
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private static void showDialog(Component component, String string, SwingWorker<?, ?> swingWorker, boolean bl, BoundedRangeModel boundedRangeModel) {
        if (swingWorker.isDone()) {
            return;
        }
        if (string == null) {
            string = Messages.getString("Message.progress");
        }
        Window window = component == null ? null : SwingUtilities.windowForComponent(component);
        JDialog jDialog = new JDialog(window, string, bl ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        jDialog.setDefaultCloseOperation(0);
        ProgressPanel progressPanel = new ProgressPanel(swingWorker, boundedRangeModel);
        progressPanel.dialog = jDialog;
        swingWorker.addPropertyChangeListener(progressPanel);
        jDialog.setLayout(new BorderLayout());
        jDialog.add((Component)progressPanel, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(window);
        if (swingWorker.isDone()) {
            return;
        }
        jDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dialog != null) {
            this.worker.cancel(true);
            this.dialog.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("progress".equals(string)) {
            this.progressBar.setValue(this.worker.getProgress());
        } else if ("state".equals(string)) {
            if (this.worker.getState() == SwingWorker.StateValue.DONE && this.dialog != null) {
                this.dialog.dispose();
            }
        } else if (MESSAGE.equals(string)) {
            this.label.setText(propertyChangeEvent.getNewValue().toString());
        }
    }
}

