/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.common.component.RObjFilter;
import java.util.ArrayList;
import java.util.List;

public class RTypeFilter
extends RObjFilter {
    public static final RTypeFilter NullFilter = new RTypeFilter();
    public static final RTypeFilter ListFilter = new RTypeFilter(new FilterEntry(FilterMethod.Is, "list"));
    public static final RTypeFilter DataFrameFilter = new RTypeFilter(new FilterEntry(FilterMethod.Is, "data.frame"));
    private List<FilterEntry> entrys = new ArrayList<FilterEntry>();

    public RTypeFilter() {
    }

    public RTypeFilter(FilterEntry filterEntry) {
        this.addFilter(filterEntry);
    }

    public void addFilter(FilterEntry filterEntry) {
        this.entrys.add(filterEntry);
    }

    @Override
    public String getEvalFormula(String string) {
        if (this.entrys.size() < 1) {
            return "TRUE";
        }
        Object object = "";
        for (int i = 0; i < this.entrys.size(); ++i) {
            FilterEntry filterEntry = this.entrys.get(i);
            object = (String)object + filterEntry.getEvalFormula(string) + this.filterType;
        }
        object = ((String)object).substring(0, ((String)object).length() - this.filterType.length());
        return object;
    }

    public static class FilterEntry {
        private FilterMethod method;
        private String target;

        public FilterEntry(FilterMethod filterMethod, String string) {
            this.method = filterMethod;
            this.target = string;
        }

        public FilterMethod getMethod() {
            return this.method;
        }

        public String getTarget() {
            return this.target;
        }

        public String getEvalFormula(String string) {
            switch (this.method.ordinal()) {
                case 0: {
                    return "is." + this.target + "(" + string + ")";
                }
                case 1: {
                    return "inherits(" + string + ", \"" + this.target + "\")";
                }
                case 2: {
                    return "mode(" + string + ") == \"" + this.target + "\"";
                }
                case 3: {
                    return "typeof(" + string + ") == \"" + this.target + "\"";
                }
            }
            return "TRUE";
        }
    }

    public static enum FilterMethod {
        Is("is"),
        Class("class"),
        Mode("mode"),
        Typeof("typeof");

        private String name;

        private FilterMethod(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public static FilterMethod toFilterMethod(String string) {
            if (string.equals("is")) {
                return Is;
            }
            if (string.equals("class")) {
                return Class;
            }
            if (string.equals("mode")) {
                return Mode;
            }
            if (string.equals("typeof")) {
                return Typeof;
            }
            return null;
        }

        public static String[] nameValues() {
            FilterMethod[] filterMethodArray = FilterMethod.values();
            String[] stringArray = new String[filterMethodArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = filterMethodArray[i].name;
            }
            return stringArray;
        }
    }
}

