/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.util.FontSupport;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import javax.swing.JTabbedPane;

public class RflowTabbedPane
extends JTabbedPane {
    public RflowTabbedPane() {
        this.init();
    }

    public RflowTabbedPane(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public RflowTabbedPane(int n) {
        super(n);
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseWheelListener(mouseHandler);
        this.refreshFont();
        this.addHierarchyListener(new DisplayableHandler());
    }

    private void refreshFont() {
        this.setFont(FontSupport.getFont(this.getFont(), (Key<Double>)Settings.BASIC_FONT_SIZE));
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (RflowTabbedPane.this.getTabCount() == 0) {
                return;
            }
            if (mouseWheelEvent.getScrollType() != 0) {
                return;
            }
            Rectangle rectangle = RflowTabbedPane.this.getUI().getTabBounds(RflowTabbedPane.this, 0);
            if (mouseWheelEvent.getPoint().y > rectangle.y + rectangle.height) {
                return;
            }
            int n = RflowTabbedPane.this.getSelectedIndex();
            n = mouseWheelEvent.getWheelRotation() > 0 ? ++n : --n;
            if (n >= 0 && n < RflowTabbedPane.this.getTabCount()) {
                RflowTabbedPane.this.setSelectedIndex(n);
            }
        }
    }

    private class DisplayableHandler
    extends DisplayableListener {
        private SettingsListener settingsListener;

        private DisplayableHandler() {
        }

        @Override
        protected void didBecomeDisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener == null) {
                this.settingsListener = new SettingsListener();
                Rflow.settings().addEventHandler(this.settingsListener);
            }
        }

        @Override
        protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener != null) {
                Rflow.settings().removeEventHandler(this.settingsListener);
            }
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.BASIC_FONT_SIZE.equals(valueChangeEvent.getKey())) {
                RflowTabbedPane.this.refreshFont();
            }
        }
    }
}

