/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.util.FontSupport;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RflowTree
extends JTree {
    public static final String ACTION_COLLAPSE_ALL = "ACTION_COLLAPSE_ALL";
    public static final String ACTION_EXPAND_ALL = "ACTION_EXPAND_ALL";
    private String fontFamily = null;

    public RflowTree() {
        this.init();
    }

    public RflowTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.init();
    }

    public RflowTree(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public RflowTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    public RflowTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.init();
    }

    public RflowTree(TreeNode treeNode) {
        super(treeNode);
        this.init();
    }

    public RflowTree(Vector<?> vector) {
        super(vector);
        this.init();
    }

    private void init() {
        this.refreshFont();
        this.addHierarchyListener(new DisplayableHandler());
        new RflowTreeActions().installActions(this, false, 1);
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
        this.refreshFont();
    }

    private void refreshFont() {
        if (this.fontFamily == null) {
            this.setFont(FontSupport.getFont(this.getFont(), (Key<Double>)Settings.BASIC_FONT_SIZE));
        } else {
            this.setFont(FontSupport.getFont(this.fontFamily, (Key<Double>)Settings.BASIC_FONT_SIZE));
        }
        FontMetrics fontMetrics = new JLabel().getFontMetrics(this.getFont());
        this.setRowHeight(Math.max(18, Math.round(fontMetrics.getHeight())));
    }

    public void collapseAll() {
        this.collapseAll(1);
    }

    protected void collapseAll(int n) {
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(this.getModel().getRoot()));
        if (enumeration == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            TreePath treePath = enumeration.nextElement();
            if (treePath.getPathCount() <= n) continue;
            arrayList.add(treePath);
        }
        Collections.sort(arrayList, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath treePath, TreePath treePath2) {
                int n;
                int n2 = treePath.getPathCount();
                if (n2 > (n = treePath2.getPathCount())) {
                    return -1;
                }
                if (n2 < n) {
                    return 1;
                }
                return 0;
            }
        });
        for (TreePath treePath : arrayList) {
            this.collapsePath(treePath);
        }
    }

    public void expandAll() {
        this.expandAll(new TreePath(this.getModel().getRoot()));
    }

    private void expandAll(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        this.expandPath(treePath);
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(treePath2);
            }
        }
    }

    private class DisplayableHandler
    extends DisplayableListener {
        private SettingsListener settingsListener;

        private DisplayableHandler() {
        }

        @Override
        protected void didBecomeDisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener == null) {
                this.settingsListener = new SettingsListener();
                Rflow.settings().addEventHandler(this.settingsListener);
            }
        }

        @Override
        protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
            if (this.settingsListener != null) {
                Rflow.settings().removeEventHandler(this.settingsListener);
            }
        }
    }

    private class RflowTreeActions
    extends Actions {
        public RflowTreeActions() {
            this.put(RflowTree.ACTION_COLLAPSE_ALL, new CollapseAll());
            this.put(RflowTree.ACTION_EXPAND_ALL, new ExpandAll());
        }

        private class CollapseAll
        extends LoggableAction {
            public CollapseAll() {
                this.putValue("Name", Messages.getString("Action.collapse_all"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RflowTree.this.collapseAll();
            }
        }

        private class ExpandAll
        extends LoggableAction {
            public ExpandAll() {
                this.putValue("Name", Messages.getString("Action.expand_all"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                RflowTree.this.expandAll();
            }
        }
    }

    private class SettingsListener
    implements ValueChangeEventHandler {
        private SettingsListener() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            if (Settings.BASIC_FONT_SIZE.equals(valueChangeEvent.getKey())) {
                RflowTree.this.refreshFont();
            }
        }
    }
}

