/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;

public class RowHeaderResizer
extends MouseInputAdapter
implements ContainerListener {
    private JScrollPane pane;
    private JViewport viewport;
    private Component rowHeader;
    private Component corner;
    private JTable view;
    private boolean enabled;
    private boolean active;
    private int startX;
    private int startWidth;
    private int minWidth;
    private int maxWidth;
    private static final int WIDTH = 5;
    private static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private Cursor oldCursor;

    public static void install(JScrollPane jScrollPane) {
        new RowHeaderResizer(jScrollPane);
    }

    public RowHeaderResizer(JScrollPane jScrollPane) {
        this.pane = jScrollPane;
        this.pane.addContainerListener(this);
        this.setEnabled(true);
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        if (this.enabled) {
            this.addListeners();
        } else {
            this.removeListeners();
        }
    }

    protected void addListeners() {
        if (this.corner != null) {
            this.corner.addMouseListener(this);
            this.corner.addMouseMotionListener(this);
        }
    }

    protected void removeListeners() {
        if (this.corner != null) {
            this.corner.removeMouseListener(this);
            this.corner.removeMouseMotionListener(this);
        }
    }

    protected void lookupComponents() {
        this.view = (JTable)this.pane.getViewport().getView();
        this.viewport = this.pane.getRowHeader();
        this.rowHeader = this.viewport == null ? null : this.viewport.getView();
        this.corner = this.pane.getCorner("UPPER_LEFT_CORNER");
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.componentRemoved(containerEvent);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.enabled) {
            this.removeListeners();
        }
        this.lookupComponents();
        if (this.enabled) {
            this.addListeners();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.oldCursor != null) {
            this.corner.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.corner.getWidth() - mouseEvent.getX() <= 5) {
            if (this.oldCursor == null) {
                this.oldCursor = this.corner.getCursor();
                this.corner.setCursor(RESIZE_CURSOR);
            }
        } else if (this.oldCursor != null) {
            this.corner.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.startX = mouseEvent.getX();
        this.startWidth = this.rowHeader.getWidth();
        if (this.startWidth - this.startX > 5) {
            return;
        }
        this.active = true;
        if (this.oldCursor == null) {
            this.oldCursor = this.corner.getCursor();
            this.corner.setCursor(RESIZE_CURSOR);
        }
        this.minWidth = this.rowHeader.getMinimumSize().width;
        this.maxWidth = this.rowHeader.getMaximumSize().width;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.active = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.active) {
            return;
        }
        Dimension dimension = this.viewport.getPreferredSize();
        dimension.width = this.startWidth + mouseEvent.getX() - this.startX;
        if (dimension.width < this.minWidth) {
            dimension.width = this.minWidth;
        } else if (dimension.width > this.maxWidth) {
            dimension.width = this.maxWidth;
        }
        this.viewport.setPreferredSize(dimension);
        this.view.doLayout();
        this.pane.revalidate();
        this.pane.repaint();
    }
}

