/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ShapeIconFactory {
    public static final int RIGHT_TRIANGLE = 0;
    public static final int LEFT_TRIANGLE = 1;
    public static final int UP_TRIANGLE = 2;
    public static final int DOWN_TRIANGLE = 3;

    public static Icon create(int n, int n2, Color color) {
        Shape shape = null;
        int n3 = (int)((double)(n2 / 2) * Math.sqrt(3.0));
        switch (n) {
            case 0: {
                shape = new Polygon(new int[]{0, 0, n3}, new int[]{0, n2, n2 / 2}, 3);
                break;
            }
            case 1: {
                shape = new Polygon(new int[]{n3, n3, 0}, new int[]{0, n2, n2 / 2}, 3);
                break;
            }
            case 2: {
                shape = new Polygon(new int[]{0, n2, n2 / 2}, new int[]{n3, n3, 0}, 3);
                break;
            }
            case 3: {
                shape = new Polygon(new int[]{0, n2 / 2, n2}, new int[]{0, n3, 0}, 3);
            }
        }
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape.getBounds();
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.translate(n2 / 2 - rectangle.width / 2, n2 / 2 - rectangle.height / 2);
        graphics2D.fill(shape);
        graphics2D.dispose();
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        bufferedImage.flush();
        return imageIcon;
    }
}

