/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;

public class ShowInvisibleTextRenderer
extends SubstanceDefaultTableCellRenderer {
    private static final char TAB = '\t';
    private static final char LN = '\n';
    private static final char CR = '\r';
    private static final char[] ESCAPE_LETTERS = new char[]{'a', 'b', 't', 'n', 'v', 'f', 'r'};
    private static final char CRLN = 'd';
    private boolean tooltip;
    private List<int[]> offsets;
    private static final String TWO_SP = "  ";
    private static final String FOUR_SP = "    ";
    private static final String EIGHT_SP = "        ";
    private Rectangle paintViewR = new Rectangle();
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();

    public ShowInvisibleTextRenderer(boolean bl) {
        this.tooltip = bl;
        this.offsets = new ArrayList<int[]>();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.offsets.clear();
        String string = this.getText();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl3 = false;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl3) {
                if (c == '\n') {
                    this.offsets.add(new int[]{100, stringBuilder.length()});
                    stringBuilder.append(TWO_SP);
                    bl3 = false;
                    continue;
                }
                this.offsets.add(new int[]{13, stringBuilder.length()});
                stringBuilder.append(TWO_SP);
            }
            bl3 = false;
            switch (c) {
                case '\t': {
                    this.offsets.add(new int[]{9, stringBuilder.length()});
                    stringBuilder.append(EIGHT_SP);
                    continue block5;
                }
                case '\r': {
                    bl3 = true;
                    continue block5;
                }
                case '\n': {
                    this.offsets.add(new int[]{10, stringBuilder.length()});
                    stringBuilder.append(TWO_SP);
                    continue block5;
                }
                default: {
                    if (c >= '\u0007' && c <= '\r') {
                        this.offsets.add(new int[]{c, stringBuilder.length()});
                        stringBuilder.append(TWO_SP);
                        continue block5;
                    }
                    if (c < ' ' || c == '\u007f') {
                        this.offsets.add(new int[]{c, stringBuilder.length()});
                        stringBuilder.append(FOUR_SP);
                        continue block5;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        if (!this.offsets.isEmpty()) {
            string = stringBuilder.toString();
        }
        this.setText(string);
        if (this.tooltip) {
            this.setToolTipText(string);
        }
        return this;
    }

    private String layoutLabel(FontMetrics fontMetrics) {
        Insets insets = this.getInsets(null);
        String string = this.getText();
        Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = this.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = this.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return SwingUtilities.layoutCompoundLabel((JComponent)((Object)this), fontMetrics, string, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, this.getIconTextGap());
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.offsets.isEmpty()) {
            int n;
            int n2;
            int[] nArray;
            int n3;
            String string = this.layoutLabel(graphics.getFontMetrics());
            int n4 = string.endsWith("...") ? string.length() - 3 : string.length();
            int n5 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), " ");
            Insets insets = this.getInsets();
            int n6 = this.getHeight() - insets.bottom - insets.top;
            int n7 = graphics.getFontMetrics().getHeight();
            int n8 = insets.top + (n6 - n7) / 2 + graphics.getFontMetrics().getAscent();
            Iterator<int[]> iterator = this.offsets.iterator();
            while (iterator.hasNext() && n4 >= (n3 = nArray[1]) + (n2 = (n = (nArray = iterator.next())[0]) == 9 ? EIGHT_SP.length() : TWO_SP.length())) {
                int n9 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string.substring(0, n3));
                n9 += insets.left;
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics.getColor();
                graphics.setColor(Color.LIGHT_GRAY);
                switch (n) {
                    case 9: {
                        graphics2D.drawRect(n9 + 1, insets.top, n5 * 8 - 3, n6 - 1);
                        break;
                    }
                    case 10: {
                        this.paintLn(graphics2D, n9, n8, n6);
                        break;
                    }
                    case 100: {
                        this.paintCrln(graphics2D, n9, n8, n6, n5);
                        break;
                    }
                    default: {
                        if (n >= 7 && n <= 13) {
                            UIUtility.drawString(graphics2D, "\\" + ESCAPE_LETTERS[n - 7], n9, n8);
                            break;
                        }
                        if (n >= 32 && n != 127) break;
                        Object object = Integer.toHexString(n);
                        if (((String)object).length() == 1) {
                            object = "0" + (String)object;
                        }
                        UIUtility.drawString(graphics2D, "\\x" + (String)object, n9, n8);
                    }
                }
                graphics.setColor(color);
            }
        }
    }

    private void paintLn(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n + 4;
        int n5 = n4 - 2;
        int n6 = n4 + 2;
        int n7 = n2 - Math.min(9, n3);
        int n8 = n2 - 1;
        int n9 = n2 - 4;
        graphics2D.drawLine(n4, n7, n4, n8);
        graphics2D.drawLine(n5, n9, n4, n8);
        graphics2D.drawLine(n6, n9, n4, n8);
    }

    private void paintCrln(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n + 1;
        int n6 = n5 + 3;
        int n7 = n5 + Math.min(6, n4 * 2);
        int n8 = n2 - 5;
        int n9 = n8 - 2;
        int n10 = n8 + 2;
        int n11 = Math.max(n8 - 5, n2 - n3);
        graphics2D.drawLine(n5, n8, n6, n9);
        graphics2D.drawLine(n5, n8, n6, n10);
        graphics2D.drawLine(n5, n8, n7, n8);
        graphics2D.drawLine(n7, n8, n7, n11);
    }
}

