/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SideBorder
extends AbstractBorder {
    public static final int SIDE_TOP = 1;
    public static final int SIDE_LEFT = 2;
    public static final int SIDE_BOTTOM = 4;
    public static final int SIDE_RIGHT = 8;
    public static final int SIDE_ALL = 255;
    private int side = 1;
    private Color color;

    public SideBorder(int n, Color color) {
        this.side = n;
        this.color = color;
    }

    private boolean isSide(int n) {
        return (this.side & n) == n;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.color);
        int n5 = 0;
        if (this.isSide(1)) {
            graphics.drawLine(n, n2 - n5, n + n3 - 1, n2 - n5);
        }
        if (this.isSide(2)) {
            graphics.drawLine(n - n5, n2, n - n5, n2 + n4 - 1);
        }
        if (this.isSide(4)) {
            graphics.drawLine(n, n2 + n4 - 1 + n5, n + n3 - 1, n2 + n4 - 1 + n5);
        }
        if (this.isSide(8)) {
            graphics.drawLine(n + n3 - 1 + n5, n2, n + n3 - 1 + n5, n2 + n4 - 1);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.setInsets(new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        return this.setInsets(insets);
    }

    private Insets setInsets(Insets insets) {
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        int n = 1;
        if (this.isSide(1)) {
            insets.top += n;
        }
        if (this.isSide(2)) {
            insets.left += n;
        }
        if (this.isSide(4)) {
            insets.bottom += n;
        }
        if (this.isSide(8)) {
            insets.right += n;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

