/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.core.common.util.ThreadUtility;
import com.ef_prime.rflow.ui.common.event.ChangeEvent;
import com.ef_prime.rflow.ui.common.event.ChangeEventHandler;
import com.ef_prime.rflow.ui.common.event.EventSupport;

public class SingleExecutor {
    private Runnable lastWorker;
    private Runnable currentWorker;
    private Runnable waitingWorker;
    private EventSupport<ChangeEvent, ChangeEventHandler> support = new EventSupport();

    public synchronized boolean isWorking() {
        return this.currentWorker != null;
    }

    public synchronized boolean isWaiting() {
        return this.waitingWorker != null;
    }

    public synchronized Runnable getLastWorker() {
        return this.lastWorker;
    }

    public synchronized Runnable getCurrentWorker() {
        return this.currentWorker;
    }

    public synchronized Runnable getWaitingWorker() {
        return this.waitingWorker;
    }

    public synchronized void submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (!this.isWorking()) {
            this.currentWorker = runnable;
            this.run();
        } else {
            this.waitingWorker = runnable;
        }
        this.fireChangeEvent();
    }

    public synchronized void kill() {
        if (this.isWorking()) {
            this.cancelCurrentWorker();
        }
        this.lastWorker = null;
        this.currentWorker = null;
        this.waitingWorker = null;
        this.fireChangeEvent();
    }

    private void cancelCurrentWorker() {
    }

    private synchronized void run() {
        ThreadUtility.execute(new Runner());
    }

    private synchronized void currentWorkerFinished() {
        this.lastWorker = this.currentWorker;
        this.currentWorker = this.waitingWorker;
        this.waitingWorker = null;
        this.fireChangeEvent();
        if (this.currentWorker != null) {
            this.run();
        }
    }

    private void fireChangeEvent() {
        this.support.dispatchEvent(new ChangeEvent(this));
    }

    public void addChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.support.addEventHandler(changeEventHandler);
    }

    public void removeChangeEventHandler(ChangeEventHandler changeEventHandler) {
        this.support.removeEventHandler(changeEventHandler);
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            if (SingleExecutor.this.currentWorker == null) {
                return;
            }
            try {
                SingleExecutor.this.currentWorker.run();
            }
            catch (Throwable throwable) {
            }
            finally {
                SingleExecutor.this.currentWorkerFinished();
            }
        }
    }
}

