/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.JXMultiSplitPane;

public abstract class SplitPaneTracker
implements HierarchyListener,
MouseListener,
KeyListener {
    private Component component;
    private List<JXMultiSplitPane> multiSplitPanes;

    public SplitPaneTracker(Component component) {
        this.component = component;
        component.addHierarchyListener(this);
    }

    private void setMultiSplitPane(List<JXMultiSplitPane> list) {
        if (this.multiSplitPanes == list) {
            return;
        }
        if (this.multiSplitPanes != null) {
            for (JXMultiSplitPane jXMultiSplitPane : this.multiSplitPanes) {
                jXMultiSplitPane.removeMouseListener((MouseListener)this);
                jXMultiSplitPane.removeKeyListener((KeyListener)this);
            }
        }
        this.multiSplitPanes = list;
        if (this.multiSplitPanes != null) {
            for (JXMultiSplitPane jXMultiSplitPane : this.multiSplitPanes) {
                jXMultiSplitPane.addMouseListener((MouseListener)this);
                jXMultiSplitPane.addKeyListener((KeyListener)this);
            }
        }
    }

    public boolean isDragging() {
        if (this.multiSplitPanes == null) {
            return false;
        }
        for (JXMultiSplitPane jXMultiSplitPane : this.multiSplitPanes) {
            if (jXMultiSplitPane.activeDivider() == null) continue;
            return true;
        }
        return false;
    }

    protected abstract void dragFinished();

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        ArrayList<JXMultiSplitPane> arrayList = new ArrayList<JXMultiSplitPane>(2);
        for (Component component = this.component; component != null; component = component.getParent()) {
            if (!(component instanceof JXMultiSplitPane)) continue;
            arrayList.add((JXMultiSplitPane)component);
        }
        this.setMultiSplitPane(arrayList.isEmpty() ? null : arrayList);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.dragFinished();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragFinished();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

