/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.base.Prefs;
import com.ef_prime.rflow.ui.common.component.ItemAcceptListener;
import com.ef_prime.rflow.ui.common.component.SupportPopup;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class SupportControl
implements ChangeListener,
ItemAcceptListener {
    private static final Logger LOGGER = Logger.getLogger(SupportControl.class.getName());
    protected JTextComponent input;
    private boolean autoSupport = false;
    private boolean allowLeftRightInput = true;
    private int supportListIndex;
    private boolean supportFlag = false;
    private Queue<ItemAcceptListener> itemAcceptListeners = new ConcurrentLinkedQueue<ItemAcceptListener>();
    SupportPopup popup;
    KeyListener popupListKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    SupportControl.this.acceptItem();
                    break;
                }
                case 27: {
                    SupportControl.this.removeSupportPopup();
                }
            }
        }
    };
    MouseListener popupListMouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                SupportControl.this.acceptItem();
            }
        }
    };
    private int partsPos;
    private static final char[] non = new char[]{'#', '\"', '\'', '%', '`', '<', '-', '>', '!', '=', ':', '&', '|', '{', '}', '(', ')', '[', ']', '?', '*', '+', '/', '^', '~', '@', ' ', '\t', '\f', '\n', ',', '\\'};
    private static final TreeSet<Character> nonSet = new TreeSet();

    public SupportControl(JTextComponent jTextComponent) {
        this.input = jTextComponent;
        jTextComponent.addKeyListener(new InputKeyListener(this));
        jTextComponent.getCaret().addChangeListener(this);
        this.addItemAcceptListener(this);
        jTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (SupportControl.this.popup != null && focusEvent.getOppositeComponent() != SupportControl.this.popup.getList()) {
                    SupportControl.this.removeSupportPopup();
                }
            }
        });
    }

    protected abstract String[] getSupportWords(String var1, int var2);

    protected Point getPopupPoint() {
        Point point;
        try {
            int n = this.partsPos;
            Rectangle rectangle = this.input.modelToView(n);
            point = new Point(rectangle.x, rectangle.y + rectangle.height);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.SEVERE, "Invalid 'partsPos'.", badLocationException);
            return null;
        }
        SwingUtilities.convertPointToScreen(point, this.input);
        return point;
    }

    protected int getPopupWidth() {
        return 200;
    }

    public void addItemAcceptListener(ItemAcceptListener itemAcceptListener) {
        this.itemAcceptListeners.add(itemAcceptListener);
    }

    public void removeItemAcceptListener(ItemAcceptListener itemAcceptListener) {
        this.itemAcceptListeners.remove(itemAcceptListener);
    }

    public void setCaretSupport(boolean bl) {
        this.input.getCaret().removeChangeListener(this);
        if (bl) {
            this.input.getCaret().addChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.supportFlag && this.input.isEnabled()) {
            this.showSupport(this.getText(changeEvent));
        }
    }

    @Override
    public void itemAccepted(JTextComponent jTextComponent, String string) {
        Document document = this.input.getDocument();
        String string2 = this.getCaretPosPart();
        if (string2 == null) {
            string2 = "";
        }
        int n = this.input.getCaretPosition() - string2.length();
        int n2 = string2.indexOf(36);
        n += ++n2;
        try {
            document.remove(n, string2.length() - n2);
            document.insertString(n, string, Prefs.SIMPLE_ATTR);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    public void showSupport(String string) {
        String[] stringArray = this.getSupportWords(string, this.supportListIndex);
        if (stringArray == null || stringArray.length < 1) {
            this.removeSupportPopup();
            return;
        }
        if (this.popup == null) {
            if (!this.input.isShowing()) {
                return;
            }
            Point point = this.getPopupPoint();
            if (point == null) {
                return;
            }
            this.popup = new SupportPopup(this.input, point.x, point.y, new Dimension(this.getPopupWidth(), 100));
            this.popup.getList().addKeyListener(this.popupListKeyListener);
            this.popup.getList().addMouseListener(this.popupListMouseListener);
            this.showSupportPopup();
        }
        this.popup.setListModel(stringArray);
    }

    protected String getText(DocumentEvent documentEvent) {
        String string = null;
        try {
            string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return string;
    }

    protected String getText(ChangeEvent changeEvent) {
        return this.getCaretPosPart();
    }

    public void showSupportPopup() {
        if (this.popup != null) {
            this.popup.show();
            this.supportFlag = true;
        }
    }

    public void removeSupportPopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
            if (!this.autoSupport) {
                this.supportFlag = false;
            }
        }
    }

    public boolean isSupportPopup() {
        return this.popup != null;
    }

    public synchronized void acceptItem() {
        this.supportFlag = false;
        String string = this.popup.getSelected();
        for (ItemAcceptListener itemAcceptListener : this.itemAcceptListeners) {
            itemAcceptListener.itemAccepted(this.input, string);
        }
        this.supportFlag = true;
        this.removeSupportPopup();
    }

    public String getRawText() {
        try {
            Document document = this.input.getDocument();
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
    }

    private String getCaretPosPart() {
        int n;
        String string = this.getRawText();
        this.partsPos = n = this.input.getCaretPosition();
        if (n > string.length()) {
            n = string.length();
        }
        int n2 = n;
        --n2;
        while (n2 > -1) {
            char c = string.charAt(n2);
            if (!nonSet.contains(Character.valueOf(c))) {
                --n2;
                continue;
            }
            ++n2;
            break;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n <= n2) {
            return null;
        }
        this.partsPos = n2;
        return string.substring(n2, n);
    }

    public boolean isAutoSupport() {
        return this.autoSupport;
    }

    public void setAutoSupport(boolean bl) {
        this.autoSupport = bl;
        this.supportFlag = bl;
    }

    public void setAllowLeftRightInput(boolean bl) {
        this.allowLeftRightInput = bl;
    }

    static {
        for (char c : non) {
            nonSet.add(Character.valueOf(c));
        }
    }

    private class InputKeyListener
    extends KeyAdapter {
        private SupportControl supportControl;

        public InputKeyListener(SupportControl supportControl2) {
            this.supportControl = supportControl2;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            SupportPopup supportPopup = this.supportControl.popup;
            if (supportPopup == null) {
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        if (!keyEvent.isControlDown()) break;
                        String string = SupportControl.this.getCaretPosPart();
                        SupportControl.this.supportListIndex = string == null || string.length() == 0 ? 1 : 0;
                        this.supportControl.showSupport(string);
                        keyEvent.consume();
                    }
                }
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    supportPopup.selectPrevious();
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    supportPopup.selectNext();
                    keyEvent.consume();
                    break;
                }
                case 37: 
                case 39: {
                    if (this.supportControl.allowLeftRightInput) break;
                    this.supportControl.removeSupportPopup();
                    break;
                }
                case 10: {
                    if (supportPopup.isSelectionEmpty()) {
                        this.supportControl.removeSupportPopup();
                        keyEvent.consume();
                        break;
                    }
                    this.supportControl.acceptItem();
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    this.supportControl.removeSupportPopup();
                    keyEvent.consume();
                }
            }
        }
    }
}

