/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class SupportPopup {
    private Popup popup;
    private JList<String> list = new JList();
    private JScrollPane scrollPane = new JScrollPane(this.list);

    public SupportPopup(Component component, int n, int n2, Dimension dimension) {
        this.scrollPane.setPreferredSize(dimension);
        this.popup = PopupFactory.getSharedInstance().getPopup(component, this.scrollPane, n, n2);
    }

    JList<String> getList() {
        return this.list;
    }

    public void setListModel(String[] stringArray) {
        this.list.setModel(new SimpleListModel(stringArray));
    }

    public void selectPrevious() {
        int n = this.list.getSelectedIndex() - 1;
        if (n > -1) {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    public String getSelected() {
        return this.list.getSelectedValue().toString();
    }

    public void selectNext() {
        int n = this.list.getSelectedIndex() + 1;
        if (n < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    public void hide() {
        this.popup.hide();
    }

    public void show() {
        this.popup.show();
    }

    private static class SimpleListModel
    extends AbstractListModel<String> {
        private String[] elements;

        SimpleListModel(String[] stringArray) {
            this.elements = stringArray;
        }

        @Override
        public String getElementAt(int n) {
            return this.elements[n];
        }

        @Override
        public int getSize() {
            return this.elements.length;
        }
    }
}

