/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.common.component.TabTransferable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTabbedPane;
import javax.swing.Timer;

public class TabbedPaneDnDHandler {
    private JTabbedPane tabbedPane;
    private int targetIndex = -1;

    public void install(JTabbedPane jTabbedPane) {
        if (jTabbedPane.getTabPlacement() != 1) {
            throw new IllegalArgumentException("tabbedPane.getTabPlacement() != JTabbedPane.TOP");
        }
        this.tabbedPane = jTabbedPane;
        new DragSource().createDefaultDragGestureRecognizer(jTabbedPane, 2, new DragSourceHandler());
        new DropTarget(jTabbedPane, 0x40000003, new DropTargetHandler());
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    protected boolean isDraggable(int n) {
        return true;
    }

    protected boolean isDroppable(int n) {
        return true;
    }

    protected boolean canImportAsTab(Transferable transferable) {
        return transferable.isDataFlavorSupported(TabTransferable.TabDataFlavor);
    }

    protected boolean canImport(Transferable transferable) {
        return false;
    }

    protected boolean importTab(DropTargetDropEvent dropTargetDropEvent) {
        TabTransferable tabTransferable;
        if (this.targetIndex < 0 || !dropTargetDropEvent.isDataFlavorSupported(TabTransferable.TabDataFlavor)) {
            return false;
        }
        try {
            tabTransferable = (TabTransferable)dropTargetDropEvent.getTransferable().getTransferData(TabTransferable.TabDataFlavor);
        }
        catch (Exception exception) {
            return false;
        }
        if (tabTransferable.getTabbedPane() == this.tabbedPane && tabTransferable.getIndex() == this.targetIndex) {
            return false;
        }
        if (tabTransferable.getTabbedPane() == this.tabbedPane) {
            this.moveTab(tabTransferable.getIndex(), this.targetIndex);
        } else {
            this.moveTab(tabTransferable.getTabbedPane(), tabTransferable.getIndex(), this.targetIndex);
        }
        return true;
    }

    private void moveTab(int n, int n2) {
        if (n2 < 0 || n == n2) {
            return;
        }
        Component component = this.tabbedPane.getComponentAt(n);
        Component component2 = this.tabbedPane.getTabComponentAt(n);
        this.startMovingTab(component2, component);
        this.tabbedPane.remove(n);
        int n3 = n > n2 ? n2 : n2 - 1;
        this.tabbedPane.insertTab(null, null, component, null, n3);
        this.tabbedPane.setTabComponentAt(n3, component2);
        this.endMovingTab(component2, component);
        this.tabbedPane.setSelectedIndex(n3);
    }

    private void moveTab(JTabbedPane jTabbedPane, int n, int n2) {
        if (n2 < 0) {
            return;
        }
        Component component = jTabbedPane.getComponentAt(n);
        Component component2 = jTabbedPane.getTabComponentAt(n);
        this.startMovingTab(component2, component);
        jTabbedPane.remove(n);
        this.tabbedPane.insertTab(null, null, component, null, n2);
        this.tabbedPane.setTabComponentAt(n2, component2);
        this.endMovingTab(component2, component);
        this.tabbedPane.setSelectedIndex(n2);
    }

    protected boolean importData(Transferable transferable) {
        return false;
    }

    protected void startMovingTab(Component component, Component component2) {
    }

    protected void endMovingTab(Component component, Component component2) {
    }

    public void drawTarget(Graphics graphics) {
        if (this.targetIndex < 0 || this.targetIndex > this.tabbedPane.getTabCount()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(Color.BLACK);
        int n = 4;
        int n2 = 2;
        if (this.targetIndex == this.tabbedPane.getTabCount()) {
            if (this.targetIndex == 0) {
                graphics2D.setStroke(new BasicStroke((float)n / 2.0f));
                graphics2D.drawRect(1, 1, 100, 20);
            } else {
                Rectangle rectangle = this.tabbedPane.getBoundsAt(this.targetIndex - 1);
                if (rectangle == null) {
                    return;
                }
                graphics2D.fillRect(rectangle.x + rectangle.width - n / 2, rectangle.y - n2, n, rectangle.height + n2 * 2);
            }
        } else {
            Rectangle rectangle = this.tabbedPane.getBoundsAt(this.targetIndex);
            if (rectangle == null) {
                return;
            }
            graphics2D.fillRect(rectangle.x - n / 2, rectangle.y - n2, n, rectangle.height + n2 * 2);
        }
        graphics2D.dispose();
    }

    private void setTargetTabIndex(int n) {
        if (!this.isDroppable(n)) {
            n = -1;
        }
        if (this.targetIndex != n) {
            this.targetIndex = n;
            this.tabbedPane.repaint();
        }
    }

    private class DragSourceHandler
    extends DragSourceAdapter
    implements DragGestureListener {
        private DragSourceHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            int n = TabbedPaneDnDHandler.this.tabbedPane.indexAtLocation(point.x, point.y);
            if (n < 0 || !TabbedPaneDnDHandler.this.isDraggable(n)) {
                return;
            }
            TabTransferable tabTransferable = new TabTransferable(TabbedPaneDnDHandler.this.tabbedPane, n);
            dragGestureEvent.getDragSource().startDrag(dragGestureEvent, Cursor.getDefaultCursor(), tabTransferable, this);
        }
    }

    private class DropTargetHandler
    extends DropTargetAdapter {
        private RollOverHandler rollOverHandler = new RollOverHandler();

        private int getTargetTabIndex(Point point) {
            if (TabbedPaneDnDHandler.this.tabbedPane.getTabCount() == 0) {
                return 0;
            }
            for (int i = 0; i < TabbedPaneDnDHandler.this.tabbedPane.getTabCount(); ++i) {
                Rectangle rectangle = TabbedPaneDnDHandler.this.tabbedPane.getBoundsAt(i);
                if (point.y <= rectangle.y - 50 || point.y >= rectangle.y + rectangle.height + 50 || point.x <= rectangle.x || i != TabbedPaneDnDHandler.this.tabbedPane.getTabCount() - 1 && point.x >= rectangle.x + rectangle.width) continue;
                return point.x < rectangle.x + rectangle.width / 2 ? i : i + 1;
            }
            return -1;
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            TabbedPaneDnDHandler.this.setTargetTabIndex(-1);
            this.rollOverHandler.stop();
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!dropTargetDragEvent.isDataFlavorSupported(TabTransferable.TabDataFlavor)) {
                this.rollOverHandler.setRollOver(dropTargetDragEvent.getLocation());
            }
            if (TabbedPaneDnDHandler.this.canImportAsTab(dropTargetDragEvent.getTransferable())) {
                Point point = dropTargetDragEvent.getLocation();
                TabbedPaneDnDHandler.this.setTargetTabIndex(this.getTargetTabIndex(point));
                if (TabbedPaneDnDHandler.this.targetIndex >= 0) {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                    return;
                }
            }
            if (TabbedPaneDnDHandler.this.canImport(dropTargetDragEvent.getTransferable())) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                this.rollOverHandler.setRollOver(dropTargetDragEvent.getLocation());
                return;
            }
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                if (this.doImportData(dropTargetDropEvent)) {
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.dropComplete(false);
                    dropTargetDropEvent.rejectDrop();
                }
            }
            finally {
                TabbedPaneDnDHandler.this.setTargetTabIndex(-1);
            }
        }

        private boolean doImportData(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (!TabbedPaneDnDHandler.this.canImportAsTab(transferable) && !TabbedPaneDnDHandler.this.canImport(transferable)) {
                return false;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            if (TabbedPaneDnDHandler.this.importTab(dropTargetDropEvent)) {
                return true;
            }
            return TabbedPaneDnDHandler.this.importData(transferable);
        }

        private class RollOverHandler
        implements ActionListener {
            private Timer rollOverTimer = new Timer(500, this);
            private int rollOverIndex = -1;

            public RollOverHandler() {
                this.rollOverTimer.setRepeats(false);
            }

            public void stop() {
                if (this.rollOverTimer.isRunning()) {
                    this.rollOverTimer.stop();
                }
                this.rollOverIndex = -1;
            }

            public void setRollOver(Point point) {
                this.setRollOver(this.getRollOverTabIndex(point));
            }

            public void setRollOver(int n) {
                if (n < 0) {
                    this.stop();
                    return;
                }
                if (this.rollOverTimer.isRunning()) {
                    if (n == this.rollOverIndex) {
                        return;
                    }
                    this.rollOverTimer.stop();
                }
                this.rollOverIndex = n;
                if (TabbedPaneDnDHandler.this.tabbedPane.getSelectedIndex() == this.rollOverIndex) {
                    return;
                }
                this.rollOverTimer.start();
            }

            private int getRollOverTabIndex(Point point) {
                if (point == null) {
                    return -1;
                }
                for (int i = 0; i < TabbedPaneDnDHandler.this.tabbedPane.getTabCount(); ++i) {
                    Rectangle rectangle = TabbedPaneDnDHandler.this.tabbedPane.getBoundsAt(i);
                    if (point.y <= rectangle.y || point.y >= rectangle.y + rectangle.height || point.x <= rectangle.x || point.x >= rectangle.x + rectangle.width) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.rollOverIndex < 0) {
                    return;
                }
                int n = this.getRollOverTabIndex(TabbedPaneDnDHandler.this.tabbedPane.getMousePosition());
                if (n == this.rollOverIndex && TabbedPaneDnDHandler.this.tabbedPane.getSelectedIndex() != this.rollOverIndex) {
                    TabbedPaneDnDHandler.this.tabbedPane.setSelectedIndex(this.rollOverIndex);
                }
                this.rollOverIndex = -1;
            }
        }
    }
}

