/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.common.tree.MutableTreeNodeFlavor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeDnDMoveHandler
extends DropTargetAdapter {
    private static final Logger LOGGER = Logger.getLogger(TreeDnDMoveHandler.class.getName());
    private JTree tree;
    private MutableTreeNode targetNode;
    private boolean useUpperSide;
    private boolean upperSide;
    private Color guildLineColor;

    public TreeDnDMoveHandler(JTree jTree, boolean bl) {
        this.tree = jTree;
        this.useUpperSide = bl;
        this.guildLineColor = jTree.getCellRenderer() instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)jTree.getCellRenderer()).getBackgroundSelectionColor() : Color.GRAY;
    }

    protected final DefaultTreeModel getTreeModel() {
        try {
            return (DefaultTreeModel)this.tree.getModel();
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("treemodel should be DefaultTreeModel");
        }
    }

    public MutableTreeNode getTargetNode() {
        return this.targetNode;
    }

    public boolean isUpperSide() {
        return this.useUpperSide && this.upperSide;
    }

    public boolean useUpperSide() {
        return this.useUpperSide;
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.targetNode = null;
        this.tree.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.dragOver(dropTargetDragEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        MutableTreeNode[] mutableTreeNodeArray;
        if (!dropTargetDragEvent.getTransferable().isDataFlavorSupported(this.getNodeFlavor())) {
            this.rejectDrag(dropTargetDragEvent);
            return;
        }
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            this.rejectDrag(dropTargetDragEvent);
            return;
        }
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        this.upperSide = point.y < rectangle.y + rectangle.height / 3;
        try {
            mutableTreeNodeArray = (MutableTreeNode[])dropTargetDragEvent.getTransferable().getTransferData(this.getNodeFlavor());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to get TreeNode data from Transferable.", exception);
            this.rejectDrag(dropTargetDragEvent);
            return;
        }
        for (MutableTreeNode mutableTreeNode = (MutableTreeNode)((TreeNode)treePath.getLastPathComponent()).getParent(); mutableTreeNode != null; mutableTreeNode = (MutableTreeNode)mutableTreeNode.getParent()) {
            if (mutableTreeNodeArray[0] != mutableTreeNode) continue;
            this.rejectDrag(dropTargetDragEvent);
            return;
        }
        this.targetNode = (MutableTreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < mutableTreeNodeArray.length; ++i) {
            if (this.targetNode != mutableTreeNodeArray[i]) continue;
            this.rejectDrag(dropTargetDragEvent);
            return;
        }
        if (!this.checkDragAccept(dropTargetDragEvent, mutableTreeNodeArray)) {
            this.rejectDrag(dropTargetDragEvent);
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        this.tree.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        MutableTreeNode[] mutableTreeNodeArray;
        if (this.targetNode == null) {
            this.dropFailed(dropTargetDropEvent);
            return;
        }
        try {
            mutableTreeNodeArray = (MutableTreeNode[])dropTargetDropEvent.getTransferable().getTransferData(this.getNodeFlavor());
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to get TreeNode data from Transferable.", exception);
            this.dropFailed(dropTargetDropEvent);
            return;
        }
        for (MutableTreeNode mutableTreeNode : mutableTreeNodeArray) {
            if (this.targetNode != mutableTreeNode) continue;
            this.dropFailed(dropTargetDropEvent);
            return;
        }
        switch (dropTargetDropEvent.getDropAction()) {
            case 2: {
                this.moveDragNode(dropTargetDropEvent, mutableTreeNodeArray, this.getCurrentTargetParent(), this.getCurrentTargetIndex());
                break;
            }
            case 1: {
                this.copyDragNode(dropTargetDropEvent, mutableTreeNodeArray, this.getCurrentTargetParent(), this.getCurrentTargetIndex());
                break;
            }
            default: {
                this.dropFailed(dropTargetDropEvent);
            }
        }
        this.onDropComplete(mutableTreeNodeArray);
        dropTargetDropEvent.dropComplete(true);
        this.targetNode = null;
        this.tree.repaint();
    }

    protected void rejectDrag(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.rejectDrag();
        this.targetNode = null;
        this.tree.repaint();
    }

    private void dropFailed(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.dropComplete(false);
        this.targetNode = null;
        this.tree.repaint();
    }

    public MutableTreeNode getCurrentTargetParent() {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.targetNode.getParent();
        if (this.targetNode.isLeaf() && mutableTreeNode != null) {
            return mutableTreeNode;
        }
        if (this.isUpperSide()) {
            return mutableTreeNode;
        }
        return this.targetNode;
    }

    public int getCurrentTargetIndex() {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.targetNode.getParent();
        return this.getCurrentTargetIndex(mutableTreeNode);
    }

    public int getCurrentTargetIndex(MutableTreeNode mutableTreeNode) {
        if (this.targetNode.isLeaf() && mutableTreeNode != null) {
            if (this.isUpperSide()) {
                return mutableTreeNode.getIndex(this.targetNode);
            }
            return mutableTreeNode.getIndex(this.targetNode) + 1;
        }
        if (this.isUpperSide()) {
            return mutableTreeNode.getIndex(this.targetNode);
        }
        return this.targetNode.getChildCount();
    }

    protected boolean checkDragAccept(DropTargetDragEvent dropTargetDragEvent, MutableTreeNode[] mutableTreeNodeArray) {
        return true;
    }

    protected void moveDragNode(DropTargetDropEvent dropTargetDropEvent, MutableTreeNode[] mutableTreeNodeArray, MutableTreeNode mutableTreeNode, int n) {
        MutableTreeNode[] mutableTreeNodeArray2 = mutableTreeNodeArray;
        int n2 = mutableTreeNodeArray2.length;
        for (int i = 0; i < n2; ++i) {
            MutableTreeNode mutableTreeNode2 = mutableTreeNodeArray2[i];
            this.getTreeModel().removeNodeFromParent(mutableTreeNode2);
        }
        int n3 = this.getCurrentTargetIndex();
        for (n2 = mutableTreeNodeArray.length - 1; n2 >= 0; --n2) {
            this.getTreeModel().insertNodeInto(mutableTreeNodeArray[n2], mutableTreeNode, n3);
        }
    }

    protected abstract void copyDragNode(DropTargetDropEvent var1, MutableTreeNode[] var2, MutableTreeNode var3, int var4);

    protected void onDropComplete(MutableTreeNode[] mutableTreeNodeArray) {
    }

    protected DataFlavor getNodeFlavor() {
        return MutableTreeNodeFlavor.getInstance();
    }

    public boolean isDropTargetNode(MutableTreeNode mutableTreeNode) {
        return this.getTargetNode() == mutableTreeNode && this.getCurrentTargetParent() == mutableTreeNode;
    }

    public void drawTargetLine(Graphics graphics) {
        if (this.getTargetNode() == null) {
            return;
        }
        MutableTreeNode mutableTreeNode = this.getCurrentTargetParent();
        if (mutableTreeNode == null) {
            return;
        }
        int n = this.getCurrentTargetIndex();
        if (this.getTargetNode() == mutableTreeNode) {
            return;
        }
        Rectangle rectangle = null;
        TreePath treePath = new TreePath(this.getTreeModel().getPathToRoot(mutableTreeNode.getChildAt(mutableTreeNode.getChildCount() == n ? n - 1 : n)));
        rectangle = this.tree.getPathBounds(treePath);
        if (rectangle == null) {
            return;
        }
        graphics.setColor(this.guildLineColor);
        graphics.fillRect(rectangle.x - 10, rectangle.y - 1 + (mutableTreeNode.getChildCount() == n ? this.tree.getRowHeight() : 0), 50, 2);
    }
}

