/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    private int vgap;
    private int hspace;

    public VerticalLayout() {
        this(5);
    }

    public VerticalLayout(int n) {
        this(n, 0);
    }

    public VerticalLayout(int n, int n2) {
        this.vgap = n;
        this.hspace = n2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = this.vgap + insets.top;
            int n3 = container.getWidth() - insets.left - insets.right - this.hspace;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                int n4 = dimension == null ? 0 : dimension.height;
                component.setBounds(this.hspace + insets.left, n2, n3, n4);
                n2 += n4 + this.vgap;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = this.vgap;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n3 = component.getMinimumSize().height;
            n2 += n3 + this.vgap;
        }
        return new Dimension(this.hspace + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = this.vgap;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            n3 = Math.max(n3, component.getPreferredSize().width);
            int n4 = component.getPreferredSize().height;
            n2 += n4 + this.vgap;
        }
        return new Dimension(n3 + this.hspace + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }
}

