/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class ViewSwitchPanel
extends View
implements ItemListener {
    private JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 0));
    private JToolBar toolPanel = new JToolBar();
    private SwitchPanel switchPanel = new SwitchPanel();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private List<View> views = new ArrayList<View>();
    private ChangeEvent changeEvent;

    public ViewSwitchPanel() {
        this.setLayout(new BorderLayout());
        this.toolPanel.setFloatable(false);
        this.toolPanel.setVisible(false);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fill, hidemode 3, gapx 0", "[][grow]"));
        jPanel.add(this.toolPanel);
        jPanel.add((Component)this.buttonPanel, "alignx left, growx");
        this.add((Component)jPanel, "North");
        this.add((Component)this.switchPanel, "Center");
    }

    public void addToToolBar(Action action) {
        this.addToToolBar(action, true);
    }

    public void addToToolBar(Action action, boolean bl) {
        JButton jButton = new JButton(action);
        jButton.setHideActionText(bl);
        String string = (String)action.getValue("Name");
        if (string != null && bl) {
            jButton.setToolTipText(string);
        }
        jButton.setFocusable(false);
        this.toolPanel.add(jButton);
        this.toolPanel.setVisible(true);
    }

    public void addView(View view2) {
        JRadioButton jRadioButton = new JRadioButton(view2.getTitle());
        jRadioButton.addItemListener(this);
        jRadioButton.setFocusable(false);
        this.buttonPanel.add(jRadioButton);
        this.buttonGroup.add(jRadioButton);
        if (this.views.isEmpty()) {
            this.switchPanel.set(view2);
        }
        this.views.add(view2);
        this.buttonPanel.setVisible(this.views.size() > 1);
        view2.loadView();
    }

    public void unloadAllView() {
        this.buttonPanel.removeAll();
        this.buttonGroup = new ButtonGroup();
        this.switchPanel.set(null);
        for (View view2 : this.views) {
            view2.unloadView();
        }
        this.views.clear();
        this.toolPanel.removeAll();
        this.revalidate();
        this.repaint();
    }

    public List<View> getViews() {
        return this.views;
    }

    public int getViewCount() {
        return this.views.size();
    }

    public int indexOfViewClass(Class<? extends View> clazz) {
        for (int i = 0; i < this.views.size(); ++i) {
            if (!this.views.get(i).getClass().equals(clazz)) continue;
            return i;
        }
        return -1;
    }

    public int getSelectedIndex() {
        return UIUtility.getSelectedButtonIndex(this.buttonGroup);
    }

    public void setSelectedIndex(int n) {
        UIUtility.setSelectedButtonIndex(this.buttonGroup, n);
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.views.get(n);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Component component = this.getSelectedComponent();
            this.switchPanel.set(component);
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
            }
        }
    }
}

