/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.component;

import com.ef_prime.rflow.ui.common.component.DelayedExecutor;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public class WindowSizeTracker
implements HierarchyListener,
ComponentListener,
Runnable {
    private Component component;
    private Window window;
    private boolean resizing;
    private DelayedExecutor delayedExecutor;

    public WindowSizeTracker(Component component) {
        this.component = component;
        this.delayedExecutor = new DelayedExecutor(this, 500L);
        component.addHierarchyListener(this);
    }

    public void setWindow(Window window) {
        if (this.window != null) {
            this.window.removeComponentListener(this);
        }
        this.window = window;
        if (this.window != null) {
            this.window.addComponentListener(this);
        }
    }

    public synchronized boolean isResizing() {
        return this.resizing;
    }

    public synchronized void setResizing(boolean bl) {
        this.resizing = bl;
        if (!bl) {
            this.resizeFinished();
        }
    }

    protected void resizeFinished() {
    }

    @Override
    public void run() {
        this.setResizing(false);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        for (Component component = this.component; component != null; component = component.getParent()) {
            if (!(component instanceof Window)) continue;
            this.setWindow((Window)component);
            return;
        }
        this.setWindow(null);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.setResizing(true);
        this.delayedExecutor.requestAction();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

