/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.event;

import com.ef_prime.rflow.ui.common.event.Event;
import com.ef_prime.rflow.ui.common.event.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventManager {
    private static final Logger LOGGER = Logger.getLogger(EventManager.class.getName());
    private HashMap<Class<? extends Event<?>>, List<EventHandler>> eventMap = new HashMap();
    private static EventManager instance;

    public static EventManager getInstance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventHandler(Class<? extends Event<?>> clazz, EventHandler eventHandler) {
        HashMap<Class<? extends Event<?>>, List<EventHandler>> hashMap = this.eventMap;
        synchronized (hashMap) {
            List<EventHandler> list = this.eventMap.get(clazz);
            if (list == null) {
                list = new ArrayList<EventHandler>();
                this.eventMap.put(clazz, list);
            }
            list.add(eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(Class<? extends Event<?>> clazz, EventHandler eventHandler) {
        HashMap<Class<? extends Event<?>>, List<EventHandler>> hashMap = this.eventMap;
        synchronized (hashMap) {
            List<EventHandler> list = this.eventMap.get(clazz);
            if (list != null) {
                list.remove(eventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(Event event) {
        ArrayList<EventHandler> arrayList = null;
        HashMap<Class<? extends Event<?>>, List<EventHandler>> hashMap = this.eventMap;
        synchronized (hashMap) {
            List<EventHandler> object = this.eventMap.get(event.getClass());
            if (object == null) {
                return;
            }
            arrayList = new ArrayList<EventHandler>(object);
        }
        for (EventHandler eventHandler : arrayList) {
            try {
                event.dispatch(eventHandler);
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.SEVERE, "Exception occured during event handling.", throwable);
            }
        }
    }
}

