/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.event;

import com.ef_prime.rflow.ui.common.event.Event;
import com.ef_prime.rflow.ui.common.event.EventHandler;
import com.ef_prime.rflow.ui.common.event.Observer;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventSupport<E extends Event<L>, L extends EventHandler>
implements Observer<E, L> {
    private static final Logger LOGGER = Logger.getLogger(EventSupport.class.getName());
    private Deque<HandlerReference<L>> eventHandlers = new ArrayDeque<HandlerReference<L>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<L> getEventHandlers() {
        Deque<HandlerReference<L>> deque = this.eventHandlers;
        synchronized (deque) {
            ArrayList<EventHandler> arrayList = new ArrayList<EventHandler>();
            for (HandlerReference<L> handlerReference : this.eventHandlers) {
                EventHandler eventHandler = (EventHandler)handlerReference.get();
                if (eventHandler == null) continue;
                arrayList.add(eventHandler);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEventHandler(L l) {
        Deque<HandlerReference<L>> deque = this.eventHandlers;
        synchronized (deque) {
            for (HandlerReference<L> handlerReference : this.eventHandlers) {
                if (!l.equals(handlerReference.get())) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void addEventHandler(L l) {
        this.addEventHandler(l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandlerToFirst(L l) {
        Deque<HandlerReference<L>> deque = this.eventHandlers;
        synchronized (deque) {
            this.eventHandlers.addFirst(new HandlerReference<L>(l, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(L l, boolean bl) {
        Deque<HandlerReference<L>> deque = this.eventHandlers;
        synchronized (deque) {
            this.eventHandlers.add(new HandlerReference<L>(l, bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventHandler(L l) {
        Deque<HandlerReference<L>> deque = this.eventHandlers;
        synchronized (deque) {
            HandlerReference<L> handlerReference = null;
            for (HandlerReference<L> handlerReference2 : this.eventHandlers) {
                if (!l.equals(handlerReference2.get())) continue;
                handlerReference = handlerReference2;
                break;
            }
            this.eventHandlers.remove(handlerReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(E e) {
        ArrayList<HandlerReference<L>> arrayList;
        HashSet<HandlerReference> hashSet = null;
        Iterator iterator = this.eventHandlers;
        synchronized (iterator) {
            arrayList = new ArrayList<HandlerReference<L>>(this.eventHandlers);
        }
        for (HandlerReference handlerReference : arrayList) {
            EventHandler eventHandler = (EventHandler)handlerReference.get();
            if (eventHandler != null) {
                try {
                    ((Event)e).dispatch((EventHandler)eventHandler);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
                continue;
            }
            if (hashSet == null) {
                hashSet = new HashSet<HandlerReference>();
            }
            hashSet.add(handlerReference);
        }
        if (hashSet != null) {
            for (HandlerReference handlerReference : hashSet) {
                this.eventHandlers.remove(handlerReference);
            }
        }
    }

    private static class HandlerReference<L> {
        private L reference;
        private WeakReference<L> weakReference;

        public HandlerReference(L l, boolean bl) {
            if (bl) {
                this.weakReference = new WeakReference<L>(l);
            } else {
                this.reference = l;
            }
        }

        public L get() {
            if (this.weakReference != null) {
                return (L)this.weakReference.get();
            }
            return this.reference;
        }
    }
}

