/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Choice;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.lang3.ObjectUtils;

public class ChoiceComboboxModel<E>
extends AbstractListModel<E>
implements ComboBoxModel<E> {
    private List<E> list;
    private List<E> filteredList;
    private Predicate<E> filter;
    private Predicate<E> filter2;
    private Object selectedItem;

    public ChoiceComboboxModel() {
        this.list = new ArrayList();
    }

    public ChoiceComboboxModel(E[] EArray) {
        this.list = new ArrayList();
        for (E e : EArray) {
            this.list.add(e);
        }
    }

    public ChoiceComboboxModel(List<E> list) {
        this.list = new ArrayList<E>(list);
    }

    public void setData(List<E> list) {
        this.setData(list, null);
    }

    public void setData(List<E> list, Object object) {
        int n = this.getSize();
        this.list = list;
        if (object != null) {
            this.selectedItem = object;
        }
        if (this.filter != null) {
            this.updateFilteredList(object);
        }
        this.fireContentsChanged(this, -2, n - 1);
    }

    public void setData(E[] EArray) {
        int n = this.getSize();
        this.list.clear();
        for (E e : EArray) {
            this.list.add(e);
        }
        if (this.filter != null) {
            this.updateFilteredList(this.selectedItem);
        }
        this.fireContentsChanged(this, -2, n - 1);
    }

    public boolean isFiltered() {
        return this.filter != null;
    }

    public void clearFilter() {
        this.setFilter(null, null, null);
    }

    public void setFilter(Predicate<E> predicate, Predicate<E> predicate2, String string) {
        if (ObjectUtils.equals(this.filter, predicate) && ObjectUtils.equals(this.filter2, predicate2)) {
            return;
        }
        this.filter = predicate;
        this.filter2 = predicate2;
        int n = this.getSize();
        this.updateFilteredList(string);
        this.fireContentsChanged(this, -2, n - 1);
    }

    public static void setStandardChoiceFilter(ChoiceComboboxModel<Choice> choiceComboboxModel, String string) {
        if (string.isEmpty()) {
            choiceComboboxModel.clearFilter();
            return;
        }
        final String string2 = string.toLowerCase();
        Predicate<Choice> predicate = new Predicate<Choice>(){

            @Override
            public boolean test(Choice choice) {
                return choice.getValue().toLowerCase().startsWith(string2);
            }
        };
        Predicate<Choice> predicate2 = new Predicate<Choice>(){

            @Override
            public boolean test(Choice choice) {
                return choice.getValue().toLowerCase().contains(string2);
            }
        };
        choiceComboboxModel.setFilter(predicate, predicate2, string);
    }

    private void updateFilteredList(Object object) {
        if (this.filter == null) {
            if (this.filteredList == null) {
                return;
            }
            this.filteredList = null;
        } else {
            if (this.filteredList == null) {
                this.filteredList = new ArrayList();
            } else {
                this.filteredList.clear();
            }
            ArrayList<E> arrayList = new ArrayList<E>();
            for (E e : this.list) {
                if (this.filter.test(e)) {
                    this.filteredList.add(e);
                    continue;
                }
                if (this.filter2 == null || !this.filter2.test(e)) continue;
                arrayList.add(e);
            }
            this.filteredList.addAll(arrayList);
            if (this.filteredList.size() == 1 && this.filteredList.get(0).equals(object)) {
                this.filteredList.clear();
            }
        }
    }

    private List<E> getList() {
        return this.filteredList == null ? this.list : this.filteredList;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (ObjectUtils.equals((Object)this.selectedItem, (Object)object)) {
            return;
        }
        this.selectedItem = object;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.getList().size();
    }

    @Override
    public E getElementAt(int n) {
        if (n >= 0 && n < this.getList().size()) {
            return this.getList().get(n);
        }
        return null;
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, -1, -1);
    }
}

