/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.app.r.base.R;
import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.DescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.util.Utility;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.keyvalue.ChoiceComboboxModel;
import com.ef_prime.rflow.ui.common.keyvalue.ComboBoxDescriptionSupport;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.util.SubstanceUIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultComboBoxRenderer;

public class ChoiceKeyWidget
extends LabeledWidget
implements ItemListener,
ListDataListener,
ActionListener,
MouseListener {
    protected JComboBox<Choice> combobox;
    private KeyWidget.AutoValueLinkButton linkButton;
    private ListCellRenderer<? super Choice> defaultRenderer;
    private ComboBoxEditor defaultEditor;
    private ListCellRenderer<? super Choice> rendererCache;
    private ComboBoxEditor editorCache;
    private EmptyMessageHandler emptyMessageHandler;
    private ComboBoxPopupMenuListener popupMenuListener;
    private DescriptionHandler descriptionHandler;

    public ChoiceKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        Component component;
        Object object;
        this.setLayout(new BorderLayout());
        this.combobox = new JComboBox(new ChoiceComboboxModel());
        this.combobox.putClientProperty("substancelaf.comboxautoresize", Boolean.TRUE);
        this.combobox.setFont(new Font("Monospaced", 0, this.combobox.getFont().getSize()));
        this.combobox.getModel().addListDataListener(this);
        this.defaultRenderer = this.combobox.getRenderer();
        this.defaultEditor = this.combobox.getEditor();
        this.combobox.setEditable(this.getKey().isChoiceEditable());
        ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)this.combobox.getModel();
        choiceComboboxModel.setData(this.getInitialChoiceValues());
        this.combobox.setSelectedItem(new Choice(this.getKeyValue().toString()));
        if (!this.getKey().isChoiceEditable() && this.combobox.getSelectedItem() == null && this.combobox.getItemCount() > 0) {
            this.combobox.setSelectedIndex(0);
        }
        if (this.getKey().isLabel()) {
            if (this.rendererCache == null) {
                this.rendererCache = this.createRenderer();
            }
            this.combobox.setRenderer(this.rendererCache);
        } else {
            this.combobox.setRenderer(this.defaultRenderer);
        }
        if (this.getKey().isChoiceEditable()) {
            if (this.editorCache == null) {
                this.editorCache = this.createComboBoxEditor();
            }
            this.combobox.setEditor(this.editorCache);
        } else {
            this.combobox.setEditor(this.defaultEditor);
        }
        if (this.getKey().isChoiceEditable()) {
            if (this.getKey().isDynamicDefault() || this.getKey().isEmptyMessage()) {
                this.emptyMessageHandler = new EmptyMessageHandler();
                this.refreshEmptyMessage();
            }
            if (this.getKey().getDescriptionLink() != null) {
                this.descriptionHandler = new DescriptionHandler();
                this.refreshDescription(null);
            }
        }
        if (this.getKey().getAutoValueLink() != null) {
            if (!this.getKey().getAutoValueLink().isHidden()) {
                this.linkButton = this.createAutoValueLinkButton();
                object = new JPanel(new BorderLayout());
                ((JComponent)object).setBorder(new EmptyBorder(0, 4, 0, 0));
                ((Container)object).add(this.linkButton);
                this.add((Component)object, "East");
                if (this.combobox.isEditable()) {
                    component = this.combobox.getEditor().getEditorComponent();
                    if (component instanceof JTextComponent) {
                        ((JTextComponent)component).getDocument().addDocumentListener(this.createAutoValueDocumentListener(this.linkButton));
                    }
                    this.refreshAutoValueLinkColor();
                }
            } else if (this.linkButton != null) {
                this.remove(this.linkButton);
                this.linkButton = null;
            }
        } else if (this.linkButton != null) {
            this.remove(this.linkButton);
            this.linkButton = null;
        }
        if (!this.getKey().isChoiceEditable() && !ObjectUtils.equals((Object)this.getKeyValue(), (Object)this.combobox.getSelectedItem())) {
            this.update();
        }
        this.combobox.addItemListener(this);
        this.combobox.addActionListener(this);
        if (this.popupMenuListener != null) {
            this.combobox.removePopupMenuListener(this.popupMenuListener);
        }
        if (this.getKey().getChoiceProvider() != null) {
            if (this.popupMenuListener == null) {
                this.popupMenuListener = new ComboBoxPopupMenuListener();
            }
            this.combobox.addPopupMenuListener(this.popupMenuListener);
        }
        if (this.combobox.isEditable() && (object = SubstanceUIUtility.getComboArrowButton(this.combobox)) != null) {
            ((Component)object).addMouseListener(this);
        }
        if (this.getKey().isDescription().booleanValue()) {
            new ComboBoxDescriptionSupport(this.combobox);
        }
        this.add(this.createLayer(this.combobox));
        if (this.getKey().isChoiceEditable() && (object = this.combobox.getEditor()) instanceof ChoiceComboBoxEditor) {
            component = (ChoiceComboxTextField)object.getEditorComponent();
            ((JTextFieldEx)component).getUndoManager().discardAllEdits();
        }
    }

    protected List<Choice> getInitialChoiceValues() {
        if (this.getKey().isChoiceEditable() && this.getKey().getChoiceProvider() != null) {
            return new ArrayList<Choice>(0);
        }
        return this.getKey().getChoices(this.getValueMap());
    }

    protected ListCellRenderer<? super Choice> createRenderer() {
        return new SubstanceChoiceRenderer(this.combobox);
    }

    protected ComboBoxEditor createComboBoxEditor() {
        return new ChoiceComboBoxEditor();
    }

    public ChoiceKey getKey() {
        return (ChoiceKey)super.getKey();
    }

    @Override
    protected Object getValue() {
        if (this.combobox.isEditable() && this.combobox.getEditor() != null) {
            return this.combobox.getEditor().getItem().toString();
        }
        Object object = this.combobox.getSelectedItem();
        return object == null ? "" : object.toString();
    }

    @Override
    public void updateWidget() {
        ChoiceKey choiceKey = this.getKey();
        if (this.combobox == null) {
            return;
        }
        ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)this.combobox.getModel();
        choiceComboboxModel.setData(choiceKey.getChoices(this.getValueMap()));
        if (this.combobox.isEditable()) {
            this.combobox.getEditor().setItem(new Choice(this.getKeyValue().toString()));
        }
        this.combobox.setSelectedItem(new Choice(this.getKeyValue().toString()));
        if (!this.combobox.isEditable() && this.combobox.getSelectedItem() == null) {
            this.combobox.setSelectedIndex(0);
        }
        if (choiceKey.getIndexOf((String)this.getKeyValue()) < 0) {
            this.updateQuietly();
        }
    }

    @Override
    public boolean startEditing() {
        this.combobox.requestFocusInWindow();
        return true;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TextSearchResult) || this.combobox == null || !this.combobox.isEditable()) {
            return;
        }
        Component component = this.combobox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            TextSearchResult textSearchResult = (TextSearchResult)searchResult;
            ((JTextComponent)component).select(textSearchResult.getOffset(), textSearchResult.getEnd());
            this.combobox.requestFocusInWindow();
        }
    }

    @Override
    public void clearSelection() {
        if (this.combobox == null) {
            return;
        }
        Component component = this.combobox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).select(0, 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.update();
        }
    }

    @Override
    protected boolean supportsAutoValueLink() {
        return true;
    }

    @Override
    protected void autoValueLinkChanged() {
        if (this.linkButton != null) {
            this.linkButton.updateWidget();
        }
        super.autoValueLinkChanged();
    }

    @Override
    protected void autoValueLinkStateChanged() {
        super.autoValueLinkStateChanged();
        SwingUtilities.invokeLater(() -> this.refreshAutoValueLinkColor());
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        if (this.emptyMessageHandler != null) {
            this.refreshEmptyMessage();
            this.getValueMap().addEventHandler(this.emptyMessageHandler);
        }
        if (this.descriptionHandler != null) {
            this.refreshDescription(null);
            this.getValueMap().addEventHandler(this.descriptionHandler);
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.emptyMessageHandler != null) {
            this.getValueMap().removeEventHandler(this.emptyMessageHandler);
        }
        if (this.descriptionHandler != null) {
            this.getValueMap().removeEventHandler(this.descriptionHandler);
        }
    }

    protected void refreshEmptyMessage() {
        if (!this.combobox.isEditable()) {
            return;
        }
        Component component = this.combobox.getEditor().getEditorComponent();
        if (component instanceof ChoiceComboxTextField) {
            ChoiceComboxTextField choiceComboxTextField = (ChoiceComboxTextField)component;
            if (this.getKey().isDynamicDefault()) {
                choiceComboxTextField.updateDescription();
            } else {
                choiceComboxTextField.setEmptyMessage(this.getKey().getEmptyMessage(this.getValueMap()));
            }
            this.combobox.repaint();
        }
    }

    protected void refreshDescription(Key<?> key) {
        Component component;
        if (!this.combobox.isEditable()) {
            return;
        }
        DescriptionLink descriptionLink = this.getKey().getDescriptionLink();
        if (descriptionLink != null && (key == null || descriptionLink.contains(key.getId())) && (component = this.combobox.getEditor().getEditorComponent()) instanceof ChoiceComboxTextField) {
            ((ChoiceComboxTextField)component).setDescription(this.getKey().getDescriptionMessage(this.getValueMap()));
        }
    }

    protected void refreshAutoValueLinkColor() {
        if (this.combobox.isEditable()) {
            Component component = this.combobox.getEditor().getEditorComponent();
            component.setForeground(this.isAutoValueLinkEnabled() ? WidgetConstants.AUTO_FONT_COLOR : null);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        JList<?> jList;
        if (listDataEvent.getIndex0() == -2 && (jList = SubstanceUIUtility.getComboList(this.combobox)) != null) {
            jList.clearSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)this.combobox.getModel();
        if (this.combobox.isEditable()) {
            choiceComboboxModel.clearFilter();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class EmptyMessageHandler
    implements ValueChangeEventHandler {
        private EmptyMessageHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            ChoiceKeyWidget.this.refreshEmptyMessage();
        }
    }

    private class DescriptionHandler
    implements ValueChangeEventHandler {
        private DescriptionHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            ChoiceKeyWidget.this.refreshDescription(valueChangeEvent.getKey());
        }
    }

    private class ComboBoxPopupMenuListener
    implements PopupMenuListener {
        private ComboBoxPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JComboBox jComboBox = (JComboBox)Utility.cast(popupMenuEvent.getSource());
            ChoiceComboboxModel choiceComboboxModel = (ChoiceComboboxModel)jComboBox.getModel();
            Object object = jComboBox.isEditable() ? ChoiceKeyWidget.this.combobox.getEditor().getItem() : null;
            choiceComboboxModel.setData(ChoiceKeyWidget.this.getKey().getChoiceProvider().getChoices(ChoiceKeyWidget.this.getValueMap()), object);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class ChoiceComboBoxEditor
    extends BasicComboBoxEditor {
        private ChoiceComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            ChoiceComboxTextField choiceComboxTextField = new ChoiceComboxTextField();
            return choiceComboxTextField;
        }

        @Override
        public Object getItem() {
            String string = this.editor.getText();
            return new Choice(string);
        }
    }

    private class ChoiceComboxTextField
    extends JTextFieldEx
    implements DocumentListener {
        public ChoiceComboxTextField() {
            super("");
            this.getDocument().addDocumentListener(this);
            this.setOpaque(false);
            this.updateDescription();
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }

        private void updateDescription() {
            if (!ChoiceKeyWidget.this.getKey().isLabel()) {
                return;
            }
            String string = null;
            Color color = this.getDescriptionColor();
            String string2 = this.getText();
            String string3 = ChoiceKeyWidget.this.getKey().getLabel(string2, ChoiceKeyWidget.this.getValueMap());
            if (!StringUtils.isEmpty((CharSequence)string3)) {
                string = "(" + string3 + ")";
                color = string2.isEmpty() && ChoiceKeyWidget.this.getKey().isDynamicDefault() ? WidgetConstants.AUTO_FONT_COLOR : WidgetConstants.INFO_FONT_COLOR;
            }
            this.setDescriptionColor(color);
            this.setDescription(string);
        }

        @Override
        public void fireActionPerformed() {
            super.fireActionPerformed();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateDescription();
            ChoiceKeyWidget.this.getDelayedUpdater().requestAction();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateDescription();
            ChoiceKeyWidget.this.getDelayedUpdater().requestAction();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class SubstanceChoiceRenderer
    extends SubstanceDefaultComboBoxRenderer {
        public SubstanceChoiceRenderer(JComboBox<?> jComboBox) {
            super(jComboBox);
        }

        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Choice choice;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof String) {
                choice = ChoiceKeyWidget.this.getKey().getChoice((String)object);
                object = choice == null ? new Choice(object.toString()) : choice;
            }
            choice = (Choice)object;
            this.setText(this.valueToRepresentation(choice, bl));
            this.setIcon(choice == null ? null : choice.getIcon());
            Map<String, String> map = ChoiceKeyWidget.this.getKey().getRequiredRPackageMap();
            if (map != null) {
                this.setToolTipText(null);
                if (map.containsKey(object.toString())) {
                    String string = map.get(object.toString());
                    if (!R.client().isInstalledPackage(string)) {
                        this.setIcon(Icons.getIcon("16/error.png"));
                        this.setHorizontalTextPosition(2);
                        this.setToolTipText(Messages.getString("Error.missing_r_package") + ": " + string);
                    }
                }
            }
            return this;
        }

        private String valueToRepresentation(Choice choice, boolean bl) {
            String string = choice == null ? "" : choice.getValue();
            Object object = choice.getLabel();
            if (StringUtils.isEmpty((CharSequence)object)) {
                return string;
            }
            if (ChoiceKeyWidget.this.getKey().showValueAndLabel()) {
                object = bl ? string + " (" + (String)object + ")" : "<html>" + string + " <font color=\"#808080\">(" + (String)object + ")</font></html>";
            }
            if (StringUtils.isEmpty((CharSequence)object)) {
                object = " ";
            }
            return object;
        }
    }
}

