/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.ui.common.component.ListRollOverSelectionHandler;
import com.ef_prime.rflow.ui.util.SubstanceUIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.html.HTMLDocument;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.autocomplete.DescriptionListener;
import org.fife.ui.autocomplete.Util;

public class ComboBoxDescriptionSupport
implements PopupMenuListener,
ListSelectionListener {
    private JComboBox<Choice> combobox;
    private DescriptionPane descriptionPane;

    public ComboBoxDescriptionSupport(JComboBox<Choice> jComboBox) {
        this.combobox = jComboBox;
        jComboBox.addPopupMenuListener(this);
        ComboPopup comboPopup = SubstanceUIUtility.getComboPopup(jComboBox);
        if (comboPopup instanceof JPopupMenu) {
            ((JPopupMenu)((Object)comboPopup)).putClientProperty("SubstanceComboPopup.MIN_HEIGHT_PROPERTY", new Integer(200));
            ((JPopupMenu)((Object)comboPopup)).setLayout((LayoutManager)new MigLayout(new LC().insetsAll("0").fill().flowY()));
            this.descriptionPane = new DescriptionPane();
            JScrollPane jScrollPane = new JScrollPane(this.descriptionPane);
            jScrollPane.setBorder(null);
            jScrollPane.setViewportBorder(null);
            jScrollPane.setVerticalScrollBarPolicy(22);
            ((JPopupMenu)((Object)comboPopup)).add((Component)jScrollPane, "dock east, w 500, h 200");
            JList<?> jList = SubstanceUIUtility.getComboList(jComboBox);
            jList.addListSelectionListener(this);
            ListRollOverSelectionHandler listRollOverSelectionHandler = new ListRollOverSelectionHandler();
            listRollOverSelectionHandler.install(jList);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        Object e = jList.getSelectedValue();
        if (e instanceof Choice && this.combobox.isShowing() && this.descriptionPane != null) {
            this.descriptionPane.setDescription((Choice)e);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        ComboPopup comboPopup;
        if (this.descriptionPane != null && (comboPopup = SubstanceUIUtility.getComboPopup(this.combobox)) != null) {
            Choice choice = (Choice)comboPopup.getList().getSelectedValue();
            this.descriptionPane.setDescription(choice);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    private static class DescriptionPane
    extends JEditorPane {
        private Timer timer;
        private SetDescriptionAction action;

        public DescriptionPane() {
            super("text/html", "<html></html>");
            this.setEditable(false);
            this.setFocusable(false);
            this.getCaret().setSelectionVisible(true);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Color color = UIManager.getColor("Label.foreground");
            if (color == null) {
                color = SystemColor.textText;
            }
            this.setForeground(color);
            Font font = UIManager.getFont("Label.font");
            if (font == null) {
                font = new Font("SansSerif", 0, 12);
            }
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            hTMLDocument.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: " + Util.getHexString((Color)color) + "; }");
            this.action = new SetDescriptionAction();
            this.timer = new Timer(80, this.action);
            this.timer.setRepeats(false);
        }

        public void setDescription(Choice choice) {
            this.timer.stop();
            this.action.setChoice(choice);
            this.timer.start();
        }

        private class SetDescriptionAction
        implements ActionListener {
            private Choice choice;
            private String description;

            private SetDescriptionAction() {
            }

            public void setChoice(Choice choice) {
                this.choice = choice;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = string = this.choice == null ? null : this.choice.getDescription();
                if (string != this.description) {
                    if (string == null || string.isEmpty()) {
                        string = "<html></html>";
                    }
                    DescriptionPane.this.setText(string);
                }
                this.description = string;
                DescriptionPane.this.setCaretPosition(0);
                if (this.choice instanceof DescriptionListener) {
                    ((DescriptionListener)this.choice).descriptionDidSet((JEditorPane)DescriptionPane.this);
                }
            }
        }
    }
}

