/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.ComponentTableKey;
import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.list.ListEvent;
import com.ef_prime.rflow.core.common.list.ListEventHandler;
import com.ef_prime.rflow.core.common.list.ListModel;
import com.ef_prime.rflow.core.feature.search.ListSearchResult;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.node.ui.OpManager;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.DisplayableListener;
import com.ef_prime.rflow.ui.common.component.SafeUndoManager;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class ComponentTableKeyWidget
extends LabeledWidget
implements PropertyChangeListener {
    private static final String FOCUS_OWNER = "focusOwner";
    private static final Logger LOGGER = Logger.getLogger(ComponentTableKeyWidget.class.getName());
    protected ComponentTable table;
    protected ComponentTableActions actions;
    private boolean lockFocusSelection;
    private UndoManager undoManager;
    private UndoableEditSupport undoableEditSupport;
    private int estimatedHeight = 30;

    public ComponentTableKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    public ComponentTableKey getKey() {
        return (ComponentTableKey)super.getKey();
    }

    protected ListModel<ValueMap> getListModel() {
        return (ListModel)this.getKeyValue();
    }

    protected UndoableEditSupport getUndoableEditSupport() {
        return this.undoableEditSupport;
    }

    @Override
    protected void loadContent() {
        this.undoManager = new SafeUndoManager();
        this.undoableEditSupport = new UndoableEditSupport();
        this.undoableEditSupport.addUndoableEditListener(this.undoManager);
        this.setLayout(new BorderLayout());
        this.table = new ComponentTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().addChangeListener(this.table);
        this.actions = this.createActions();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        this.configureToolBar(jToolBar);
        this.add((Component)jToolBar, "West");
        this.add((Component)jScrollPane, "Center");
        this.actions.installActions(this, false, 1);
        this.actions.installActions(this.table, false, 1);
        this.updateWidgetValue();
    }

    public ComponentTable getTable() {
        return this.table;
    }

    protected ComponentTableActions createActions() {
        return new ComponentTableActions();
    }

    protected void configureToolBar(JToolBar jToolBar) {
        jToolBar.add(this.createButton(ComponentTableActions.Add.class));
        jToolBar.add(this.createButton(ComponentTableActions.Remove.class));
        jToolBar.add(this.createButton(ComponentTableActions.Up.class));
        jToolBar.add(this.createButton(ComponentTableActions.Down.class));
    }

    protected JButton createButton(Object object) {
        Action action = this.actions.get(object);
        JButton jButton = new JButton(action);
        jButton.setHideActionText(true);
        jButton.setToolTipText((String)action.getValue("Name"));
        jButton.setFocusable(false);
        return jButton;
    }

    @Override
    public void updateImmediately() {
        super.updateImmediately();
        if (this.table != null) {
            this.table.updateImmediately();
        }
    }

    @Override
    public void updateWidget() {
        if (this.table != null && this.table.getModel() != this.getKeyValue()) {
            this.table.setModel(this.getListModel());
        }
    }

    @Override
    protected Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUS_OWNER, this);
        this.updateWidget();
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FOCUS_OWNER, this);
        if (this.table != null) {
            this.table.unloadModel();
        }
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof ListSearchResult) || this.table == null) {
            return;
        }
        this.table.select((ListSearchResult)searchResult);
    }

    @Override
    public void clearSelection() {
        if (this.table != null) {
            this.table.clearWholeSelection();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.lockFocusSelection) {
            return;
        }
        if (FOCUS_OWNER.equals(propertyChangeEvent.getPropertyName())) {
            if (this.table == null) {
                return;
            }
            if (propertyChangeEvent.getNewValue() instanceof Component) {
                Component component;
                for (Component component2 = component = (Component)propertyChangeEvent.getNewValue(); component2 != null; component2 = component2.getParent()) {
                    if (component2 instanceof ComponentEntryPanel) {
                        if (component2 != component) {
                            this.table.setSelectedComponent((ComponentEntryPanel)component2);
                        }
                        this.table.setFocusOwner(component2);
                        return;
                    }
                    if (!(component2 instanceof ComponentTable)) continue;
                    this.table.setFocusOwner(component2);
                    return;
                }
            }
            this.table.setFocusOwner(null);
        }
    }

    protected class ComponentTable
    extends JPanel
    implements Scrollable,
    ListEventHandler,
    MouseListener,
    ComponentListener,
    ListSelectionListener,
    ChangeListener {
        private ListModel<ValueMap> model;
        private ValueMap previewEntry;
        private ComponentEntryPanel previewPanel;
        private Component focusOwner;
        private DefaultListSelectionModel selectionModel;
        private Color selectedBackground;
        private Color selectedBackgroundEditing;
        private Color selectedBackgroundNoFocus;

        public ComponentTable() {
            super((LayoutManager)new MigLayout(new LC().fillX().flowY().gridGap("0", "0").insets("0"), new AC().fill()));
            this.selectionModel = new DefaultListSelectionModel();
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(new JList(), (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)ComponentState.SELECTED);
            this.selectedBackground = SubstanceColorUtilities.getTopShineColor((SubstanceColorScheme)substanceColorScheme);
            this.selectedBackgroundEditing = SubstanceColorUtilities.getLighterColor((Color)this.selectedBackground, (double)0.4);
            this.selectedBackgroundNoFocus = SubstanceColorUtilities.getInterpolatedColor((Color)this.selectedBackgroundEditing, (Color)new Color(230, 230, 230), (double)0.2);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                protected boolean accept(Component component) {
                    return super.accept(component) && !(component instanceof ComponentEntryPanel);
                }
            });
            this.setFocusTraversalPolicyProvider(true);
            this.selectionModel.addListSelectionListener(this);
            this.setFocusable(true);
            this.addMouseListener(this);
        }

        public ListModel<ValueMap> getModel() {
            return this.model;
        }

        public void setModel(ListModel<ValueMap> listModel) {
            this.unloadModel();
            this.model = listModel;
            if (listModel.getSize() > 0) {
                int n;
                int[] nArray = new int[listModel.getSize()];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = n;
                }
                this.addContents(nArray);
                n = Math.min(10, this.getComponentCount());
                for (int i = 0; i < n; ++i) {
                    this.getEntryPanel(i).loadContent();
                }
            }
            listModel.addEventHandler(this);
            this.revalidate();
            this.repaint();
        }

        public void unloadModel() {
            if (this.model != null) {
                this.model.removeEventHandler(this);
            }
            this.removeAll();
            this.selectionModel.clearSelection();
            this.model = null;
        }

        public void setPreviewEntry(ValueMap valueMap) {
            if (this.previewEntry != valueMap) {
                if (this.previewPanel != null) {
                    this.remove(this.previewPanel);
                    this.previewPanel = null;
                }
                this.previewEntry = valueMap;
                if (this.previewEntry != null) {
                    this.previewPanel = this.addContent(this.previewEntry, this.getComponentCount(), true);
                    this.previewPanel.setPreview(true);
                    this.previewPanel.loadContent();
                }
                this.revalidate();
                this.repaint();
            }
        }

        public int getComponentIndex(ComponentEntryPanel componentEntryPanel) {
            int n = -1;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (this.getComponent(i) != componentEntryPanel) continue;
                n = i;
                break;
            }
            return n;
        }

        public void setSelectedComponent(ComponentEntryPanel componentEntryPanel) {
            int n = this.getComponentIndex(componentEntryPanel);
            if (n >= 0) {
                this.setSelectedIndex(n);
            }
        }

        public void toggleSelectedComponent(ComponentEntryPanel componentEntryPanel) {
            int n = this.getComponentIndex(componentEntryPanel);
            if (n >= 0) {
                if (this.selectionModel.isSelectedIndex(n)) {
                    this.removeSelectedIndex(n);
                } else {
                    this.addSelectedIndex(n);
                }
            }
        }

        public void clearSelection() {
            this.selectionModel.clearSelection();
        }

        public void clearWholeSelection() {
            this.selectionModel.clearSelection();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getEntryPanel(i).clearSelection();
            }
        }

        public void selectAll() {
            this.selectionModel.addSelectionInterval(0, this.getComponentCount() - 1);
        }

        public void setSelectedIndex(int n) {
            this.selectionModel.setSelectionInterval(n, n);
        }

        public void setSelectedIndices(int[] nArray) {
            this.selectionModel.setValueIsAdjusting(true);
            this.selectionModel.clearSelection();
            int[][] nArray2 = ListModel.getIntervals(nArray);
            for (int i = 0; i < nArray2.length; ++i) {
                int[] nArray3 = nArray2[i];
                this.selectionModel.addSelectionInterval(nArray3[0], nArray3[1]);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }

        public void addSelectedIndex(int n) {
            this.selectionModel.addSelectionInterval(n, n);
        }

        public void removeSelectedIndex(int n) {
            this.selectionModel.removeSelectionInterval(n, n);
        }

        public int[] getSelections() {
            int n = this.selectionModel.getMinSelectionIndex();
            int n2 = this.selectionModel.getMaxSelectionIndex();
            if (n < 0 || n2 < 0) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n2 - n)];
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                nArray[n3++] = i;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }

        public boolean isSelectionEmpty() {
            return this.selectionModel.isSelectionEmpty();
        }

        public void moveSelection(boolean bl) {
            if (this.isSelectionEmpty()) {
                if (this.getComponentCount() > 0) {
                    this.setSelectedIndex(0);
                }
            } else {
                this.setSelectedIndex(this.nextIndex(bl));
            }
        }

        public void extendSelection(boolean bl) {
            if (this.isSelectionEmpty()) {
                if (this.getComponentCount() > 0) {
                    this.setSelectedIndex(0);
                }
            } else {
                this.selectionModel.setSelectionInterval(this.selectionModel.getAnchorSelectionIndex(), this.nextIndex(bl));
            }
        }

        private int nextIndex(boolean bl) {
            int n = this.selectionModel.getLeadSelectionIndex();
            n = bl ? ++n : --n;
            n = Math.min(this.getComponentCount() - 1, n);
            n = Math.max(0, n);
            return n;
        }

        public void startEditing() {
            if (this.isSelectionEmpty()) {
                return;
            }
            this.getEntryPanel(this.selectionModel.getLeadSelectionIndex()).startEditing();
        }

        public void updateImmediately() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getEntryPanel(i).updateImmediately();
            }
        }

        public void setFocusOwner(Component component) {
            if (this.focusOwner != component) {
                this.focusOwner = component;
                this.repaint();
            }
        }

        public Component getFocusOwner() {
            return this.focusOwner;
        }

        public ComponentEntryPanel getEntryPanel(int n) {
            return (ComponentEntryPanel)this.getComponent(n);
        }

        public void scrollTo(int n) {
            ComponentEntryPanel componentEntryPanel = this.getEntryPanel(n);
            this.scrollRectToVisible(componentEntryPanel.getBounds());
        }

        public void select(ListSearchResult listSearchResult) {
            int n = listSearchResult.getIndex();
            if (n < 0 || n >= this.getComponentCount()) {
                return;
            }
            ComponentEntryPanel componentEntryPanel = this.getEntryPanel(n);
            Component component = componentEntryPanel.getContent();
            if (!(component instanceof Widget)) {
                return;
            }
            Widget widget = (Widget)component;
            widget.select(listSearchResult.getResult());
            this.scrollTo(n);
        }

        public void loadVisibleEntryPanelContents() {
            Rectangle rectangle = this.getVisibleRect();
            int n = rectangle.y;
            int n2 = rectangle.y + rectangle.height;
            int n3 = this.getComponentCount();
            HashMultiset hashMultiset = HashMultiset.create();
            for (int i = 0; i < n3; ++i) {
                ComponentEntryPanel componentEntryPanel = this.getEntryPanel(i);
                if (componentEntryPanel.isContentLoaded()) {
                    hashMultiset.add((Object)componentEntryPanel.getHeight());
                    continue;
                }
                Rectangle rectangle2 = componentEntryPanel.getBounds();
                if (rectangle2.height == 0) continue;
                int n4 = rectangle2.y;
                int n5 = rectangle2.y + rectangle2.height;
                if ((n4 < n || n4 > n2) && (n5 < n || n5 > n2)) continue;
                componentEntryPanel.loadContent();
            }
            if (hashMultiset.size() > 0 && hashMultiset.size() < n3) {
                Integer n6 = (Integer)Multisets.copyHighestCountFirst((Multiset)hashMultiset).iterator().next();
                ComponentTableKeyWidget.this.estimatedHeight = n6;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n == 1 ? rectangle.height : rectangle.width;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.getMinimumSize().width < this.getParent().getWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getMinimumSize().height < this.getParent().getHeight();
        }

        private ComponentEntryPanel addContent(ValueMap valueMap, int n, boolean bl) {
            ComponentEntryPanel componentEntryPanel = new ComponentEntryPanel(valueMap);
            componentEntryPanel.addMouseListener(this);
            if (bl) {
                componentEntryPanel.addComponentListener(this);
            }
            if (n >= this.getComponentCount()) {
                this.add(componentEntryPanel);
            } else {
                this.add((Component)componentEntryPanel, n);
            }
            return componentEntryPanel;
        }

        private void addContents(int[] nArray) {
            Object object = nArray;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                int n2 = object[i];
                this.addContent((ValueMap)this.model.get(n2), n2, false);
            }
            this.selectionModel.setValueIsAdjusting(true);
            for (int n3 : object = (Object)ListModel.getIntervals(nArray)) {
                this.selectionModel.insertIndexInterval((int)n3[0], (int)(n3[1] - n3[0]), true);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }

        private void removeContents(int[] nArray) {
            int[][] nArray2;
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.remove(nArray[i]);
            }
            this.selectionModel.setValueIsAdjusting(true);
            for (int[] nArray3 : nArray2 = ListModel.getIntervals(nArray)) {
                this.selectionModel.removeIndexInterval(nArray3[0], nArray3[1]);
            }
            this.selectionModel.setValueIsAdjusting(false);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void contentsAdded(final ListEvent listEvent) {
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int[] nArray = listEvent.getIndices();
                    ComponentTable.this.addContents(nArray);
                    ComponentTable.this.revalidate();
                    ComponentTable.this.repaint();
                    ComponentTableKeyWidget.this.undoableEditSupport.postEdit(new AddEdit(nArray, listEvent.getRemoved()));
                    SwingUtilities.invokeLater(() -> {
                        ComponentTable.this.loadVisibleEntryPanelContents();
                        ComponentTable.this.scrollTo(nArray[nArray.length - 1]);
                    });
                }
            });
        }

        @Override
        public void contentsRemoved(final ListEvent listEvent) {
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComponentTable.this.removeContents(listEvent.getIndices());
                    ComponentTableKeyWidget.this.undoableEditSupport.postEdit(new RemoveEdit(listEvent.getIndices(), listEvent.getRemoved()));
                    if (ComponentTable.this.getComponentCount() == 0) {
                        ComponentTable.this.requestFocusInWindow();
                    }
                }
            });
        }

        @Override
        public void contentsChanged(ListEvent listEvent) {
            this.repaint();
        }

        @Override
        public void contentsMoved(final ListEvent listEvent) {
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int[] nArray = listEvent.getIndices();
                    int n = nArray[0];
                    int n2 = nArray[1];
                    ComponentTableKeyWidget.this.lockFocusSelection = true;
                    ComponentEntryPanel componentEntryPanel = (ComponentEntryPanel)ComponentTable.this.getComponent(n);
                    ComponentTable.this.remove(n);
                    ComponentTable.this.add((Component)componentEntryPanel, n2);
                    ComponentTable.this.setSelectedComponent(componentEntryPanel);
                    componentEntryPanel.requestFocusInWindow();
                    ComponentTable.this.revalidate();
                    ComponentTable.this.repaint();
                    ComponentTableKeyWidget.this.undoableEditSupport.postEdit(new MoveEdit(n, n2));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ComponentTableKeyWidget.this.lockFocusSelection = false;
                        }
                    });
                }
            });
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == this) {
                this.requestFocusInWindow();
            } else {
                ComponentEntryPanel componentEntryPanel = (ComponentEntryPanel)mouseEvent.getSource();
                if (UIUtility.isMenuKeyDown(mouseEvent)) {
                    this.toggleSelectedComponent(componentEntryPanel);
                } else if (mouseEvent.isShiftDown()) {
                    int n;
                    int n2 = this.getComponentIndex(componentEntryPanel);
                    if (n2 >= 0 && n2 != (n = this.selectionModel.getAnchorSelectionIndex()) && n >= 0) {
                        int n3 = n;
                        this.selectionModel.setSelectionInterval(n3, n2);
                    }
                } else {
                    this.setSelectedComponent(componentEntryPanel);
                }
                componentEntryPanel.requestFocusInWindow();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Component component = (Component)componentEvent.getSource();
            if (component.getSize().height > 0) {
                this.scrollRectToVisible(new Rectangle(0, this.getHeight(), 0, 0));
                component.removeComponentListener(this);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getEntryPanel(i).setSelected(this.selectionModel.isSelectedIndex(i));
            }
            ComponentTableKeyWidget.this.actions.updateState();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.loadVisibleEntryPanelContents();
        }
    }

    protected class ComponentTableActions
    extends Actions {
        public ComponentTableActions() {
            this.put(new Add());
            this.put(new Remove());
            this.put(new Up());
            this.put(new Down());
            this.put(new SelectNext());
            this.put(new SelectPrevious());
            this.put(new ExtendSelectNext());
            this.put(new ExtendSelectPrevious());
            this.put(new StartEditing());
            this.put(new SelectAll());
            this.put(new Undo());
            this.put(new Redo());
            this.updateState();
        }

        @Override
        public InputMap createInputMap() {
            InputMap inputMap = super.createInputMap();
            inputMap.put(KeyStroke.getKeyStroke(9, 0), SelectNext.class);
            inputMap.put(KeyStroke.getKeyStroke(9, 64), SelectPrevious.class);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), StartEditing.class);
            return inputMap;
        }

        protected void updateState() {
            boolean bl = !ComponentTableKeyWidget.this.table.isSelectionEmpty();
            this.get(Remove.class).setEnabled(bl);
        }

        public class Add
        extends AbstractAction
        implements MouseListener,
        MouseMotionListener,
        PopupMenuListener {
            public Add() {
                this.putValue("Name", Messages.getString("Action.add"));
                this.putValue("SmallIcon", Icons.getIcon("16/add.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValueMapKey valueMapKey = ComponentTableKeyWidget.this.getKey().getColumnKey();
                Map<String, String> map = valueMapKey.getClassMap();
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.addPopupMenuListener(this);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getValue();
                    try {
                        Operation operation = OpManager.getInstance().getInstance(string);
                        JMenuItem jMenuItem = jPopupMenu.add(new AddAction(operation));
                        jMenuItem.addMouseListener(this);
                        jMenuItem.addMouseMotionListener(this);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Failed to create a instance of " + string, exception);
                    }
                }
                if (actionEvent.getSource() instanceof Component) {
                    Component component = (Component)actionEvent.getSource();
                    jPopupMenu.show(component, 0, component.getHeight());
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ComponentTableKeyWidget.this.table.setPreviewEntry(null);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                JMenuItem jMenuItem = (JMenuItem)mouseEvent.getSource();
                AddAction addAction = (AddAction)jMenuItem.getAction();
                ComponentTableKeyWidget.this.table.setPreviewEntry(addAction.valueMap);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                ComponentTableKeyWidget.this.table.setPreviewEntry(null);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        }

        public class Remove
        extends AbstractAction {
            public Remove() {
                this.putValue("Name", Messages.getString("Action.delete"));
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ComponentTableKeyWidget.this.table.isSelectionEmpty()) {
                    return;
                }
                ComponentTableKeyWidget.this.table.requestFocusInWindow();
                int[] nArray = ComponentTableKeyWidget.this.table.getSelections();
                ComponentTableKeyWidget.this.getListModel().remove(nArray);
                int n = nArray[0];
                if (n >= ComponentTableKeyWidget.this.table.getComponentCount()) {
                    n = ComponentTableKeyWidget.this.table.getComponentCount() - 1;
                }
                if (n >= 0) {
                    int n2 = n;
                    ComponentTableKeyWidget.this.table.setSelectedIndex(n2);
                    SwingUtilities.invokeLater(() -> ComponentTableKeyWidget.this.table.getEntryPanel(n2).requestFocusInWindow());
                }
            }
        }

        public class Up
        extends AbstractAction {
            public Up() {
                this.putValue("Name", Messages.getString("Action.up"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_up.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int[] nArray = (int[])ComponentTableKeyWidget.this.table.getSelections().clone();
                if (nArray.length == 0 || nArray[0] == 0) {
                    return;
                }
                ComponentTableKeyWidget.this.table.clearSelection();
                for (int i = 0; i < nArray.length; ++i) {
                    n = nArray[i];
                    ComponentTableKeyWidget.this.getListModel().move(n, n - 1);
                }
                int[] nArray2 = new int[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = nArray[n] - 1;
                }
                ComponentTableKeyWidget.this.table.setSelectedIndices(nArray2);
            }
        }

        public class Down
        extends AbstractAction {
            public Down() {
                this.putValue("Name", Messages.getString("Action.down"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_down.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int[] nArray = ComponentTableKeyWidget.this.table.getSelections();
                if (nArray.length == 0 || nArray[nArray.length - 1] == ComponentTableKeyWidget.this.getListModel().getSize() - 1) {
                    return;
                }
                ComponentTableKeyWidget.this.table.clearSelection();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n = nArray[i];
                    ComponentTableKeyWidget.this.getListModel().move(n, n + 1);
                }
                int[] nArray2 = new int[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = nArray[n] + 1;
                }
                ComponentTableKeyWidget.this.table.setSelectedIndices(nArray2);
            }
        }

        private class SelectNext
        extends AbstractAction {
            public SelectNext() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.table.moveSelection(true);
            }
        }

        private class SelectPrevious
        extends AbstractAction {
            public SelectPrevious() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.table.moveSelection(false);
            }
        }

        private class ExtendSelectNext
        extends AbstractAction {
            public ExtendSelectNext() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 64));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.table.extendSelection(true);
            }
        }

        private class ExtendSelectPrevious
        extends AbstractAction {
            public ExtendSelectPrevious() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 64));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.table.extendSelection(false);
            }
        }

        private class StartEditing
        extends AbstractAction {
            public StartEditing() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.table.startEditing();
            }
        }

        private class SelectAll
        extends AbstractAction {
            public SelectAll() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.table.selectAll();
            }
        }

        private class Undo
        extends AbstractAction {
            public Undo() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ComponentTableKeyWidget.this.undoManager.canUndo()) {
                    ComponentTableKeyWidget.this.undoManager.undo();
                }
            }
        }

        private class Redo
        extends AbstractAction {
            public Redo() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ComponentTableKeyWidget.this.undoManager.canRedo()) {
                    ComponentTableKeyWidget.this.undoManager.redo();
                }
            }
        }

        private class AddAction
        extends AbstractAction {
            private ValueMap valueMap;

            public AddAction(ValueMap valueMap) {
                if (valueMap instanceof Operation) {
                    Operation operation = (Operation)valueMap;
                    this.putValue("Name", operation.getTitle());
                    this.putValue("SmallIcon", operation.getSmallIcon());
                }
                this.valueMap = valueMap;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTableKeyWidget.this.getListModel().add(this.valueMap);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComponentTableKeyWidget.this.table.setSelectedIndex(ComponentTableKeyWidget.this.table.getComponentCount() - 1);
                        ComponentTableKeyWidget.this.table.startEditing();
                    }
                });
            }
        }
    }

    private class ComponentEntryPanel
    extends JPanel
    implements ValueChangeEventHandler {
        private ValueMap entry;
        private Component content;
        private boolean selected;
        private boolean preview;
        private ValueError error;

        public ComponentEntryPanel(ValueMap valueMap) {
            this.entry = valueMap;
            this.setFocusable(true);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(4, 20, 4, 10));
            this.setFocusTraversalKeysEnabled(false);
            this.addHierarchyListener(new DisplayableHandler());
            this.refershError();
        }

        public boolean isContentLoaded() {
            return this.content != null;
        }

        public void loadContent() {
            if (this.content == null) {
                this.content = WidgetFactory.getInstance().create(this.entry);
                if (this.content instanceof JComponent) {
                    ((JComponent)this.content).setOpaque(false);
                }
                this.add(this.content, "Center");
            }
        }

        public Component getContent() {
            if (!this.isContentLoaded()) {
                this.loadContent();
            }
            return this.content;
        }

        public void setSelected(boolean bl) {
            if (this.selected != bl) {
                this.selected = bl;
                this.repaint();
            }
        }

        public void setPreview(boolean bl) {
            this.preview = bl;
            this.setOpaque(!bl);
        }

        public void updateImmediately() {
            if (this.content instanceof Widget) {
                ((Widget)this.content).updateImmediately();
            }
        }

        private void startEditing() {
            if (this.content == null) {
                this.loadContent();
            }
            if (this.content instanceof Widget) {
                ((Widget)this.content).startEditing();
            } else {
                this.content.requestFocusInWindow();
            }
        }

        public void clearSelection() {
            if (this.content == null) {
                return;
            }
            if (this.content instanceof Widget) {
                ((Widget)this.content).clearSelection();
            }
        }

        private void refershError() {
            List<ValueError> list = this.entry.getValidationContext().getError(null);
            this.error = CompoundValueError.convert(list);
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.content == null) {
                return new Dimension(100, ComponentTableKeyWidget.this.estimatedHeight);
            }
            return super.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.content == null) {
                return new Dimension(100, ComponentTableKeyWidget.this.estimatedHeight);
            }
            return super.getPreferredSize();
        }

        @Override
        public Color getBackground() {
            if (this.selected) {
                if (ComponentTableKeyWidget.this.table.getFocusOwner() != null) {
                    return ComponentTableKeyWidget.this.table.getFocusOwner() == this && !this.hasFocus() ? ComponentTableKeyWidget.this.table.selectedBackgroundEditing : ComponentTableKeyWidget.this.table.selectedBackground;
                }
                return ComponentTableKeyWidget.this.table.selectedBackgroundNoFocus;
            }
            return super.getBackground();
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.preview) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                super.paint(graphics2D);
                graphics2D.dispose();
            } else {
                super.paint(graphics);
                if (this.error != null) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setComposite(AlphaComposite.getInstance(10, 0.7f));
                    int n = 1;
                    int n2 = 8;
                    graphics2D.setPaint(WidgetConstants.getErrorColor(this.error));
                    graphics2D.fillPolygon(new int[]{n, n + n2, n}, new int[]{n, n, n + n2}, 3);
                    graphics2D.dispose();
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            if (this.error != null && mouseEvent.getX() < 15 && mouseEvent.getY() < 15) {
                return UIUtility.convertToHTML(this.error.getMessage(false, false));
            }
            return null;
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            this.refershError();
        }

        private class DisplayableHandler
        extends DisplayableListener {
            private DisplayableHandler() {
            }

            @Override
            protected void didBecomeDisplayable(HierarchyEvent hierarchyEvent) {
                ComponentEntryPanel.this.entry.addEventHandler(ComponentEntryPanel.this);
                ToolTipManager.sharedInstance().registerComponent(ComponentEntryPanel.this);
            }

            @Override
            protected void didBecomeUndisplayable(HierarchyEvent hierarchyEvent) {
                ComponentEntryPanel.this.entry.removeEventHandler(ComponentEntryPanel.this);
                ToolTipManager.sharedInstance().unregisterComponent(ComponentEntryPanel.this);
            }
        }
    }

    private class MoveEdit
    extends AbstractUndoableEdit {
        private int from;
        private int to;

        public MoveEdit(int n, int n2) {
            this.from = n;
            this.to = n2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            ComponentTableKeyWidget.this.getListModel().move(this.to, this.from);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            ComponentTableKeyWidget.this.getListModel().move(this.from, this.to);
        }
    }

    private class RemoveEdit
    extends AbstractUndoableEdit {
        private int[] indices;
        private Object[] items;

        public RemoveEdit(int[] nArray, Object[] objectArray) {
            this.indices = nArray;
            this.items = objectArray;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            ComponentTableKeyWidget.this.getListModel().beginValueChange();
            try {
                for (int i = 0; i < this.indices.length; ++i) {
                    ComponentTableKeyWidget.this.getListModel().add(this.indices[i], (ValueMap)this.items[i]);
                }
            }
            finally {
                ComponentTableKeyWidget.this.getListModel().endValueChange();
            }
            ComponentTableKeyWidget.this.table.setSelectedIndices(this.indices);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            ComponentTableKeyWidget.this.table.requestFocusInWindow();
            ComponentTableKeyWidget.this.getListModel().remove(this.indices);
        }
    }

    private class AddEdit
    extends AbstractUndoableEdit {
        private int[] indices;
        private Object[] items;

        public AddEdit(int[] nArray, Object[] objectArray) {
            this.indices = nArray;
            this.items = objectArray;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            ComponentTableKeyWidget.this.table.requestFocusInWindow();
            ComponentTableKeyWidget.this.getListModel().remove(this.indices);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            ComponentTableKeyWidget.this.getListModel().beginValueChange();
            try {
                for (int i = 0; i < this.indices.length; ++i) {
                    ComponentTableKeyWidget.this.getListModel().add(this.indices[i], (ValueMap)this.items[i]);
                }
            }
            finally {
                ComponentTableKeyWidget.this.getListModel().endValueChange();
            }
            ComponentTableKeyWidget.this.table.setSelectedIndices(this.indices);
        }
    }
}

