/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ContainerWidget
extends Widget {
    private List<Component> components;
    private List<Widget> children;

    public ContainerWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    protected void addChild(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
        if (!(component instanceof Widget)) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList<Widget>();
        }
        this.children.add((Widget)component);
    }

    public List<Component> getComponentChildren() {
        return this.components == null ? Collections.EMPTY_LIST : this.components;
    }

    public List<Widget> getChildren() {
        return this.children;
    }

    @Override
    public Widget getWidget(Key<?> key) {
        if (this.children != null) {
            for (Widget widget : this.children) {
                Widget widget2 = widget.getWidget(key);
                if (widget2 == null) continue;
                return widget2;
            }
        }
        return null;
    }

    @Override
    public void updateImmediately() {
        if (this.children != null && this.isDisplayable()) {
            for (Widget widget : this.children) {
                widget.updateImmediately();
            }
        }
    }

    @Override
    public void updateWidget() {
        if (this.children != null) {
            for (Widget widget : this.children) {
                widget.updateWidgetValue();
            }
        }
    }

    @Override
    public boolean startEditing() {
        if (this.children == null) {
            return false;
        }
        for (Widget widget : this.children) {
            if (!widget.isShowing() || !widget.startEditing()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof KeySearchResult) || this.children == null) {
            return;
        }
        KeySearchResult keySearchResult = (KeySearchResult)searchResult;
        for (Widget widget : this.children) {
            if (widget instanceof KeyWidget) {
                if (!((KeyWidget)widget).getKey().equals(keySearchResult.getKey())) continue;
                widget.select(keySearchResult.getResult());
                break;
            }
            widget.select(searchResult);
        }
    }

    @Override
    public void clearSelection() {
        if (this.children == null) {
            return;
        }
        for (Widget widget : this.children) {
            widget.clearSelection();
        }
    }
}

