/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.UserFolder;
import com.ef_prime.rflow.core.base.WorkingDirectory;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;

public class FileKeyWidget
extends LabeledWidget
implements ActionListener,
WidgetConstants,
DocumentListener {
    protected JTextComponent input;
    private EmptyMessageHandler emptyMessageHandler;
    private KeyWidget.AutoValueLinkButton linkButton;

    public FileKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        this.input = this.createTextComponent();
        this.configureTextComponent();
        JButton jButton = new JButton("...");
        jButton.setActionCommand("button");
        UIUtility.setPreferredWidth(30, jButton);
        jButton.addActionListener(this);
        if (this.getKey().getAutoValueLink() == null) {
            this.setLayout(new BorderLayout());
            this.add(this.createLayer(this.input), "Center");
            this.add((Component)jButton, "East");
        } else {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.createLayer(this.input), "Center");
            jPanel.add((Component)jButton, "East");
            this.linkButton = this.createAutoValueLinkButton();
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new EmptyBorder(0, 4, 0, 0));
            jPanel2.add(this.linkButton);
            this.input.getDocument().addDocumentListener(this.createAutoValueDocumentListener(this.linkButton));
            this.refreshAutoValueLinkColor();
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel2, "East");
        }
    }

    protected JTextComponent createTextComponent() {
        return new JTextFieldEx((String)this.getKeyValue());
    }

    public JTextComponent getInput() {
        return this.input;
    }

    protected void configureTextComponent() {
        FileKey fileKey = this.getKey();
        if (this.input instanceof JTextFieldEx) {
            ((JTextFieldEx)this.input).addActionListener(this);
        }
        this.input.addFocusListener(this.createUpdateFocusListener());
        if (!fileKey.isLazyUpdate()) {
            this.input.getDocument().addDocumentListener(this.createUpdateDocumentListener());
        }
        if (fileKey.isDynamicDefault() || fileKey.isEmptyMessage()) {
            this.emptyMessageHandler = new EmptyMessageHandler();
            this.refreshEmptyMessage();
        }
        if (fileKey.isFillDefaultOnFocus()) {
            this.input.addFocusListener(new FillDefaultFocusListener());
        }
        this.input.getDocument().addDocumentListener(this);
    }

    protected File valueToFile(String string) {
        return new File(string);
    }

    protected String fileToValue(File file) {
        return file.getPath();
    }

    protected String filesToValue(File[] fileArray) {
        return Arrays.stream(fileArray).map(file -> file.getPath()).collect(Collectors.joining(File.pathSeparator));
    }

    private void chooseFile() {
        FileKey fileKey = this.getKey();
        int n = 2;
        switch (fileKey.getMode()) {
            case 0: 
            case 3: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
            }
        }
        String string = this.getValueMap().getValueOrDefault(fileKey);
        if (string == null || fileKey.getMode() == 3) {
            string = "";
        }
        Object object = this.valueToFile(string);
        if (!string.isEmpty() && !((File)object).isAbsolute()) {
            object = WorkingDirectory.toAbsolutePath((File)object);
        }
        File file = null;
        String string2 = fileKey.getDefaultDirectory();
        if (string2 == null) {
            string2 = ":workingspace";
        }
        switch (string2) {
            case ":projects_home": {
                file = Rflow.settings().getDefaultWorkingDir();
                break;
            }
            case ":workingspace": {
                file = WorkingDirectory.getWorkingDirectory();
                break;
            }
            case ":user_documents": {
                file = UserFolder.getUserDocumentsDir();
                break;
            }
            default: {
                file = WorkingDirectory.toAbsolutePath(new File(string2));
                if (file.isDirectory()) break;
                file = WorkingDirectory.getWorkingDirectory();
            }
        }
        Object object2 = null;
        File[] fileArray = null;
        Window window = SwingUtilities.windowForComponent(this);
        if (fileKey.getMode() == 1) {
            if (string.isEmpty()) {
                object = file;
            }
            object2 = UIUtility.chooseDirFx(window, new File[]{object, file});
        } else {
            int n2;
            Object object3;
            if (string.isEmpty()) {
                object = file;
            } else {
                object3 = null;
                File file2 = object;
                for (int i = 0; i < 4; ++i) {
                    if (file2.isDirectory()) {
                        object3 = file2;
                        if (((File)object3).isAbsolute() && !((File)object3).getPath().isEmpty()) break;
                        object3 = WorkingDirectory.toAbsolutePath((File)object3);
                        break;
                    }
                    if ((file2 = file2.getParentFile()) == null) break;
                }
                if (object3 == null || !((File)object3).isDirectory()) {
                    object = file;
                } else if (!((File)object3).equals(((File)object).getParentFile())) {
                    object = object3;
                }
            }
            object3 = UIUtility.toFileFilter(fileKey.getExtensionFilters());
            int n3 = n2 = fileKey.getType() == 1 ? 1 : 0;
            if (fileKey.getMode() == 3) {
                fileArray = UIUtility.chooseFiles(window, (File)object, n2, (FileFilter[])object3);
            } else {
                object2 = UIUtility.chooseFile(window, (File)object, n, n2, (FileFilter[])object3);
            }
        }
        if (fileKey.getMode() == 3) {
            if (fileArray == null) {
                return;
            }
            if (this.getKey().isAbstractPathEnabled()) {
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i] = WorkingDirectory.toAbstractPath(fileArray[i]);
                }
            }
            this.input.setText(this.filesToValue(fileArray));
        } else {
            if (object2 == null) {
                return;
            }
            if (this.getKey().isAbstractPathEnabled()) {
                object2 = WorkingDirectory.toAbstractPath((File)object2);
            }
            this.input.setText(this.fileToValue((File)object2));
        }
        this.update();
    }

    protected void refreshEmptyMessage() {
        if (this.input instanceof JTextFieldEx) {
            if (this.getKey().isDynamicDefault()) {
                ((JTextFieldEx)this.input).setEmptyMessage(this.getKey().getDynamicDefaultMessage(this.getValueMap()));
                ((JTextFieldEx)this.input).setEmptyMessageColor(AUTO_FONT_COLOR);
            } else {
                ((JTextFieldEx)this.input).setEmptyMessage(this.getKey().getEmptyMessage(this.getValueMap()));
                ((JTextFieldEx)this.input).setEmptyMessageColor(INFO_FONT_COLOR);
            }
        }
    }

    protected void refreshAutoValueLinkColor() {
        this.input.setForeground(this.isAutoValueLinkEnabled() ? AUTO_FONT_COLOR : null);
        this.input.repaint();
    }

    @Override
    protected void autoValueLinkChanged() {
        if (this.linkButton != null) {
            this.linkButton.updateWidget();
        }
        super.autoValueLinkChanged();
    }

    @Override
    protected void autoValueLinkStateChanged() {
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileKeyWidget.this.refreshAutoValueLinkColor();
            }
        });
    }

    public FileKey getKey() {
        return (FileKey)super.getKey();
    }

    @Override
    protected Object getValue() {
        return this.input.getText();
    }

    @Override
    public void updateWidget() {
        this.input.setText((String)this.getKeyValue());
    }

    @Override
    public boolean startEditing() {
        String string;
        this.input.requestFocusInWindow();
        if (this.getKey().isFileNameEdit() && !(string = this.input.getText()).isEmpty()) {
            int n = FilenameUtils.getFullPath((String)string).length();
            int n2 = FilenameUtils.getBaseName((String)string).length();
            this.input.setCaretPosition(n);
            this.input.moveCaretPosition(n + n2);
        }
        return true;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TextSearchResult) || this.input == null) {
            return;
        }
        TextSearchResult textSearchResult = (TextSearchResult)searchResult;
        this.input.select(textSearchResult.getOffset(), textSearchResult.getEnd());
        this.input.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        if (this.input != null) {
            this.input.select(0, 0);
        }
    }

    @Override
    protected boolean supportsAutoValueLink() {
        return true;
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        if (this.emptyMessageHandler != null) {
            this.refreshEmptyMessage();
            this.getValueMap().addEventHandler(this.emptyMessageHandler);
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.emptyMessageHandler != null) {
            this.getValueMap().removeEventHandler(this.emptyMessageHandler);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.input) {
            this.update();
        } else if (actionEvent.getActionCommand().equals("button")) {
            this.chooseFile();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    private class EmptyMessageHandler
    implements ValueChangeEventHandler {
        private EmptyMessageHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            FileKeyWidget.this.refreshEmptyMessage();
        }
    }

    private class FillDefaultFocusListener
    implements FocusListener {
        private FillDefaultFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            String string;
            if (FileKeyWidget.this.getValueMap().isStringEmpty(FileKeyWidget.this.getKey()) && (string = (String)FileKeyWidget.this.getValueMap().getDynamicDefaultValue(FileKeyWidget.this.getKey())) != null) {
                FileKeyWidget.this.input.setText(string);
                FileKeyWidget.this.input.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

