/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IntKeyWidget
extends LabeledWidget
implements PropertyChangeListener,
DocumentListener {
    private JFormattedTextField input;

    public IntKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        this.input = new JFormattedTextField(numberFormat);
        this.input.setValue(this.getKeyValue());
        this.input.addPropertyChangeListener("value", this);
        this.input.setHorizontalAlignment(4);
        this.input.getDocument().addDocumentListener(this);
        this.input.getDocument().addDocumentListener(this.createUpdateDocumentListener());
        this.add(this.input);
    }

    @Override
    protected Object getValue() {
        return ((Number)this.input.getValue()).intValue();
    }

    @Override
    public void updateWidget() {
        this.input.setValue(this.getKeyValue());
    }

    @Override
    protected void updateInternal() {
        if (this.input != null) {
            try {
                this.input.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        super.updateInternal();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }
}

