/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.DelayedExecutor;
import com.ef_prime.rflow.ui.common.component.DocumentAdapter;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LayerUI;

public abstract class KeyWidget
extends Widget
implements ValueChangeEventHandler {
    private DelayedExecutor delayedUpdater;
    private boolean valueChanged;
    private boolean changingValue;
    private ValueError error;
    private boolean everRemoved;

    public KeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
        this.refreshError();
    }

    public Key<?> getKey() {
        return this.getWidgetNode().getKey();
    }

    @Override
    public KeyWidgetNode getWidgetNode() {
        return (KeyWidgetNode)super.getWidgetNode();
    }

    @Override
    public boolean startEditing() {
        return false;
    }

    @Override
    public Widget getWidget(Key<?> key) {
        return this.getWidgetNode().getKey().equals(key) ? this : null;
    }

    public Object getKeyValue() {
        return this.getValueMap().getValue(this.getKey());
    }

    protected abstract Object getValue();

    protected boolean supportsUpdate() {
        return this.getKey().isAtomic();
    }

    @Override
    public void updateImmediately() {
        if (this.isContentLoaded() && this.isDisplayable() && this.supportsUpdate() && this.delayedUpdater != null) {
            this.delayedUpdater.fireWaitingActionSync();
        }
    }

    protected void update() {
        if (this.supportsUpdate()) {
            if (this.delayedUpdater != null) {
                this.delayedUpdater.requestAction(true);
            } else {
                this.updateInternal();
            }
        }
    }

    protected void updateInternal() {
        if (this.supportsUpdate()) {
            if (this.getKey().isQuietUpdate()) {
                this.updateQuietly();
            } else {
                this.changingValue = true;
                this.getValueMap().putValue(this.getKey(), this.getValue());
                this.changingValue = false;
            }
        }
    }

    protected void updateQuietly() {
        if (this.supportsUpdate()) {
            this.getValueMap().putValue(this.getKey(), this.getValue(), true);
        }
    }

    protected DelayedExecutor getDelayedUpdater() {
        if (this.delayedUpdater == null) {
            this.delayedUpdater = new DelayedExecutor(new Runnable(){

                @Override
                public void run() {
                    KeyWidget.this.updateInternal();
                }
            }, 800L);
        }
        return this.delayedUpdater;
    }

    protected DocumentListener createUpdateDocumentListener() {
        if (this.getKey().isFrequentUpdate()) {
            return new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    KeyWidget.this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    KeyWidget.this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    KeyWidget.this.update();
                }
            };
        }
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                KeyWidget.this.getDelayedUpdater().requestAction();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                KeyWidget.this.getDelayedUpdater().requestAction();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                KeyWidget.this.getDelayedUpdater().requestAction();
            }
        };
    }

    protected FocusListener createUpdateFocusListener() {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                KeyWidget.this.update();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        };
    }

    protected boolean supportsAutoUpdate() {
        return false;
    }

    protected boolean supportsAutoValueLink() {
        return false;
    }

    protected boolean isError() {
        return this.error != null;
    }

    public ValueError getError() {
        return this.error;
    }

    private void refreshError() {
        if (!this.getValueMap().isValidationEnabled()) {
            return;
        }
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<ValueError> list = KeyWidget.this.getValueMap().getValidationContext().getError(KeyWidget.this.getKey());
                ValueError valueError = KeyWidget.this.error;
                KeyWidget.this.error = list == null || list.isEmpty() ? null : new CompoundValueError(KeyWidget.this.getKey(), list);
                if (valueError != KeyWidget.this.error) {
                    KeyWidget.this.repaint();
                }
            }
        });
    }

    protected JLayer<Component> createLayer(Component component) {
        return new JLayer<Component>(component, new WidgetLayerUI());
    }

    protected AutoValueLinkButton createAutoValueLinkButton() {
        return new AutoValueLinkButton();
    }

    protected void paintErrorMark(Graphics graphics) {
        if (!this.isError()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.getInstance(10, 0.7f));
        int n = 1;
        int n2 = 5;
        graphics2D.setPaint(WidgetConstants.getErrorColor(this.getError()));
        graphics2D.fillPolygon(new int[]{n, n + n2, n}, new int[]{n, n, n + n2}, 3);
        graphics2D.dispose();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.getValueMap().removeEventHandler(this);
        this.getValueMap().addEventHandler(this);
        if (this.everRemoved) {
            if (this.supportsAutoValueLink() && this.getKey().getAutoValueLink() != null) {
                this.requestUpdateWidget();
            } else if (this.supportsAutoUpdate() && this.getWidgetNode().isAutoUpdate()) {
                this.requestUpdateWidget();
            }
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.delayedUpdater != null) {
            this.delayedUpdater.fireWaitingActionSync();
        }
        this.getValueMap().removeEventHandler(this);
        this.everRemoved = true;
    }

    @Override
    protected void viewShown() {
        super.viewShown();
        if (this.valueChanged) {
            UIUtility.invokeLater(() -> this.updateWidgetValue());
            this.valueChanged = false;
        }
        this.getValueMap().validate(this.getKey());
        this.refreshError();
    }

    protected void valueChanged() {
    }

    protected void autoValueLinkChanged() {
        this.autoValueLinkStateChanged();
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (!this.getKey().equals(valueChangeEvent.getKey())) {
            this.refreshError();
            if (valueChangeEvent.getKey().equals(this.getAutoValueLinkKey()) && !this.changingValue) {
                this.autoValueLinkChanged();
            }
            return;
        }
        this.valueChanged();
        this.refreshError();
        if (this.supportsAutoValueLink() && this.getKey().getAutoValueLink() != null) {
            if (!this.changingValue) {
                this.requestUpdateWidget();
            }
        } else if (this.supportsAutoUpdate() && this.getWidgetNode().isAutoUpdate() && !this.changingValue) {
            this.requestUpdateWidget();
        }
    }

    @Override
    protected void visibleStateChanged() {
        this.refreshError();
    }

    @Override
    protected void enableStateChanged() {
        this.refreshError();
    }

    private void requestUpdateWidget() {
        if (this.isShowing()) {
            UIUtility.invokeLater(() -> this.updateWidgetValue());
        } else {
            this.valueChanged = true;
        }
    }

    private BoolKey getAutoValueLinkKey() {
        return this.getKey().getAutoValueLinkKey();
    }

    protected boolean isAutoValueLinkEnabled() {
        return this.getValueMap().getValue(this.getAutoValueLinkKey());
    }

    protected void autoValueLinkStateChanged() {
    }

    protected DocumentListener createAutoValueDocumentListener(final JToggleButton jToggleButton) {
        return new DocumentAdapter(){

            @Override
            public void documentUpdate(DocumentEvent documentEvent) {
                if (!KeyWidget.this.isUpdating()) {
                    jToggleButton.setSelected(false);
                }
            }
        };
    }

    protected class WidgetLayerUI
    extends LayerUI<Component> {
        protected WidgetLayerUI() {
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            JLayer jLayer = (JLayer)jComponent;
            jLayer.setLayerEventMask(48L);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            super.uninstallUI(jComponent);
            JLayer jLayer = (JLayer)jComponent;
            jLayer.setLayerEventMask(0L);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent, JLayer<? extends Component> jLayer) {
            JComponent jComponent;
            if (mouseEvent.getID() == 505 && mouseEvent.getSource() == jLayer.getView() && (jComponent = (JComponent)jLayer.getView()).getToolTipText() != null) {
                jComponent.setToolTipText(null);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent, JLayer<? extends Component> jLayer) {
            if (mouseEvent.getID() == 503) {
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), jLayer);
                if (point.getX() < 15.0 && point.getY() < 15.0) {
                    JComponent jComponent = (JComponent)jLayer.getView();
                    if (jComponent.getToolTipText() == null && KeyWidget.this.isError()) {
                        ValueError valueError = KeyWidget.this.getError();
                        jComponent.setToolTipText(UIUtility.convertToHTML(valueError.getMessage(false, false)));
                    }
                } else {
                    JComponent jComponent = (JComponent)jLayer.getView();
                    if (jComponent.getToolTipText() != null) {
                        jComponent.setToolTipText(null);
                    }
                }
            }
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            KeyWidget.this.paintErrorMark(graphics);
        }
    }

    protected class AutoValueLinkButton
    extends JToggleButton
    implements ItemListener {
        public AutoValueLinkButton() {
            this.setIcon(Icons.getIcon("16/link.png"));
            this.setSelected(KeyWidget.this.isAutoValueLinkEnabled());
            this.addItemListener(this);
            this.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.setFocusable(false);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            BoolKey boolKey = KeyWidget.this.getAutoValueLinkKey();
            boolean bl = itemEvent.getStateChange() == 1;
            KeyWidget.this.changingValue = true;
            KeyWidget.this.getValueMap().putValue(boolKey, bl);
            KeyWidget.this.changingValue = false;
            if (bl) {
                KeyWidget.this.requestUpdateWidget();
            }
            KeyWidget.this.autoValueLinkStateChanged();
        }

        public void updateWidget() {
            this.removeItemListener(this);
            BoolKey boolKey = KeyWidget.this.getAutoValueLinkKey();
            this.setSelected(KeyWidget.this.getValueMap().getValue(boolKey));
            this.addItemListener(this);
        }
    }
}

