/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;

public abstract class LabeledWidget
extends KeyWidget {
    private JLabel label;

    public LabeledWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
        Key<?> key = this.getKey();
        String string = widgetNode.getLabelPosition();
        if (!string.equals("none")) {
            if (string.equals("empty")) {
                this.label = new JLabel();
                if (this.getKey().getIcon() != null) {
                    this.label.setIcon(Icons.getIcon(this.getKey().getIcon()));
                }
                if (key.getTitle() != null) {
                    ToolTipManager.sharedInstance().registerComponent(this.label);
                    this.label.setToolTipText(key.getTitle());
                }
            } else {
                this.label = this.createLabel(key.getTitle(), valueMap.getSubtitle(key));
            }
        }
    }

    private JLabel createLabel(String string, String string2) {
        Object object = string;
        if (object == null) {
            return null;
        }
        if (string2 != null) {
            object = "<html><body style=\"white-space: nowrap\">" + (String)object + " <font color=\"#808080\">(" + string2 + ")</font></body></html>";
        }
        JLabel jLabel = new JLabel((String)object);
        if (this.getWidgetNode().isGrowY()) {
            jLabel.setVerticalAlignment(1);
        }
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        ToolTipManager.sharedInstance().registerComponent(jLabel);
        if (this.getKey().getIcon() != null) {
            jLabel.setIcon(Icons.getIcon(this.getKey().getIcon()));
        }
        return jLabel;
    }

    @Override
    public Component getLabel() {
        return this.label;
    }

    @Override
    protected boolean supportsAutoUpdate() {
        return true;
    }
}

