/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.HasValueLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.ListAndDetailsKey;
import com.ef_prime.rflow.core.common.keyvalue.MenuElement;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueLink;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ValueMapKey;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.feature.search.ListSearchResult;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.table.GeneralTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public class ListAndDetailsKeyWidget
extends LabeledWidget {
    private static final Logger LOGGER = Logger.getLogger(ListAndDetailsKeyWidget.class.getName());
    private GeneralTable table;

    public ListAndDetailsKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        this.table = this.createTable(this.getKey());
        this.add((Component)this.table, "Center");
        this.updateWidgetValue();
    }

    protected GeneralTable createTable(TableKey tableKey) {
        return new ValueMapTable(tableKey);
    }

    public GeneralTable getTable() {
        return this.table;
    }

    @Override
    public void updateWidget() {
        if (this.table != null && this.table.getInnerModel() != this.getTableModel()) {
            this.table.setModel(this.getTableModel(), this.getValueMap());
        }
    }

    @Override
    public boolean startEditing() {
        return false;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof ListSearchResult) || this.table == null) {
            return;
        }
        this.table.select((ListSearchResult)searchResult);
    }

    @Override
    public void clearSelection() {
        this.table.clearDetailSelection();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.updateWidget();
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.table != null) {
            this.table.unload();
        }
    }

    @Override
    protected Object getValue() {
        throw new UnsupportedOperationException();
    }

    public ListAndDetailsKey getKey() {
        return (ListAndDetailsKey)super.getKey();
    }

    @Override
    protected boolean isError() {
        return false;
    }

    protected KeysTableModel getTableModel() {
        return (KeysTableModel)this.getKeyValue();
    }

    protected class ValueMapTable
    extends GeneralTable {
        public ValueMapTable(TableKey tableKey) {
            super(tableKey);
        }

        protected ValueMapKey getValueMapKey() {
            KeysTableModel keysTableModel = ListAndDetailsKeyWidget.this.getTableModel();
            return (ValueMapKey)keysTableModel.getColumnKey(keysTableModel.getColumnCount() - 1);
        }

        @Override
        protected void insert(ActionEvent actionEvent, int n) {
            ValueMapKey valueMapKey = this.getValueMapKey();
            Map<String, String> map = valueMapKey.getClassMap();
            if (map == null || map.size() <= 1) {
                super.insert(actionEvent, n);
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (ListAndDetailsKeyWidget.this.getKey().getMenu() != null) {
                MenuElement menuElement = ListAndDetailsKeyWidget.this.getKey().getMenu();
                for (MenuElement menuElement2 : menuElement.getChildren()) {
                    this.createMenu(jPopupMenu, menuElement2, n);
                }
            } else {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getValue();
                    Object var9_12 = null;
                    try {
                        Class<?> clazz = Class.forName(string);
                        var9_12 = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, "Failed to create instance of: " + string, exception);
                    }
                    if (!(var9_12 instanceof ValueMap)) continue;
                    jPopupMenu.add(new AddAction(var9_12, n));
                }
            }
            this.showPopupMenu(jPopupMenu, actionEvent.getSource());
        }

        protected void showPopupMenu(JPopupMenu jPopupMenu, Object object) {
            Component component;
            int n = 0;
            int n2 = 0;
            if (object instanceof Component && !((component = (Component)object).getParent() instanceof JPopupMenu)) {
                n = component.getX();
                n2 = component.getY() + component.getHeight();
            }
            jPopupMenu.show(this, n, n2);
        }

        private void createMenu(Object object, MenuElement menuElement, int n) {
            if (menuElement.isLeaf()) {
                String string = this.getValueMapKey().getClassMap().get(menuElement.getId());
                try {
                    Class<?> clazz = Class.forName(string);
                    ValueMap valueMap = (ValueMap)clazz.newInstance();
                    AddAction addAction = new AddAction(valueMap, n);
                    if (object instanceof JPopupMenu) {
                        ((JPopupMenu)object).add(addAction);
                    } else if (object instanceof JMenu) {
                        ((JMenu)object).add(addAction);
                    }
                }
                catch (Exception exception) {}
            } else {
                JMenu jMenu = new JMenu(menuElement.getTitle());
                for (MenuElement menuElement2 : menuElement.getChildren()) {
                    this.createMenu(jMenu, menuElement2, n);
                }
                if (object instanceof JPopupMenu) {
                    ((JPopupMenu)object).add(jMenu);
                } else if (object instanceof JMenu) {
                    ((JMenu)object).add(jMenu);
                }
            }
        }

        @Deprecated
        private void updateValueLink(ValueMap valueMap, ValueMap valueMap2) {
            if (valueMap instanceof HasValueLink && valueMap2 instanceof HasValueLink) {
                String[] stringArray;
                HasValueLink hasValueLink = (HasValueLink)((Object)valueMap2);
                HasValueLink hasValueLink2 = (HasValueLink)((Object)valueMap);
                for (String string : stringArray = hasValueLink.getValueLinkNames()) {
                    Key<?> key = hasValueLink2.getValueLinkKey(string);
                    Key<?> key2 = hasValueLink.getValueLinkKey(string);
                    if (key == null || key2 == null) continue;
                    ValueLink.create(valueMap, key, valueMap2, key2, true);
                }
            }
        }

        @Override
        protected Component createDetail(Object object) {
            ValueMap valueMap = (ValueMap)object;
            this.updateValueLink(ListAndDetailsKeyWidget.this.getValueMap(), valueMap);
            return WidgetFactory.getInstance().create(valueMap);
        }

        @Override
        protected TableCellRenderer getRenderer(Key<?> key) {
            if (key instanceof ValueMapKey) {
                return new OpRenderer();
            }
            return super.getRenderer(key);
        }

        private class AddAction
        extends LoggableAction {
            private ValueMap valueMap;
            private int row;

            public AddAction(ValueMap valueMap, int n) {
                if (valueMap instanceof Operation) {
                    Operation operation = (Operation)valueMap;
                    this.putValue("Name", operation.getTitle());
                    this.putValue("SmallIcon", operation.getSmallIcon());
                }
                this.valueMap = valueMap;
                this.row = n;
            }

            @Override
            public void action(ActionEvent actionEvent) {
                ListAndDetailsKeyWidget.this.getTableModel().insertNewRow(this.row, this.valueMap);
                ListAndDetailsKeyWidget.this.getTable().setCellSelection(this.row, 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValueMapTable.this.startDetailEditing();
                    }
                });
            }
        }

        protected class OpRenderer
        extends GeneralTable.GeneralTableRenderer {
            protected OpRenderer() {
                super(ValueMapTable.this);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Icon icon = null;
                if (object instanceof Operation) {
                    Operation operation = (Operation)object;
                    icon = operation.getSmallIcon();
                }
                this.setIcon(icon);
                return this;
            }
        }
    }
}

