/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.PanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.common.component.ShowingListener;
import com.ef_prime.rflow.ui.common.keyvalue.ContainerWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;

public class PanelWidget
extends ContainerWidget {
    private static final DimConstraint EMPTY_CONSTRAINT = new DimConstraint();
    private static final DimConstraint GROW_CONSTRAINT = new DimConstraint();
    private static final DimConstraint FILLER_CONSTRAINT = new DimConstraint();
    private static final DimConstraint NOGAP_CONSTRAINT = new DimConstraint();
    protected ScrollablePanel panel;
    private DimConstraint[] rowConstraints;
    private boolean[] hiddenRow;

    public PanelWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void prepareContent() {
        super.prepareContent();
    }

    @Override
    protected void loadContent() {
        Serializable serializable;
        Serializable serializable2;
        WidgetNode widgetNode2;
        PanelWidgetNode panelWidgetNode = (PanelWidgetNode)this.getWidgetNode();
        boolean bl = false;
        for (WidgetNode widgetNode2 : panelWidgetNode) {
            if (!widgetNode2.isGrowY()) continue;
            bl = true;
            break;
        }
        this.panel = new ScrollablePanel(bl, panelWidgetNode.isNoScroll());
        this.panel.setOpaque(false);
        LC lC = new LC().insetsAll("0").hideMode(3).gridGapY("4");
        if (bl) {
            lC.fill();
        } else {
            lC.fillX();
        }
        widgetNode2 = new AC().gap().grow();
        this.panel.setLayout((LayoutManager)new MigLayout(lC, (AC)widgetNode2));
        if (!panelWidgetNode.isNoScroll()) {
            serializable2 = new JScrollPane(this.panel){

                @Override
                public boolean isValidateRoot() {
                    return false;
                }
            };
            ((JComponent)serializable2).setBorder(null);
            serializable = serializable2;
        } else {
            serializable = this.panel;
        }
        this.layoutContent((Component)serializable);
        serializable2 = new ArrayList();
        for (WidgetNode widgetNode3 : panelWidgetNode) {
            Component component = WidgetFactory.getInstance().create(this.getValueMap(), widgetNode3);
            if (component == null) continue;
            this.addWidget(component, widgetNode3, (List<DimConstraint>)((Object)serializable2));
        }
        if (bl) {
            this.panel.add((Component)new JLabel(), new CC().spanX(2));
            serializable2.add(FILLER_CONSTRAINT);
        }
        AC aC = new AC();
        this.rowConstraints = serializable2.toArray(new DimConstraint[0]);
        aC.setConstaints(this.rowConstraints);
        ((MigLayout)this.panel.getLayout()).setRowConstraints((Object)aC);
        this.hiddenRow = new boolean[this.rowConstraints.length];
    }

    protected void layoutContent(Component component) {
        this.setLayout(new BorderLayout());
        this.add(component);
    }

    private void addWidget(Component component, WidgetNode widgetNode, List<DimConstraint> list) {
        Widget widget;
        if (component == null) {
            return;
        }
        this.addChild(component);
        boolean bl = false;
        if (component instanceof Widget) {
            Component component2;
            widget = (Widget)component;
            String string = widgetNode.getLabelPosition();
            if (!"none".equals(string) && (component2 = widget.getLabel()) != null) {
                int n = component2.getPreferredSize().width;
                if ("top".equals(string)) {
                    this.panel.add(component2, new CC().spanX(2).wrap());
                    list.add(EMPTY_CONSTRAINT);
                    component.addHierarchyListener(new VisibleListener(list.size() - 1));
                } else if (n > 100) {
                    this.panel.add(component2, new CC().split(2).spanX(2).width("null:null:300"));
                    bl = true;
                } else {
                    this.panel.add(component2, new CC().alignY("top").gapTop("2"));
                    bl = true;
                }
            }
        }
        widget = new CC().wrap();
        if (!bl) {
            widget.spanX(2);
        }
        if (widgetNode.getWidth() >= 0) {
            widget.width(Integer.toString(widgetNode.getWidth()));
        } else if (widgetNode.isGrowX()) {
            widget.growX();
        } else if (widgetNode.getMinWidth() >= 0) {
            widget.minWidth(Integer.toString(widgetNode.getMinWidth()));
        }
        if (widgetNode.isGrowY()) {
            widget.height("100%");
        } else if (widgetNode.getHeight() > 0) {
            widget.height(widgetNode.getHeight() + "!");
        }
        if (widgetNode instanceof PanelWidgetNode && ((PanelWidgetNode)widgetNode).isIndent()) {
            widget.gapLeft("24");
        }
        this.panel.add(component, (Object)widget);
        list.add(widgetNode.isGrowY() ? GROW_CONSTRAINT : EMPTY_CONSTRAINT);
        component.addHierarchyListener(new VisibleListener(list.size() - 1));
    }

    @Override
    public void setEnabled(boolean bl) {
        UIUtility.setEnabled(bl, this.panel);
    }

    static {
        BoundSize boundSize = new BoundSize(new UnitValue(0.0f), "0px");
        GROW_CONSTRAINT.setFill(true);
        GROW_CONSTRAINT.setGrow(Float.valueOf(100.0f));
        GROW_CONSTRAINT.setGrowPriority(200);
        FILLER_CONSTRAINT.setGrow(Float.valueOf(100.0f));
        FILLER_CONSTRAINT.setGrowPriority(150);
        FILLER_CONSTRAINT.setGapBefore(boundSize);
        FILLER_CONSTRAINT.setGapAfter(boundSize);
        NOGAP_CONSTRAINT.setGapAfter(boundSize);
        NOGAP_CONSTRAINT.setGapBefore(boundSize);
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private boolean tracksViewportHeight;
        private boolean noScroll;

        public ScrollablePanel(boolean bl, boolean bl2) {
            this.tracksViewportHeight = bl;
            this.noScroll = bl2;
        }

        public boolean isTracksViewportHeight() {
            return this.tracksViewportHeight;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.tracksViewportHeight && !this.getScrollableTracksViewportHeight()) {
                return this.getMinimumSize();
            }
            return super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n == 1 ? rectangle.height : rectangle.width;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (this.noScroll) {
                return true;
            }
            if (this.tracksViewportHeight) {
                return this.getMinimumSize().height < this.getParent().getHeight();
            }
            return false;
        }
    }

    private class VisibleListener
    extends ShowingListener {
        private int rowIndex;

        public VisibleListener(int n) {
            this.rowIndex = n;
        }

        @Override
        protected void didBecomeShowing(HierarchyEvent hierarchyEvent) {
            PanelWidget.this.hiddenRow[this.rowIndex] = false;
            this.refreshRowConstraint();
        }

        @Override
        protected void didBecomeNotShowing(HierarchyEvent hierarchyEvent) {
            PanelWidget.this.hiddenRow[this.rowIndex] = true;
            this.refreshRowConstraint();
        }

        private void refreshRowConstraint() {
            ArrayList<DimConstraint> arrayList = new ArrayList<DimConstraint>();
            for (int i = 0; i < PanelWidget.this.rowConstraints.length; ++i) {
                if (PanelWidget.this.hiddenRow[i]) continue;
                arrayList.add(PanelWidget.this.rowConstraints[i]);
            }
            if (!PanelWidget.this.panel.isTracksViewportHeight()) {
                arrayList.add(NOGAP_CONSTRAINT);
            }
            DimConstraint[] dimConstraintArray = arrayList.toArray(new DimConstraint[arrayList.size()]);
            AC aC = new AC();
            aC.setConstaints(dimConstraintArray);
            ((MigLayout)PanelWidget.this.panel.getLayout()).setRowConstraints((Object)aC);
        }
    }
}

