/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.RadioButtonKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class RadioButtonKeyWidget
extends LabeledWidget
implements ItemListener {
    private JRadioButton[] buttons;

    public RadioButtonKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    public RadioButtonKey getKey() {
        return (RadioButtonKey)super.getKey();
    }

    @Override
    protected boolean supportsAutoValueLink() {
        return true;
    }

    @Override
    protected void loadContent() {
        LC lC = new LC().insets("0").gridGapY("0");
        if (this.getKey().getOrientation().equals("y")) {
            lC.flowY();
        }
        this.setLayout((LayoutManager)new MigLayout(lC));
        List<Choice> list = this.getKey().getChoices(this.getValueMap());
        this.buttons = new JRadioButton[list.size()];
        Object object = this.getKeyValue();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < list.size(); ++i) {
            String string = this.getKey().isLabel() ? this.getKey().getLabel(i, this.getValueMap()) : list.get(i).getValue();
            JRadioButton jRadioButton = new JRadioButton(string, list.get(i).getValue().equals(object));
            jRadioButton.addItemListener(this);
            this.buttons[i] = jRadioButton;
            buttonGroup.add(jRadioButton);
            this.add(jRadioButton);
        }
        if (buttonGroup.getSelection() == null && this.buttons.length > 0) {
            this.buttons[0].setSelected(true);
        }
        if (this.getKey().getAutoValueLink() == null || !this.getKey().getAutoValueLink().isHidden()) {
            // empty if block
        }
    }

    @Override
    protected Object getValue() {
        List<Choice> list = this.getKey().getChoices(this.getValueMap());
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return list.get(i).getValue();
        }
        return list.get(0).getValue();
    }

    @Override
    public void updateWidget() {
        int n = this.getKey().getIndexOf((String)this.getKeyValue());
        if (n >= 0 && n < this.buttons.length) {
            this.buttons[n].setSelected(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.update();
        }
    }
}

