/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.DescriptionLink;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.ui.common.component.JTextFieldEx;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.function.Supplier;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StrKeyWidget
extends LabeledWidget
implements ActionListener,
DocumentListener {
    private JTextFieldEx input;
    private EmptyMessageHandler emptyMessageHandler;
    private DescriptionHandler descriptionHandler;
    private KeyWidget.AutoValueLinkButton linkButton;

    public StrKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    public StrKey getKey() {
        return (StrKey)super.getKey();
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        if (this.getKey().isFixed()) {
            this.input = new JTextFieldEx((String)this.getKeyValue()){

                @Override
                public String getToolTipText() {
                    Supplier<String> supplier = StrKeyWidget.this.getKey().getToolTipSupplier();
                    if (supplier == null) {
                        BoundedRangeModel boundedRangeModel = this.getHorizontalVisibility();
                        if (boundedRangeModel.getExtent() < boundedRangeModel.getMaximum() - 1) {
                            return this.getText();
                        }
                        return null;
                    }
                    return supplier.get();
                }
            };
            this.input.setOpaque(false);
            this.input.setBorder(null);
            this.input.setEditable(false);
            this.input.setScrollOffset(0);
            this.input.setCaretPosition(0);
            this.add(this.input);
        } else {
            this.input = new JTextFieldEx((String)this.getKeyValue());
            this.input.setFont(new Font("Monospaced", 0, this.input.getFont().getSize()));
            this.input.addFocusListener(this.createUpdateFocusListener());
            this.input.addActionListener(this);
            this.input.getDocument().addDocumentListener(this.createUpdateDocumentListener());
            this.input.getDocument().addDocumentListener(this);
            if (this.getKey().isFillDefaultOnFocus()) {
                this.input.addFocusListener(new FillDefaultFocusListener());
            }
            this.add(this.createLayer(this.input));
            if (this.getKey().getAutoValueLink() != null) {
                this.linkButton = this.createAutoValueLinkButton();
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
                jPanel.add(this.linkButton);
                this.add((Component)jPanel, "East");
                this.input.getDocument().addDocumentListener(this.createAutoValueDocumentListener(this.linkButton));
                this.refreshAutoValueLinkColor();
            }
        }
        if (this.getKey().isDynamicDefault() || this.getKey().isEmptyMessage()) {
            this.emptyMessageHandler = new EmptyMessageHandler();
            this.refreshEmptyMessage();
        }
        if (this.getKey().getDescriptionLink() != null) {
            this.descriptionHandler = new DescriptionHandler();
            this.refreshDescription(null);
        }
    }

    public JTextFieldEx getInput() {
        return this.input;
    }

    @Override
    protected Object getValue() {
        if (this.input != null) {
            return this.input.getText();
        }
        return "";
    }

    @Override
    public boolean startEditing() {
        this.input.selectAll();
        this.input.requestFocusInWindow();
        return true;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TextSearchResult) || this.input == null) {
            return;
        }
        TextSearchResult textSearchResult = (TextSearchResult)searchResult;
        this.input.select(textSearchResult.getOffset(), textSearchResult.getEnd());
        this.input.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        if (this.input != null) {
            this.input.select(0, 0);
        }
    }

    @Override
    public void updateWidget() {
        if (this.input != null) {
            this.input.setText((String)this.getKeyValue());
            if (this.getKey().isFixed()) {
                this.input.setCaretPosition(0);
            }
        }
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        if (this.getKey().isFixed() && this.input != null) {
            ToolTipManager.sharedInstance().registerComponent(this.input);
        }
        if (this.emptyMessageHandler != null) {
            this.refreshEmptyMessage();
            this.getValueMap().addEventHandler(this.emptyMessageHandler);
        }
        if (this.descriptionHandler != null) {
            this.refreshDescription(null);
            this.getValueMap().addEventHandler(this.descriptionHandler);
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.getKey().isFixed() && this.input != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.input);
        }
        if (this.emptyMessageHandler != null) {
            this.getValueMap().removeEventHandler(this.emptyMessageHandler);
        }
        if (this.descriptionHandler != null) {
            this.getValueMap().removeEventHandler(this.descriptionHandler);
        }
    }

    private void refreshEmptyMessage() {
        if (this.getKey().isDynamicDefault()) {
            this.input.setEmptyMessage(this.getKey().getDynamicDefaultMessage(this.getValueMap()));
            this.input.setEmptyMessageColor(WidgetConstants.AUTO_FONT_COLOR);
        } else {
            this.input.setEmptyMessage(this.getKey().getEmptyMessage(this.getValueMap()));
            this.input.setEmptyMessageColor(WidgetConstants.INFO_FONT_COLOR);
        }
    }

    private void refreshDescription(Key<?> key) {
        DescriptionLink descriptionLink = this.getKey().getDescriptionLink();
        if (descriptionLink != null && (key == null || descriptionLink.contains(key.getId()))) {
            this.input.setDescription(this.getKey().getDescriptionMessage(this.getValueMap()));
        }
    }

    private void refreshAutoValueLinkColor() {
        this.input.setForeground(this.isAutoValueLinkEnabled() ? WidgetConstants.AUTO_FONT_COLOR : null);
    }

    @Override
    protected void autoValueLinkChanged() {
        if (this.linkButton != null) {
            this.linkButton.updateWidget();
        }
        super.autoValueLinkChanged();
    }

    @Override
    protected void autoValueLinkStateChanged() {
        UIUtility.invokeLater(() -> this.refreshAutoValueLinkColor());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.input.getParent().revalidate();
        this.input.getParent().repaint();
    }

    private class FillDefaultFocusListener
    implements FocusListener {
        private FillDefaultFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            String string;
            if (StrKeyWidget.this.getValueMap().isStringEmpty(StrKeyWidget.this.getKey()) && (string = (String)StrKeyWidget.this.getValueMap().getDynamicDefaultValue(StrKeyWidget.this.getKey())) != null) {
                StrKeyWidget.this.input.setText(string);
                StrKeyWidget.this.input.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class EmptyMessageHandler
    implements ValueChangeEventHandler {
        private EmptyMessageHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            StrKeyWidget.this.refreshEmptyMessage();
        }
    }

    private class DescriptionHandler
    implements ValueChangeEventHandler {
        private DescriptionHandler() {
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            StrKeyWidget.this.refreshDescription(valueChangeEvent.getKey());
        }
    }
}

