/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.CompoundValueError;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.TabWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.KeySearchResult;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.ui.common.keyvalue.ContainerWidget;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.PanelWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.LazyLoadView;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.common.view.ViewOpenType;
import com.ef_prime.rflow.ui.common.view.ViewTabbedPane;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class TabPaneWidget
extends ContainerWidget
implements ValueChangeEventHandler {
    private ViewTabbedPane tabbedPane;
    private List<WidgetNode> widgetNodes;
    private List<View> extraViews;
    private List<View> views;
    private List<LinkedHashSet<Key<?>>> keySets;

    public TabPaneWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    private void addWidgetNode(WidgetNode widgetNode) {
        this.widgetNodes.add(widgetNode);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.keySets.add(linkedHashSet);
        Iterator<WidgetNode> iterator = widgetNode.treeIterator();
        while (iterator.hasNext()) {
            WidgetNode widgetNode2 = iterator.next();
            if (!(widgetNode2 instanceof KeyWidgetNode)) continue;
            linkedHashSet.add(((KeyWidgetNode)widgetNode2).getKey());
        }
    }

    @Override
    protected void loadContent() {
        this.tabbedPane = new ViewTabbedPane(false);
        this.widgetNodes = new ArrayList<WidgetNode>();
        this.keySets = new ArrayList();
        this.views = new ArrayList<View>();
        for (WidgetNode object : this.getWidgetNode()) {
            Component component;
            if (object instanceof TabWidgetNode) {
                component = new LazyLoadTabView((TabWidgetNode)object, this.getValueMap(), this);
                this.tabbedPane.openView((View)component);
                this.views.add((View)component);
                this.addWidgetNode(object);
                continue;
            }
            component = WidgetFactory.getInstance().create(this.getValueMap(), object);
            if (component == null || !(component instanceof View)) continue;
            this.tabbedPane.openView((View)component);
            this.addChild(component);
            this.views.add((View)component);
            this.addWidgetNode(object);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        if (this.extraViews != null) {
            for (View view2 : this.extraViews) {
                this.tabbedPane.openView(view2);
            }
            this.extraViews = null;
        }
        if (this.getValueMap().isValidationEnabled()) {
            for (int i = 0; i < this.keySets.size(); ++i) {
                this.refreshError(i);
            }
        }
    }

    @Override
    protected void refreshKeyLinkState(String string) {
        super.refreshKeyLinkState(string);
        int n = 0;
        int n2 = 0;
        while (n < this.widgetNodes.size()) {
            WidgetNode widgetNode = this.widgetNodes.get(n);
            if (widgetNode.isKeyLink()) {
                Boolean[] booleanArray = this.getKeyLinkState(widgetNode);
                final int n3 = n;
                final int n4 = n2--;
                final Boolean bl = booleanArray[0];
                final Boolean bl2 = booleanArray[1];
                if (bl != null) {
                    if (!bl.booleanValue()) {
                        // empty if block
                    }
                    if (bl != (this.views.get(n).getParent() != null)) {
                        UIUtility.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (bl.booleanValue()) {
                                    TabPaneWidget.this.tabbedPane.openView(TabPaneWidget.this.views.get(n3), ViewOpenType.OPEN_NEW, false, n4);
                                    TabPaneWidget.this.refreshError(n3);
                                } else {
                                    TabPaneWidget.this.tabbedPane.removeTabAt(n4);
                                }
                            }
                        });
                    }
                }
                if (bl2 != null) {
                    UIUtility.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TabPaneWidget.this.tabbedPane.setEnabledAt(n4, bl2);
                        }
                    });
                }
            }
            ++n;
            ++n2;
        }
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof KeySearchResult) || this.getChildren() == null) {
            return;
        }
        KeySearchResult keySearchResult = (KeySearchResult)searchResult;
        int n = 0;
        int n2 = 0;
        while (n < this.widgetNodes.size()) {
            Object object;
            Object object2;
            WidgetNode widgetNode = this.widgetNodes.get(n);
            boolean bl = true;
            if (widgetNode.isKeyLink()) {
                object2 = this.getKeyLinkState(widgetNode);
                object = object2[0];
                Object object3 = object2[1];
                if (object != null && !((Boolean)object).booleanValue()) {
                    --n2;
                    bl = false;
                }
                if (object3 != null && !((Boolean)object3).booleanValue()) {
                    bl = false;
                }
            }
            if (bl) {
                object2 = widgetNode.treeIterator();
                while (object2.hasNext()) {
                    object = (WidgetNode)object2.next();
                    if (!(object instanceof KeyWidgetNode) || !((KeyWidgetNode)object).getKey().equals(keySearchResult.getKey())) continue;
                    this.tabbedPane.setSelectedIndex(n2);
                    break;
                }
            }
            ++n;
            ++n2;
        }
        for (Widget widget : this.getChildren()) {
            if (widget instanceof KeyWidget) {
                if (!((KeyWidget)widget).getKey().equals(keySearchResult.getKey())) continue;
                widget.select(keySearchResult.getResult());
                break;
            }
            widget.select(searchResult);
        }
    }

    public void addView(View view2) {
        if (this.tabbedPane == null) {
            if (this.extraViews == null) {
                this.extraViews = new ArrayList<View>();
            }
            this.extraViews.add(view2);
        } else {
            this.tabbedPane.openView(view2);
        }
    }

    public View[] getViews() {
        if (this.tabbedPane == null) {
            return new View[0];
        }
        return this.tabbedPane.getViews();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        if (this.getValueMap().isValidationEnabled()) {
            this.getValueMap().addEventHandler(this);
        }
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        this.getValueMap().removeEventHandler(this);
    }

    private void refreshError(int n) {
        List<ValueError> list = this.getValueMap().getValidationContext().getErrors((Collection)this.keySets.get(n));
        View view2 = this.views.get(n);
        int n2 = this.tabbedPane.getIndexOfView(view2);
        if (n2 >= 0) {
            CompoundValueError compoundValueError = null;
            if (list != null) {
                compoundValueError = new CompoundValueError(null, list);
            }
            this.tabbedPane.setValueError(n2, compoundValueError);
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        if (this.keySets == null || !this.getValueMap().isValidationEnabled()) {
            return;
        }
        for (int i = 0; i < this.keySets.size(); ++i) {
            Set set = this.keySets.get(i);
            if (!set.contains(valueChangeEvent.getKey())) continue;
            int n = i;
            SwingUtilities.invokeLater(() -> this.refreshError(n));
            break;
        }
    }

    public static class LazyLoadTabView
    extends LazyLoadView {
        private TabPaneWidget parent;
        private TabWidgetNode tabViewNode;
        private ValueMap valueMap;
        private Component content;

        public LazyLoadTabView(TabWidgetNode tabWidgetNode, ValueMap valueMap, TabPaneWidget tabPaneWidget) {
            this.parent = tabPaneWidget;
            this.tabViewNode = tabWidgetNode;
            this.valueMap = valueMap;
            this.setTitle(tabWidgetNode.getTitle());
        }

        @Override
        public void loadContent() {
            this.content = WidgetFactory.getInstance().create(this.valueMap, this.tabViewNode);
            if (this.content == null) {
                return;
            }
            this.add(this.content);
            this.parent.addChild(this.content);
        }

        public PanelWidget getContent() {
            this.doLoadContent();
            if (this.content instanceof PanelWidget) {
                return (PanelWidget)this.content;
            }
            return null;
        }
    }
}

