/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Choice;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.MutableValue;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.ui.common.component.TextComponentContainer;
import com.ef_prime.rflow.ui.common.keyvalue.ChoiceComboboxModel;
import com.ef_prime.rflow.ui.common.keyvalue.ComboBoxDescriptionSupport;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.common.table.GeneralTable;
import com.ef_prime.rflow.ui.util.SubstanceUIUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.substance.internal.ui.SubstanceComboBoxUI;

public class TableChoiceComboBox
extends JComboBox<Choice>
implements TextComponentContainer,
FocusListener {
    private static final Logger LOGGER = Logger.getLogger(TableChoiceComboBox.class.getName());
    private ChoiceKey key;
    private ValueMap valueMap;
    private boolean forRendering;
    private int row;
    private GeneralTable table;

    public TableChoiceComboBox(GeneralTable generalTable, ChoiceKey choiceKey, ValueMap valueMap, boolean bl) {
        super(new ChoiceComboboxModel());
        this.table = generalTable;
        this.key = choiceKey;
        this.valueMap = valueMap;
        this.forRendering = bl;
        if (!choiceKey.isChoiceEditable() || choiceKey.getChoiceProvider() == null) {
            ((ChoiceComboboxModel)this.getModel()).setData(choiceKey.getChoices(valueMap));
        }
        this.setEditable(choiceKey.isChoiceEditable());
        if (choiceKey.isLabel()) {
            this.setRenderer(new ChoiceRenderer());
        }
        if (this.isEditable()) {
            this.setEditor(this.createEditor());
        }
        this.addFocusListener(this);
        ((AbstractListModel)((Object)this.getModel())).addListDataListener(new ComboListDataHandler());
        if (choiceKey.isDescription().booleanValue()) {
            new ComboBoxDescriptionSupport(this);
        }
    }

    public GeneralTable getTable() {
        return this.table;
    }

    @Override
    public ChoiceComboboxModel<Choice> getModel() {
        return (ChoiceComboboxModel)super.getModel();
    }

    @Override
    public Object getSelectedItem() {
        Object object = super.getSelectedItem();
        if (object != null) {
            return object.toString();
        }
        return object;
    }

    @Override
    public void setSelectedItem(Object object) {
        Component component;
        ComboBoxEditor comboBoxEditor;
        if (object instanceof String) {
            object = new Choice((String)object);
        }
        super.setSelectedItem(object);
        if (object instanceof MutableValue) {
            ((ChoiceComboboxModel)this.getModel()).fireContentsChanged();
        }
        if ((comboBoxEditor = this.getEditor()) instanceof ChoiceComboBoxEditor && (component = ((ChoiceComboBoxEditor)comboBoxEditor).getEditorComponent()) instanceof ChoiceComboBoxTextField) {
            ((ChoiceComboBoxTextField)component).updateDescription();
        }
    }

    public void setRow(int n) {
        this.row = n;
    }

    public int getRow() {
        return this.row;
    }

    protected ComboBoxEditor createEditor() {
        return new ChoiceComboBoxEditor();
    }

    public ChoiceKey getKey() {
        return this.key;
    }

    public ValueMap getValueMap() {
        return this.valueMap;
    }

    public boolean isForRendering() {
        return this.forRendering;
    }

    public boolean isButton(Dimension dimension, Point point) {
        if (this.getUI() instanceof SubstanceComboBoxUI) {
            SubstanceComboBoxUI substanceComboBoxUI = (SubstanceComboBoxUI)this.getUI();
            return substanceComboBoxUI.getArrowButtonBounds(dimension.width, dimension.height).contains(point);
        }
        return false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.isPopupVisible()) {
            this.setPopupVisible(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public JTextComponent getTextComponent() {
        if (this.isEditable()) {
            return (JTextComponent)this.getEditor().getEditorComponent();
        }
        return null;
    }

    private class ChoiceRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Choice choice;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setOpaque(n >= 0);
            if (object instanceof String) {
                choice = TableChoiceComboBox.this.getKey().getChoice((String)object);
                object = choice == null ? new Choice(object.toString()) : choice;
            }
            choice = (Choice)object;
            this.setText(this.valueToRepresentation(choice, bl));
            this.setIcon(choice == null ? null : choice.getIcon());
            return this;
        }

        private String valueToRepresentation(Choice choice, boolean bl) {
            String string = choice.getValue();
            Object object = choice.getLabel();
            if (!TableChoiceComboBox.this.key.isLabel() || StringUtils.isEmpty((CharSequence)object)) {
                return string;
            }
            if (TableChoiceComboBox.this.getKey().showValueAndLabel()) {
                object = bl ? string + " (" + (String)object + ")" : "<html>" + string + " <font color=\"#808080\">(" + (String)object + ")</font></html>";
            }
            if (StringUtils.isEmpty((CharSequence)object)) {
                object = " ";
            }
            return object;
        }
    }

    private class ComboListDataHandler
    implements ListDataListener {
        private ComboListDataHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            JList<?> jList;
            if (listDataEvent.getIndex0() == -2 && (jList = SubstanceUIUtility.getComboList(TableChoiceComboBox.this)) != null) {
                jList.clearSelection();
            }
        }
    }

    private class ChoiceComboBoxEditor
    extends BasicComboBoxEditor {
        private ChoiceComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            ChoiceComboBoxTextField choiceComboBoxTextField = new ChoiceComboBoxTextField();
            choiceComboBoxTextField.addFocusListener(new FieldFocusHandler());
            return choiceComboBoxTextField;
        }

        @Override
        public Object getItem() {
            return new Choice(this.editor.getText());
        }

        private class FieldFocusHandler
        implements FocusListener {
            private FieldFocusHandler() {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!TableChoiceComboBox.this.isPopupVisible()) {
                    TableChoiceComboBox.this.setPopupVisible(true);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        }
    }

    private class ChoiceComboBoxTextField
    extends JTextField
    implements DocumentListener {
        private Color descriptionColor;
        private String description;
        private UndoManager undoManager;

        public ChoiceComboBoxTextField() {
            super("", 9);
            this.descriptionColor = WidgetConstants.INFO_FONT_COLOR;
            this.getDocument().addDocumentListener(this);
            this.setOpaque(false);
            this.undoManager = UIUtility.setTextComponentUndoable(this);
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
            if (this.undoManager != null) {
                this.undoManager.discardAllEdits();
            }
        }

        @Override
        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle;
            super.paintComponent(graphics);
            if (this.description == null) {
                return;
            }
            int n = this.getDocument().getLength();
            TextUI textUI = this.getUI();
            try {
                rectangle = textUI.modelToView(this, n, Position.Bias.Backward);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(this.descriptionColor);
            UIUtility.drawStringCenterY(graphics, this, this.description, rectangle.x + rectangle.width + 5);
            graphics.setColor(color);
        }

        private void updateDescription() {
            Object object;
            this.description = null;
            String string = this.getText();
            if (string.isEmpty() && TableChoiceComboBox.this.getKey().isDynamicDefault() && TableChoiceComboBox.this.getTable() != null && (object = TableChoiceComboBox.this.getValueMap().getDynamicDefaultValue(TableChoiceComboBox.this.getTable().getInnerModel(), TableChoiceComboBox.this.getRow(), TableChoiceComboBox.this.getKey())) instanceof String) {
                this.description = "(" + String.valueOf(object) + ")";
                this.descriptionColor = WidgetConstants.AUTO_FONT_COLOR;
                return;
            }
            object = TableChoiceComboBox.this.getKey().getLabel(string, TableChoiceComboBox.this.getValueMap());
            this.description = StringUtils.isEmpty((CharSequence)object) ? null : "(" + (String)object + ")";
            this.descriptionColor = WidgetConstants.INFO_FONT_COLOR;
        }

        private void documentChanged() {
            this.updateDescription();
            ComboBoxModel comboBoxModel = TableChoiceComboBox.this.getModel();
            String string = this.getText();
            ChoiceComboboxModel.setStandardChoiceFilter((ChoiceComboboxModel<Choice>)comboBoxModel, string);
            if (string.isEmpty() || ((ChoiceComboboxModel)comboBoxModel).getSize() == 0) {
                TableChoiceComboBox.this.setPopupVisible(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentChanged();
        }
    }
}

