/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TableTextSearchResult;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.table.GeneralTable;
import com.ef_prime.rflow.ui.common.table.UIGeneralTableModel;
import java.awt.BorderLayout;
import java.awt.Component;

public class TableKeyWidget
extends LabeledWidget {
    private GeneralTable table;

    public TableKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        this.table = this.createTable();
        this.add(this.createLayer(this.table), "Center");
        this.updateWidgetValue();
    }

    public TableKey getKey() {
        return (TableKey)super.getKey();
    }

    protected GeneralTable createTable() {
        return new GeneralTableEx(this.getKey());
    }

    public GeneralTable getTable() {
        return this.table;
    }

    @Override
    public boolean startEditing() {
        UIGeneralTableModel uIGeneralTableModel;
        if (this.table != null && (uIGeneralTableModel = this.table.getModel()).getRowCount() > 0 && uIGeneralTableModel.getColumnCount() > 0) {
            this.table.setCellSelection(0, 0);
            this.table.requestTableFocus();
        }
        return true;
    }

    @Override
    public void updateWidget() {
        if (this.table != null && this.table.getInnerModel() != this.getTableModel()) {
            this.table.setModel(this.getTableModel(), this.getValueMap());
        }
    }

    @Override
    public void updateImmediately() {
        super.updateImmediately();
        if (this.table != null) {
            this.table.stopEditing();
        }
    }

    private KeysTableModel getTableModel() {
        return (KeysTableModel)this.getKeyValue();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        this.updateWidget();
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        if (this.table != null) {
            this.table.unload();
        }
    }

    @Override
    protected Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isError() {
        return false;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (this.table == null || !(searchResult instanceof TableTextSearchResult)) {
            return;
        }
        this.table.select((TableTextSearchResult)searchResult);
    }

    @Override
    public void clearSelection() {
        if (this.table != null) {
            this.table.clearSelection();
        }
    }

    private class GeneralTableEx
    extends GeneralTable {
        public GeneralTableEx(TableKey tableKey) {
            super(tableKey);
        }

        @Override
        protected Component createDetail(Object object) {
            ValueMap valueMap = (ValueMap)object;
            return WidgetFactory.getInstance().create(valueMap);
        }
    }
}

