/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.TextKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TextSearchResult;
import com.ef_prime.rflow.ui.app.r.script.SimpleCodingScrollPane;
import com.ef_prime.rflow.ui.base.SubstanceUI;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.keyvalue.KeyWidget;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;

public class TextKeyWidget
extends LabeledWidget
implements PropertyChangeListener {
    private CodingTextArea textArea;

    public TextKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    public CodingTextArea getTextArea() {
        return this.textArea;
    }

    public TextKey getKey() {
        return (TextKey)super.getKey();
    }

    protected CodingTextArea createCodingTextArea(String string) {
        return new CodingTextArea(string){

            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.getToolTipText() != null) {
                    return this.getToolTipText();
                }
                return super.getToolTipText(mouseEvent);
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                if (this.getDocument().getLength() == 0) {
                    int n = this.getLineHeight() + this.getInsets().top + this.getInsets().bottom;
                    return new Dimension(dimension.width, n);
                }
                return new Dimension(dimension.width, this.getPreferredSize().height);
            }
        };
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        this.textArea = this.createCodingTextArea((String)this.getKeyValue());
        this.textArea.setHighlightCurrentLine(this.getKey().isLineHighlight());
        this.textArea.setBracketMatchingOnFocus(this.getKey().isHideBracketMatch());
        if (!this.getKey().isMarkOccurences()) {
            this.textArea.setMarkOccurrences(false);
            this.textArea.setMarkOccurrenceAfterFocus(false);
        }
        this.textArea.setCaretTrace(this.getKey().isCaretTrace());
        this.textArea.addPropertyChangeListener("enabled", this);
        String string = this.getKey().getEmptyMessage(this.getValueMap());
        if (!StringUtils.isEmpty((CharSequence)string)) {
            this.textArea.setEmptyMessage(string);
            this.textArea.setEmptyMessageColor(WidgetConstants.INFO_FONT_COLOR);
        }
        if (this.getKey().isTransferFocusOnTab()) {
            this.textArea.getActionMap().put("tabPressed", new Tab());
            this.textArea.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabPressed");
            this.textArea.getActionMap().put("shiftTabPressed", new ShiftTab());
            this.textArea.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "shiftTabPressed");
        }
        if (!this.getKey().isNoScroll()) {
            SimpleCodingScrollPane simpleCodingScrollPane = new SimpleCodingScrollPane((RTextArea)this.textArea){

                public void setToolTipText(String string) {
                    super.setToolTipText(string);
                    Gutter gutter = this.getGutter();
                    if (gutter.isDisplayable()) {
                        gutter.setToolTipText(string);
                        if (gutter.getIconArea().isDisplayable()) {
                            gutter.getIconArea().setToolTipText(string);
                        }
                        if (gutter.getLineNumberList().isDisplayable()) {
                            gutter.getLineNumberList().setToolTipText(string);
                        }
                        if (gutter.getFoldIndicator().isDisplayable()) {
                            gutter.getFoldIndicator().setToolTipText(string);
                        }
                    }
                    this.getTextArea().setToolTipText(string);
                }
            };
            simpleCodingScrollPane.setLineNumbersEnabled(this.getKey().isRowNumber());
            this.add(new JLayer<Component>((Component)((Object)simpleCodingScrollPane), new TextLayerUI()), "Center");
        } else {
            this.textArea.setBorder(new CompoundBorder(new LineBorder(SubstanceUI.COLOR_BORDER), new EmptyBorder(2, 4, 2, 4)));
            this.add(new JLayer<Component>((Component)((Object)this.textArea), new TextLayerUI()), "Center");
        }
        this.textArea.getDocument().addDocumentListener(this.createUpdateDocumentListener());
        this.textArea.addFocusListener(this.createUpdateFocusListener());
    }

    @Override
    public void updateWidget() {
        this.textArea.setText((String)this.getKeyValue());
    }

    @Override
    public boolean startEditing() {
        this.textArea.requestFocusInWindow();
        return true;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TextSearchResult) || this.textArea == null) {
            return;
        }
        TextSearchResult textSearchResult = (TextSearchResult)searchResult;
        this.textArea.select(textSearchResult.getOffset(), textSearchResult.getEnd());
        this.textArea.requestFocusInWindow();
    }

    @Override
    public void clearSelection() {
        if (this.textArea != null) {
            this.textArea.select(0, 0);
        }
    }

    @Override
    protected Object getValue() {
        return this.textArea.getText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
    }

    private class Tab
    extends AbstractAction {
        private Tab() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            jTextComponent.transferFocus();
        }
    }

    private class ShiftTab
    extends AbstractAction {
        private ShiftTab() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
            jTextComponent.transferFocusBackward();
        }
    }

    private class TextLayerUI
    extends KeyWidget.WidgetLayerUI {
        private TextLayerUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            if (!TextKeyWidget.this.isEnabled()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
                graphics2D.setPaint(Color.WHITE);
                graphics2D.fillRect(0, 0, TextKeyWidget.this.getWidth(), TextKeyWidget.this.getHeight());
                graphics2D.dispose();
            }
        }
    }
}

