/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.TitledPanelWidgetNode;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.ui.common.keyvalue.PanelWidget;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class TitledPanelWidget
extends PanelWidget {
    private Component content;
    private Title title;
    private boolean closed;

    public TitledPanelWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    @Override
    public TitledPanelWidgetNode getWidgetNode() {
        return (TitledPanelWidgetNode)super.getWidgetNode();
    }

    @Override
    protected void prepareContent() {
        super.prepareContent();
        this.closed = !this.getWidgetNode().isDefaultOpened();
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        if (!this.closed) {
            this.loadPanelContent();
        }
        this.title = new Title(this.getWidgetNode());
        this.add((Component)this.title, "North");
        if (this.getWidgetNode().isClosable()) {
            this.refreshOpenClose();
        }
    }

    private void loadPanelContent() {
        super.loadContent();
    }

    @Override
    protected void layoutContent(Component component) {
        this.content = component;
        if (component != null) {
            this.add(component, "Center");
        }
    }

    private void toggleOpenClose() {
        if (!this.getWidgetNode().isClosable()) {
            return;
        }
        this.closed = !this.closed;
        this.refreshOpenClose();
    }

    private void refreshOpenClose() {
        if (!this.getWidgetNode().isClosable()) {
            return;
        }
        Component component = null;
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, (ComponentState)ComponentState.ENABLED);
        Icon icon = SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getComponentFontSize(component), (int)(this.closed ? 5 : 1), (SubstanceColorScheme)substanceColorScheme);
        this.title.button.setIcon(icon);
        if (this.content == null) {
            if (this.closed) {
                return;
            }
            this.loadPanelContent();
        }
        if (this.content != null) {
            if (this.content instanceof Widget) {
                ((Widget)this.content).setWidgetVisible(!this.closed);
            } else {
                this.content.setVisible(!this.closed);
            }
            Container container = this.getParent();
            if (container != null) {
                container.revalidate();
                container.repaint();
            }
        }
    }

    private class Title
    extends JPanel
    implements MouseListener {
        private OpenCloseButton button;

        public Title(TitledPanelWidgetNode titledPanelWidgetNode) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 4 0, fill", "[][grow][]"));
            JLabel jLabel = new JLabel(titledPanelWidgetNode.getTitle());
            jLabel.setForeground(Color.BLUE);
            JSeparator jSeparator = new JSeparator(0);
            this.addMouseListener(this);
            this.add(jLabel);
            this.add((Component)jSeparator, "growx");
            if (titledPanelWidgetNode.isClosable()) {
                this.button = new OpenCloseButton();
                this.add(this.button);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (UIUtility.isLeftMouseButton(mouseEvent)) {
                TitledPanelWidget.this.toggleOpenClose();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class OpenCloseButton
    extends JButton
    implements ActionListener {
        public OpenCloseButton() {
            this.addActionListener(this);
            this.setFocusable(false);
            this.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TitledPanelWidget.this.toggleOpenClose();
        }
    }
}

