/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.UnboundTableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.common.table.UnboundTableModel;
import com.ef_prime.rflow.core.common.table.UnboundTableModelEvent;
import com.ef_prime.rflow.core.common.table.UnboundTableModelEventHandler;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.core.feature.search.TableTextSearchResult;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.RowHeaderResizer;
import com.ef_prime.rflow.ui.common.component.TextComponentContainer;
import com.ef_prime.rflow.ui.common.keyvalue.LabeledWidget;
import com.ef_prime.rflow.ui.common.table.EditingTable;
import com.ef_prime.rflow.ui.common.table.TableDataTransferable;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableHeaderCellRenderer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class UnboundTableKeyWidget
extends LabeledWidget
implements UnboundTableModelEventHandler {
    private static final Logger LOGGER = Logger.getLogger(UnboundTableKeyWidget.class.getName());
    private static final String SUBSTANCELAF_HIGHLIGHT_CELLS = "substancelaf.highlightCells";
    private JScrollPane scrollPane;
    private UnboundTable table;
    private UnboundTableActions actions;
    private TableUndoManager undoManager;
    private UndoableEditSupport undoableEditSupport;

    public UnboundTableKeyWidget(ValueMap valueMap, WidgetNode widgetNode) {
        super(valueMap, widgetNode);
    }

    public UnboundTableKey getKey() {
        return (UnboundTableKey)super.getKey();
    }

    @Override
    protected void loadContent() {
        this.setLayout(new BorderLayout());
        UnboundTableModel unboundTableModel = (UnboundTableModel)this.getKeyValue();
        UIUnboundTableModel uIUnboundTableModel = new UIUnboundTableModel(unboundTableModel);
        this.table = new UnboundTable(uIUnboundTableModel);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.addComponentListener(this.table);
        RowHeaderTable rowHeaderTable = new RowHeaderTable(uIUnboundTableModel);
        this.scrollPane.setRowHeaderView(rowHeaderTable);
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", rowHeaderTable.getTableHeader());
        this.scrollPane.getRowHeader().addChangeListener(new RowHeaderChangeListener());
        RowHeaderResizer.install(this.scrollPane);
        this.add(this.createLayer(this.scrollPane));
        this.actions = new UnboundTableActions();
        this.actions.installActions(this.table, false, 1);
        this.actions.installActions(rowHeaderTable, false, 1);
        UIUtility.setPreferredWidth(30, this.scrollPane.getRowHeader());
        this.undoManager = new TableUndoManager();
        this.undoableEditSupport = new TableUndoableEditSupport();
        this.undoableEditSupport.addUndoableEditListener(this.undoManager);
    }

    @Override
    protected Object getValue() {
        return new UnsupportedOperationException();
    }

    @Override
    public boolean startEditing() {
        this.table.setRowSelectionInterval(0, 0);
        this.table.setColumnSelectionInterval(0, 0);
        this.table.requestFocusInWindow();
        return true;
    }

    @Override
    public void select(SearchResult searchResult) {
        if (!(searchResult instanceof TableTextSearchResult) || this.table == null) {
            return;
        }
        this.table.select((TableTextSearchResult)searchResult);
    }

    @Override
    public void clearSelection() {
        this.table.clearSelection();
    }

    @Override
    public void updateWidget() {
    }

    @Override
    public void updateImmediately() {
        super.updateImmediately();
        this.table.stopEditing();
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        ((UnboundTableModel)this.getKeyValue()).addEventHandler(this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        ((UnboundTableModel)this.getKeyValue()).removeEventHandler(this);
    }

    private UnboundTable getTable() {
        return this.table;
    }

    private RowHeaderTable getRowHeaderTable() {
        return (RowHeaderTable)this.scrollPane.getRowHeader().getView();
    }

    private JPopupMenu createTablePopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(UnboundTableActions.Clear.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(UnboundTableActions.Cut.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.Copy.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.Paste.class));
        return jPopupMenu;
    }

    private JPopupMenu createColumnHeaderPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(UnboundTableActions.Clear.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.InsertColumn.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.RemoveColumn.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(UnboundTableActions.Cut.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.Copy.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.Paste.class));
        return jPopupMenu;
    }

    private JPopupMenu createRowHeaderPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(UnboundTableActions.Clear.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.InsertRow.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.RemoveRow.class));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(UnboundTableActions.Cut.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.Copy.class));
        jPopupMenu.add(this.actions.get(UnboundTableActions.Paste.class));
        return jPopupMenu;
    }

    @Override
    public void unboundTableChanged(UnboundTableModelEvent unboundTableModelEvent) {
        if (this.undoManager.lock) {
            return;
        }
        switch (unboundTableModelEvent.getType()) {
            case 1: {
                this.undoableEditSupport.postEdit(new CellUpdateEdit(unboundTableModelEvent.getRows()[0], unboundTableModelEvent.getColumns()[0], unboundTableModelEvent.getOldValue(), unboundTableModelEvent.getNewValue()));
                break;
            }
            case 0: {
                if (unboundTableModelEvent.getRows() != null && unboundTableModelEvent.getColumns() == null) {
                    this.undoableEditSupport.postEdit(new RowInsertEdit(unboundTableModelEvent.getRows()));
                    break;
                }
                if (unboundTableModelEvent.getRows() != null || unboundTableModelEvent.getColumns() == null) break;
                this.undoableEditSupport.postEdit(new ColumnInsertEdit(unboundTableModelEvent.getColumns()));
                break;
            }
            case 2: {
                if (unboundTableModelEvent.getRows() != null && unboundTableModelEvent.getColumns() == null) {
                    this.undoableEditSupport.postEdit(new RowRemoveEdit(unboundTableModelEvent.getRows(), unboundTableModelEvent.getDeleted()));
                    break;
                }
                if (unboundTableModelEvent.getRows() != null || unboundTableModelEvent.getColumns() == null) break;
                this.undoableEditSupport.postEdit(new ColumnRemoveEdit(unboundTableModelEvent.getColumns(), unboundTableModelEvent.getDeleted()));
                break;
            }
        }
    }

    private class UIUnboundTableModel
    extends AbstractTableModel {
        private UnboundTableModel model;
        private int columnCount = 10;

        public UIUnboundTableModel(UnboundTableModel unboundTableModel) {
            this.model = unboundTableModel;
        }

        public void refreshColumnCount() {
            int n;
            if (UnboundTableKeyWidget.this.scrollPane == null) {
                this.columnCount = this.model.getColumnCount() + 5;
                return;
            }
            int n2 = UnboundTableKeyWidget.this.scrollPane.getWidth();
            TableColumnModel tableColumnModel = UnboundTableKeyWidget.this.table.getColumnModel();
            for (n = 0; n < tableColumnModel.getColumnCount() && (n2 -= tableColumnModel.getColumn(n).getWidth()) >= 0; ++n) {
            }
            int n3 = n2 > 0 ? tableColumnModel.getColumnCount() + n2 / 75 : n;
            this.columnCount = Math.max(this.model.getColumnCount() + 5, ++n3);
        }

        @Override
        public int getRowCount() {
            if (UnboundTableKeyWidget.this.scrollPane == null) {
                return this.model.getRowCount() + 5;
            }
            int n = UnboundTableKeyWidget.this.scrollPane.getHeight() / UnboundTableKeyWidget.this.table.getRowHeight() + 1;
            return Math.max(this.model.getRowCount() + 5, n);
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public String getRowName(int n) {
            return this.model.getRowName(n);
        }

        @Override
        public String getColumnName(int n) {
            return this.model.getColumnName(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.model.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            int n3 = this.model.getRowCount();
            int n4 = this.model.getColumnCount();
            this.model.setValueAt(object, n, n2);
            this.fireTableCellUpdated(n, n2);
            if (n4 != this.model.getColumnCount()) {
                this.refreshColumnCount();
                this.fireTableStructureChanged();
            } else if (n3 != this.model.getRowCount()) {
                this.fireTableRowsInserted(n3, this.model.getRowCount() - 1);
            }
        }

        public void beginValueChange() {
            this.model.beginValueChange();
        }

        public void endValueChange() {
            this.model.endValueChange();
        }

        public boolean isDataRow(int n) {
            return n < this.model.getRowCount();
        }

        public boolean isDataColumn(int n) {
            return n < this.model.getColumnCount();
        }

        public boolean isDataCell(int n, int n2) {
            return this.isDataRow(n) && this.isDataColumn(n2);
        }

        public int getDataRowCount() {
            return this.model.getRowCount();
        }

        public int getDataColumnCount() {
            return this.model.getColumnCount();
        }

        public int[] toDataRows(int[] nArray) {
            return this.model.toDataRows(nArray);
        }

        public int[] toDataColumns(int[] nArray) {
            return this.model.toDataColumns(nArray);
        }
    }

    private class UnboundTable
    extends EditingTable
    implements ComponentListener,
    HierarchyListener {
        private TableTextSearchResult searchResult;

        public UnboundTable(TableModel tableModel) {
            super(tableModel);
            this.setAutoResizeMode(0);
            this.setCellSelectionEnabled(true);
            this.setAutoscrolls(true);
            this.setSurrendersFocusOnKeystroke(true);
            this.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new UnboundTableRenderer()));
            this.setDefaultEditor(Object.class, new UnboundTableCellEditor());
            this.setTableHeader(new UnboundTableHeader(this.getColumnModel()));
            this.getTableHeader().setReorderingAllowed(false);
            this.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new UnboundTableHeaderRenderer()));
            if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
                this.putClientProperty("substancelaf.tableLeadingVerticalLine", Boolean.FALSE);
                this.putClientProperty(UnboundTableKeyWidget.SUBSTANCELAF_HIGHLIGHT_CELLS, Boolean.FALSE);
            }
            UnboundTableHandler unboundTableHandler = new UnboundTableHandler();
            this.addMouseListener(unboundTableHandler);
            this.getTableHeader().addMouseListener(unboundTableHandler);
            this.getSelectionModel().addListSelectionListener(unboundTableHandler);
            this.getColumnModel().getSelectionModel().addListSelectionListener(unboundTableHandler);
            UIUtility.setAutoResizeSupport(this);
        }

        @Override
        public UIUnboundTableModel getModel() {
            return (UIUnboundTableModel)super.getModel();
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return UIUtility.getTableToolTip(mouseEvent);
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl) {
                JTextComponent jTextComponent;
                Component component = this.getEditorComponent();
                if (component instanceof TextComponentContainer && (jTextComponent = ((TextComponentContainer)((Object)component)).getTextComponent()) != null) {
                    component = jTextComponent;
                }
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
            }
            return bl;
        }

        @Override
        public void createDefaultColumnsFromModel() {
            block3: {
                TableColumnModel tableColumnModel;
                UIUnboundTableModel uIUnboundTableModel;
                block2: {
                    uIUnboundTableModel = this.getModel();
                    tableColumnModel = this.getColumnModel();
                    if (tableColumnModel.getColumnCount() >= uIUnboundTableModel.getColumnCount()) break block2;
                    int n = uIUnboundTableModel.getColumnCount() - tableColumnModel.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        this.addColumn(new TableColumn(tableColumnModel.getColumnCount()));
                    }
                    break block3;
                }
                if (tableColumnModel.getColumnCount() <= uIUnboundTableModel.getColumnCount()) break block3;
                int n = tableColumnModel.getColumnCount() - uIUnboundTableModel.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    tableColumnModel.removeColumn(tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1));
                }
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
                int n = this.getColumnCount();
                this.createDefaultColumnsFromModel();
                int n2 = this.getColumnCount();
                if (n > n2) {
                    this.getColumnModel().getSelectionModel().removeIndexInterval(n2, n - 1);
                }
                return;
            }
            super.tableChanged(tableModelEvent);
        }

        public void select(TableTextSearchResult tableTextSearchResult) {
            if (tableTextSearchResult.getRow() >= this.getModel().getRowCount() || tableTextSearchResult.getColumn() >= this.getModel().getColumnCount()) {
                return;
            }
            UnboundTableKeyWidget.this.table.setRowSelectionInterval(tableTextSearchResult.getRow(), tableTextSearchResult.getRow());
            UnboundTableKeyWidget.this.table.setColumnSelectionInterval(tableTextSearchResult.getColumn(), tableTextSearchResult.getColumn());
            UnboundTableKeyWidget.this.table.editCellAt(tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
            Component component = UnboundTableKeyWidget.this.table.getEditorComponent();
            this.searchResult = tableTextSearchResult;
            component.addHierarchyListener(this);
            JComboBox jComboBox = null;
            if (component instanceof JComboBox) {
                jComboBox = (JComboBox)component;
            }
            if (component instanceof TextComponentContainer) {
                component = ((TextComponentContainer)((Object)component)).getTextComponent();
            }
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).select(tableTextSearchResult.getOffset(), tableTextSearchResult.getOffset() + tableTextSearchResult.getLength());
                component.requestFocusInWindow();
                if (jComboBox != null) {
                    JComboBox jComboBox2 = jComboBox;
                    SwingUtilities.invokeLater(() -> jComboBox2.setPopupVisible(false));
                }
            }
        }

        private void stopEditing() {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
        }

        private void cancelEditing() {
            if (this.isEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
        }

        private String getStringValueAt(int n, int n2) {
            Object object = this.getValueAt(n, n2);
            return object == null ? "" : object.toString();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = this.getModel().getColumnCount();
            this.getModel().refreshColumnCount();
            if (this.getModel().getColumnCount() != n) {
                TableTextSearchResult tableTextSearchResult = this.searchResult;
                this.getModel().fireTableStructureChanged();
                if (tableTextSearchResult != null) {
                    this.select(tableTextSearchResult);
                }
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) == 0L) {
                return;
            }
            Component component = hierarchyEvent.getComponent();
            if (component == null) {
                return;
            }
            if (!component.isDisplayable()) {
                this.searchResult = null;
                component.removeHierarchyListener(this);
            }
        }

        private class UnboundTableRenderer
        extends SubstanceDefaultTableCellRenderer {
            private Border focusBorder = new LineBorder(Color.BLACK, 2);

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setBackground(Color.WHITE);
                if (bl && bl2 && !((Boolean)jTable.getClientProperty(UnboundTableKeyWidget.SUBSTANCELAF_HIGHLIGHT_CELLS)).booleanValue()) {
                    this.setBackground(Color.WHITE);
                    this.setBorder(this.focusBorder);
                }
                if (!UnboundTable.this.getModel().isDataCell(n, n2)) {
                    this.setText("-");
                    this.setHorizontalAlignment(0);
                    this.setForeground(Color.LIGHT_GRAY);
                } else {
                    this.setHorizontalAlignment(2);
                }
                return this;
            }
        }

        private class UnboundTableCellEditor
        extends AbstractCellEditor
        implements TableCellEditor,
        ActionListener,
        FocusListener,
        KeyListener {
            private JTextField field = new JTextField();
            private UndoManager undoManager;

            public UnboundTableCellEditor() {
                this.field.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(1, 1, 1, 1)));
                this.field.addActionListener(this);
                this.field.addFocusListener(this);
                this.field.addKeyListener(this);
                this.undoManager = new UndoManager();
                this.field.getDocument().addUndoableEditListener(this.undoManager);
                EditorActions editorActions = new EditorActions();
                editorActions.installActions(this.field, false, 0);
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    return ((MouseEvent)eventObject).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                return this.field.getText();
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                this.field.setText(object == null ? "" : object.toString());
                this.undoManager.discardAllEdits();
                return this.field;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UnboundTableKeyWidget.this.table.getEditingRow();
                int n2 = UnboundTableKeyWidget.this.table.getEditingColumn();
                this.stopCellEditing();
                if (n >= 0 && n2 >= 0 && n + 1 < UnboundTableKeyWidget.this.table.getRowCount() && n2 < UnboundTableKeyWidget.this.table.getColumnCount()) {
                    UnboundTableKeyWidget.this.table.setRowSelectionInterval(n + 1, n + 1);
                    UnboundTableKeyWidget.this.table.setColumnSelectionInterval(n2, n2);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                int n = UnboundTableKeyWidget.this.table.getEditingRow();
                int n2 = UnboundTableKeyWidget.this.table.getEditingColumn();
                this.stopCellEditing();
                if (n >= 0 && n2 >= 0 && n < UnboundTableKeyWidget.this.table.getRowCount() && n2 < UnboundTableKeyWidget.this.table.getColumnCount()) {
                    UnboundTableKeyWidget.this.table.setRowSelectionInterval(n, n);
                    UnboundTableKeyWidget.this.table.setColumnSelectionInterval(n2, n2);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39 && this.field.getDocument().getLength() == this.field.getCaretPosition()) {
                    keyEvent.consume();
                    this.stopCellEditing();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            private class EditorActions
            extends Actions {
                public EditorActions() {
                    this.put(new Undo());
                    this.put(new Redo());
                    this.put(new Tab());
                    this.put(new Forward());
                    this.put(new Backward());
                }

                private void moveCaret(boolean bl, ActionEvent actionEvent) {
                    boolean bl2;
                    Caret caret = UnboundTableCellEditor.this.field.getCaret();
                    boolean bl3 = bl ? caret.getDot() == UnboundTableCellEditor.this.field.getDocument().getLength() : (bl2 = caret.getDot() == 0);
                    if (caret.getDot() == caret.getMark() && bl2) {
                        int n;
                        int n2 = UnboundTableKeyWidget.this.table.getEditingRow();
                        int n3 = UnboundTableKeyWidget.this.table.getEditingColumn();
                        UnboundTableCellEditor.this.stopCellEditing();
                        int n4 = n = bl ? n3 + 1 : n3 - 1;
                        if (n2 >= 0 && n >= 0 && n2 < UnboundTableKeyWidget.this.table.getRowCount() && n < UnboundTableKeyWidget.this.table.getColumnCount()) {
                            UnboundTableKeyWidget.this.table.setRowSelectionInterval(n2, n2);
                            UnboundTableKeyWidget.this.table.setColumnSelectionInterval(n, n);
                        }
                    } else {
                        String string = bl ? "caret-forward" : "caret-backward";
                        UnboundTableCellEditor.this.field.getActionMap().get(string).actionPerformed(actionEvent);
                    }
                }

                private class Undo
                extends AbstractAction {
                    public Undo() {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (UnboundTableCellEditor.this.undoManager.canUndo()) {
                            UnboundTableCellEditor.this.undoManager.undo();
                        }
                    }
                }

                private class Redo
                extends AbstractAction {
                    public Redo() {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (UnboundTableCellEditor.this.undoManager.canRedo()) {
                            UnboundTableCellEditor.this.undoManager.redo();
                        }
                    }
                }

                private class Tab
                extends AbstractAction {
                    public Tab() {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = UnboundTableKeyWidget.this.table.getEditingRow();
                        int n2 = UnboundTableKeyWidget.this.table.getEditingColumn();
                        UnboundTableCellEditor.this.stopCellEditing();
                        if (n >= 0 && n2 >= 0 && n < UnboundTableKeyWidget.this.table.getRowCount() && n2 + 1 < UnboundTableKeyWidget.this.table.getColumnCount()) {
                            UnboundTableKeyWidget.this.table.setRowSelectionInterval(n, n);
                            UnboundTableKeyWidget.this.table.setColumnSelectionInterval(n2 + 1, n2 + 1);
                        }
                    }
                }

                private class Forward
                extends AbstractAction {
                    public Forward() {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 0));
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorActions.this.moveCaret(true, actionEvent);
                    }
                }

                private class Backward
                extends AbstractAction {
                    public Backward() {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 0));
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorActions.this.moveCaret(false, actionEvent);
                    }
                }
            }
        }

        private class UnboundTableHeader
        extends JTableHeader {
            public UnboundTableHeader(TableColumnModel tableColumnModel) {
                super(tableColumnModel);
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return UIUtility.getTableHeaderToolTip(mouseEvent);
            }
        }

        private class UnboundTableHeaderRenderer
        extends SubstanceDefaultTableHeaderCellRenderer {
            private UnboundTableHeaderRenderer() {
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!bl) {
                    this.setForeground(UnboundTable.this.getModel().isDataCell(n, n2) ? Color.BLACK : Color.GRAY);
                }
                return this;
            }
        }

        private class UnboundTableHandler
        implements MouseListener,
        ListSelectionListener {
            private UnboundTableHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == UnboundTable.this) {
                    if (UIUtility.isLeftMouseButton(mouseEvent)) {
                        UnboundTable.this.setColumnSelectionAllowed(true);
                        UnboundTable.this.setRowSelectionAllowed(true);
                        UnboundTableKeyWidget.this.getRowHeaderTable().clearSelection();
                    } else if (UIUtility.isRightMouseButton(mouseEvent)) {
                        JPopupMenu jPopupMenu;
                        boolean bl = ArrayUtils.contains((int[])UnboundTable.this.getSelectedColumns(), (int)UIUtility.getColumn(mouseEvent));
                        boolean bl2 = ArrayUtils.contains((int[])UnboundTable.this.getSelectedRows(), (int)UIUtility.getRow(mouseEvent));
                        if (!bl || !bl2) {
                            UnboundTable.this.setColumnSelectionAllowed(true);
                            UnboundTable.this.setRowSelectionAllowed(true);
                            UnboundTableKeyWidget.this.getRowHeaderTable().clearSelection();
                            UnboundTable.this.changeSelection(UIUtility.getRow(mouseEvent), UIUtility.getColumn(mouseEvent), false, false);
                        }
                        if ((jPopupMenu = UnboundTableKeyWidget.this.createTablePopupMenu()) != null) {
                            jPopupMenu.show(UnboundTable.this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                        }
                    }
                } else if (mouseEvent.getSource() == UnboundTable.this.getTableHeader()) {
                    JPopupMenu jPopupMenu;
                    if (mouseEvent.isConsumed()) {
                        return;
                    }
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    int n = UnboundTable.this.convertColumnIndexToModel(jTableHeader.columnAtPoint(mouseEvent.getPoint()));
                    if (n >= 0) {
                        UnboundTable.this.setColumnSelectionAllowed(true);
                        UnboundTable.this.setRowSelectionAllowed(false);
                        int n2 = UnboundTable.this.getSelectedRow();
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        UnboundTableKeyWidget.this.getRowHeaderTable().clearSelection();
                        UnboundTable.this.requestFocusInWindow();
                        if (!UIUtility.isRightMouseButton(mouseEvent) || !ArrayUtils.contains((int[])UnboundTable.this.getSelectedColumns(), (int)n)) {
                            UnboundTable.this.setAutoscrolls(false);
                            UnboundTable.this.changeSelection(n2, n, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                            UnboundTable.this.setAutoscrolls(true);
                        }
                    }
                    if (UIUtility.isRightMouseButton(mouseEvent) && (jPopupMenu = UnboundTableKeyWidget.this.createColumnHeaderPopupMenu()) != null) {
                        jPopupMenu.show(UnboundTable.this.getTableHeader(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UnboundTable unboundTable = UnboundTable.this;
                boolean bl = unboundTable.getSelectedRowCount() == 1 && unboundTable.getSelectedColumnCount() == 1;
                UnboundTable.this.putClientProperty(UnboundTableKeyWidget.SUBSTANCELAF_HIGHLIGHT_CELLS, !bl);
            }
        }
    }

    private class RowHeaderTable
    extends JTable {
        public RowHeaderTable(UIUnboundTableModel uIUnboundTableModel) {
            super(new RowHeaderTableModel(uIUnboundTableModel));
            this.getTableHeader().setReorderingAllowed(false);
            this.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new RowHeaderRenderer()));
            if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
                this.putClientProperty("substancelaf.tableLeadingVerticalLine", Boolean.FALSE);
            }
            RowHeaderHandler rowHeaderHandler = new RowHeaderHandler();
            UnboundTableKeyWidget.this.table.getSelectionModel().addListSelectionListener(rowHeaderHandler);
            UnboundTableKeyWidget.this.table.addPropertyChangeListener("rowSelectionAllowed", rowHeaderHandler);
            this.getSelectionModel().addListSelectionListener(rowHeaderHandler);
            this.addMouseListener(rowHeaderHandler);
            UIUtility.setAutoResizeSupport(this);
        }

        @Override
        public RowHeaderTableModel getModel() {
            return (RowHeaderTableModel)super.getModel();
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return UIUtility.getTableToolTip(mouseEvent);
        }

        private class RowHeaderRenderer
        extends SubstanceDefaultTableCellRenderer {
            private final Color background = new Color(240, 240, 240);
            private Color selectedBackground = new Color(200, 200, 200);

            public RowHeaderRenderer() {
                this.setHorizontalAlignment(0);
                SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)RowHeaderTable.this.getTableHeader(), (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)ComponentState.SELECTED);
                this.selectedBackground = SubstanceColorUtilities.getTopShineColor((SubstanceColorScheme)substanceColorScheme);
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                boolean bl3 = UnboundTableKeyWidget.this.getTable().getRowSelectionAllowed() && UnboundTableKeyWidget.this.getTable().getSelectionModel().isSelectedIndex(n);
                this.setBackground(bl3 ? this.selectedBackground : this.background);
                this.setForeground(RowHeaderTable.this.getModel().isDataRow(n) ? Color.BLACK : Color.GRAY);
                return this;
            }
        }

        private class RowHeaderHandler
        implements ListSelectionListener,
        PropertyChangeListener,
        MouseListener {
            private RowHeaderHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getSource() == UnboundTableKeyWidget.this.table.getSelectionModel()) {
                    RowHeaderTable.this.repaint();
                } else if (listSelectionEvent.getSource() == RowHeaderTable.this.getSelectionModel()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        return;
                    }
                    UnboundTableKeyWidget.this.table.clearSelection();
                    UnboundTableKeyWidget.this.table.setRowSelectionAllowed(true);
                    UnboundTableKeyWidget.this.table.setColumnSelectionAllowed(false);
                    int n = listSelectionModel.getMinSelectionIndex();
                    int n2 = listSelectionModel.getMaxSelectionIndex();
                    for (int i = n; i <= n2; ++i) {
                        if (!listSelectionModel.isSelectedIndex(i)) continue;
                        UnboundTableKeyWidget.this.table.addRowSelectionInterval(i, i);
                    }
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("rowSelectionAllowed".equals(propertyChangeEvent.getPropertyName())) {
                    RowHeaderTable.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                int n = UIUtility.getColumn(mouseEvent);
                int n2 = UIUtility.getRow(mouseEvent);
                if (n == 0 && n2 >= 0 && UIUtility.isRightMouseButton(mouseEvent) && !ArrayUtils.contains((int[])UnboundTableKeyWidget.this.table.getSelectedRows(), (int)n2)) {
                    RowHeaderTable.this.changeSelection(n2, n, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
                }
                if (UIUtility.isRightMouseButton(mouseEvent) && (jPopupMenu = UnboundTableKeyWidget.this.createRowHeaderPopupMenu()) != null) {
                    jPopupMenu.show(RowHeaderTable.this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        }
    }

    private class RowHeaderChangeListener
    implements ChangeListener {
        private RowHeaderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Point point = jViewport.getViewPosition();
            JViewport jViewport2 = UnboundTableKeyWidget.this.scrollPane.getViewport();
            Point point2 = jViewport2.getViewPosition();
            point2.y = point.y;
            jViewport2.setViewPosition(point2);
        }
    }

    private class UnboundTableActions
    extends Actions {
        public UnboundTableActions() {
            this.put(new Clear());
            this.put(new Copy());
            this.put(new Cut());
            this.put(new Paste());
            this.put(new InsertRow());
            this.put(new InsertColumn());
            this.put(new RemoveRow());
            this.put(new RemoveColumn());
            this.put(new Undo());
            this.put(new Redo());
        }

        private class Clear
        extends AbstractAction {
            public Clear() {
                this.putValue("Name", Messages.getString("Action.clear"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                int[] nArray = UnboundTableKeyWidget.this.table.getSelectedRows();
                int[] nArray2 = UnboundTableKeyWidget.this.table.getSelectedColumns();
                if (!UnboundTableKeyWidget.this.table.getRowSelectionAllowed()) {
                    nArray = new int[]{};
                }
                if (!UnboundTableKeyWidget.this.table.getColumnSelectionAllowed()) {
                    nArray2 = new int[]{};
                }
                UIUnboundTableModel uIUnboundTableModel = UnboundTableKeyWidget.this.table.getModel();
                nArray = uIUnboundTableModel.toDataRows(nArray);
                nArray2 = uIUnboundTableModel.toDataColumns(nArray2);
                boolean bl2 = nArray.length > 0;
                boolean bl3 = bl = nArray2.length > 0;
                if (!bl2 && !bl) {
                    return;
                }
                UnboundTableKeyWidget.this.table.cancelEditing();
                uIUnboundTableModel.beginValueChange();
                UnboundTableKeyWidget.this.undoableEditSupport.beginUpdate();
                try {
                    if (!bl2 && bl) {
                        for (int i = 0; i < uIUnboundTableModel.getDataRowCount(); ++i) {
                            for (int j = 0; j < nArray2.length; ++j) {
                                uIUnboundTableModel.setValueAt(null, i, nArray2[j]);
                            }
                        }
                    } else if (bl2 && !bl) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n = nArray[i];
                            for (int j = 0; j < uIUnboundTableModel.getDataColumnCount(); ++j) {
                                uIUnboundTableModel.setValueAt(null, n, j);
                            }
                        }
                    } else if (bl2 && bl) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n = nArray[i];
                            for (int j = 0; j < nArray2.length; ++j) {
                                uIUnboundTableModel.setValueAt(null, n, nArray2[j]);
                            }
                        }
                    }
                }
                finally {
                    uIUnboundTableModel.endValueChange();
                    UnboundTableKeyWidget.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class Copy
        extends AbstractAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                UnboundTableKeyWidget.this.table.stopEditing();
                UIUnboundTableModel uIUnboundTableModel = UnboundTableKeyWidget.this.table.getModel();
                int[] nArray = UnboundTableKeyWidget.this.table.getSelectedColumns();
                int[] nArray2 = UnboundTableKeyWidget.this.table.getSelectedRows();
                if (!UnboundTableKeyWidget.this.table.getRowSelectionAllowed()) {
                    nArray2 = new int[]{};
                }
                if (!UnboundTableKeyWidget.this.table.getColumnSelectionAllowed()) {
                    nArray = new int[]{};
                }
                nArray = uIUnboundTableModel.toDataColumns(nArray);
                boolean bl2 = (nArray2 = uIUnboundTableModel.toDataRows(nArray2)).length > 0;
                boolean bl3 = bl = nArray.length > 0;
                if (!bl2 && !bl) {
                    return;
                }
                int n = bl2 ? nArray2.length : uIUnboundTableModel.getDataRowCount();
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>(n);
                if (!bl2 && bl) {
                    for (var9_9 = 0; var9_9 < uIUnboundTableModel.getDataRowCount(); ++var9_9) {
                        ArrayList<String> arrayList2 = new ArrayList<String>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList2.add(UnboundTableKeyWidget.this.table.getStringValueAt(var9_9, nArray[i]));
                        }
                        arrayList.add(arrayList2);
                    }
                } else if (bl2 && !bl) {
                    for (var9_9 = 0; var9_9 < nArray2.length; ++var9_9) {
                        int n2 = nArray2[var9_9];
                        ArrayList<String> arrayList3 = new ArrayList<String>(uIUnboundTableModel.getDataColumnCount());
                        for (int i = 0; i < uIUnboundTableModel.getDataColumnCount(); ++i) {
                            arrayList3.add(UnboundTableKeyWidget.this.table.getStringValueAt(n2, i));
                        }
                        arrayList.add(arrayList3);
                    }
                } else if (bl2 && bl) {
                    for (var9_9 = 0; var9_9 < nArray2.length; ++var9_9) {
                        int n3 = nArray2[var9_9];
                        ArrayList<String> arrayList4 = new ArrayList<String>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList4.add(UnboundTableKeyWidget.this.table.getStringValueAt(n3, nArray[i]));
                        }
                        arrayList.add(arrayList4);
                    }
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new TableDataTransferable(arrayList), null);
            }
        }

        private class Cut
        extends AbstractAction {
            public Cut() {
                this.putValue("Name", Messages.getString("Action.cut"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnboundTableActions.this.get(Copy.class).actionPerformed(actionEvent);
                UnboundTableActions.this.get(Clear.class).actionPerformed(actionEvent);
            }
        }

        private class Paste
        extends AbstractAction {
            public Paste() {
                this.putValue("Name", Messages.getString("Action.paste"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string;
                UnboundTableKeyWidget.this.table.stopEditing();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    return;
                }
                try {
                    string = (String)clipboard.getData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Failed to get string from clipboard", exception);
                    return;
                }
                int[] nArray = UnboundTableKeyWidget.this.table.getSelectedRows();
                int[] nArray2 = UnboundTableKeyWidget.this.table.getSelectedColumns();
                int n = ArrayUtils.isEmpty((int[])nArray) ? 0 : nArray[0];
                int n2 = ArrayUtils.isEmpty((int[])nArray) ? 0 : nArray[nArray.length - 1];
                int n3 = ArrayUtils.isEmpty((int[])nArray2) ? 0 : nArray2[0];
                int n4 = ArrayUtils.isEmpty((int[])nArray2) ? 0 : nArray2[nArray2.length - 1];
                boolean bl = n == n2 && n3 == n4;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                int n5 = 0;
                try (LineIterator lineIterator = IOUtils.lineIterator((Reader)new StringReader(string));){
                    while (lineIterator.hasNext()) {
                        object = lineIterator.nextLine();
                        String[] stringArray = ((String)object).split("\t");
                        arrayList.add(stringArray);
                        n5 = Math.max(stringArray.length, n5);
                    }
                }
                object = UnboundTableKeyWidget.this.table.getModel();
                ((UIUnboundTableModel)object).beginValueChange();
                UnboundTableKeyWidget.this.undoableEditSupport.beginUpdate();
                try {
                    if (bl) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            int n6;
                            String[] stringArray = (String[])arrayList.get(i);
                            for (int j = 0; j < stringArray.length && (n6 = n3 + j) < ((UIUnboundTableModel)object).getColumnCount(); ++j) {
                                UnboundTableKeyWidget.this.table.setValueAt(stringArray[j], n + i, n6);
                            }
                        }
                    } else {
                        int n7 = n;
                        int n8 = 0;
                        while (n7 <= n2) {
                            if (n8 >= arrayList.size()) {
                                n8 = 0;
                            }
                            String[] stringArray = (String[])arrayList.get(n8);
                            int n9 = n3;
                            int n10 = 0;
                            while (n9 <= n4) {
                                if (n10 >= n5) {
                                    n10 = 0;
                                }
                                if (n10 < stringArray.length) {
                                    UnboundTableKeyWidget.this.table.setValueAt(stringArray[n10], n7, n9);
                                }
                                ++n9;
                                ++n10;
                            }
                            ++n7;
                            ++n8;
                        }
                    }
                }
                finally {
                    ((UIUnboundTableModel)object).endValueChange();
                    UnboundTableKeyWidget.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class InsertRow
        extends AbstractAction {
            public InsertRow() {
                this.putValue("Name", Messages.getString("Action.insert_row"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!UnboundTableKeyWidget.this.table.getRowSelectionAllowed()) {
                    return;
                }
                int n = UnboundTableKeyWidget.this.table.getSelectedRow();
                if (n < 0 || n >= UnboundTableKeyWidget.this.table.getModel().getDataRowCount()) {
                    return;
                }
                UnboundTableKeyWidget.this.table.getModel().model.insertRows(new int[]{n});
            }
        }

        private class InsertColumn
        extends AbstractAction {
            public InsertColumn() {
                this.putValue("Name", Messages.getString("Action.insert_column"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!UnboundTableKeyWidget.this.table.getColumnSelectionAllowed()) {
                    return;
                }
                int n = UnboundTableKeyWidget.this.table.getSelectedColumn();
                if (n < 0 || n >= UnboundTableKeyWidget.this.table.getModel().getDataColumnCount()) {
                    return;
                }
                UnboundTableKeyWidget.this.table.getModel().model.insertColumns(new int[]{n});
            }
        }

        private class RemoveRow
        extends AbstractAction {
            public RemoveRow() {
                this.putValue("Name", Messages.getString("Action.remove_row"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!UnboundTableKeyWidget.this.table.getRowSelectionAllowed()) {
                    return;
                }
                int[] nArray = UnboundTableKeyWidget.this.table.getSelectedRows();
                if (ArrayUtils.isEmpty((int[])nArray)) {
                    return;
                }
                UnboundTableKeyWidget.this.table.getModel().model.removeRows(nArray);
            }
        }

        private class RemoveColumn
        extends AbstractAction {
            public RemoveColumn() {
                this.putValue("Name", Messages.getString("Action.remove_column"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!UnboundTableKeyWidget.this.table.getColumnSelectionAllowed()) {
                    return;
                }
                int[] nArray = UnboundTableKeyWidget.this.table.getSelectedColumns();
                if (ArrayUtils.isEmpty((int[])nArray)) {
                    return;
                }
                UnboundTableKeyWidget.this.table.getModel().model.removeColumns(nArray);
            }
        }

        private class Undo
        extends AbstractAction {
            public Undo() {
                this.putValue("Name", Messages.getString("Action.undo"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UnboundTableKeyWidget.this.undoManager.canUndo()) {
                    UnboundTableKeyWidget.this.table.getModel().beginValueChange();
                    try {
                        UnboundTableKeyWidget.this.undoManager.undo();
                    }
                    finally {
                        UnboundTableKeyWidget.this.table.getModel().endValueChange();
                    }
                }
            }
        }

        private class Redo
        extends AbstractAction {
            public Redo() {
                this.putValue("Name", Messages.getString("Action.redo"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UnboundTableKeyWidget.this.undoManager.canRedo()) {
                    UnboundTableKeyWidget.this.table.getModel().beginValueChange();
                    try {
                        UnboundTableKeyWidget.this.undoManager.redo();
                    }
                    finally {
                        UnboundTableKeyWidget.this.table.getModel().endValueChange();
                    }
                }
            }
        }
    }

    private class TableUndoManager
    extends UndoManager {
        private boolean lock;

        private TableUndoManager() {
        }

        @Override
        public synchronized void undo() throws CannotUndoException {
            this.lock = true;
            try {
                super.undo();
            }
            finally {
                this.lock = false;
            }
        }

        @Override
        public synchronized void redo() throws CannotRedoException {
            this.lock = true;
            try {
                super.redo();
            }
            finally {
                this.lock = false;
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (this.lock) {
                return;
            }
            super.undoableEditHappened(undoableEditEvent);
        }
    }

    private class TableUndoableEditSupport
    extends UndoableEditSupport {
        private TableUndoableEditSupport() {
        }

        @Override
        public synchronized void beginUpdate() {
            super.beginUpdate();
            this.compoundEdit.addEdit(new SelectionEdit(UnboundTableKeyWidget.this.table.getSelectedRows(), UnboundTableKeyWidget.this.table.getSelectedColumns(), true));
        }

        @Override
        public synchronized void endUpdate() {
            this.compoundEdit.addEdit(new SelectionEdit(UnboundTableKeyWidget.this.table.getSelectedRows(), UnboundTableKeyWidget.this.table.getSelectedColumns(), false));
            super.endUpdate();
        }
    }

    private class CellUpdateEdit
    extends AbstractUndoableEdit {
        private int row;
        private int column;
        private Object oldValue;
        private Object newValue;

        public CellUpdateEdit(int n, int n2, Object object, Object object2) {
            this.row = n;
            this.column = n2;
            this.oldValue = object;
            this.newValue = object2;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            UnboundTableKeyWidget.this.table.getModel().setValueAt(this.newValue, this.row, this.column);
            this.setSelection();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            UnboundTableKeyWidget.this.table.getModel().setValueAt(this.oldValue, this.row, this.column);
            this.setSelection();
        }

        private void setSelection() {
            UnboundTableKeyWidget.this.table.setRowSelectionInterval(this.row, this.row);
            UnboundTableKeyWidget.this.table.setColumnSelectionInterval(this.column, this.column);
        }
    }

    private class RowInsertEdit
    extends AbstractUndoableEdit {
        private int[] rows;

        public RowInsertEdit(int[] nArray) {
            this.rows = nArray;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            UnboundTableKeyWidget.this.table.getModel().model.insertRows(this.rows);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            UnboundTableKeyWidget.this.table.getModel().model.removeRows(this.rows);
        }
    }

    private class ColumnInsertEdit
    extends AbstractUndoableEdit {
        private int[] columns;

        public ColumnInsertEdit(int[] nArray) {
            this.columns = nArray;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            UnboundTableKeyWidget.this.table.getModel().model.insertColumns(this.columns);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            UnboundTableKeyWidget.this.table.getModel().model.removeColumns(this.columns);
        }
    }

    private class RowRemoveEdit
    extends AbstractUndoableEdit {
        private int[] rows;
        private List<List<Object>> removed;

        public RowRemoveEdit(int[] nArray, List<List<Object>> list) {
            this.rows = nArray;
            this.removed = list;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            UnboundTableKeyWidget.this.table.getModel().model.removeRows(this.rows);
        }

        @Override
        public void undo() throws CannotUndoException {
            int n;
            super.undo();
            int[] nArray = new int[this.rows.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.rows[n] - n;
            }
            UnboundTableKeyWidget.this.table.getModel().model.insertRows(nArray);
            for (n = 0; n < this.rows.length; ++n) {
                int n2 = this.rows[n];
                List<Object> list = this.removed.get(n);
                if (list == null) continue;
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    if (object == null) continue;
                    UnboundTableKeyWidget.this.table.getModel().setValueAt(object, n2, i);
                }
            }
        }
    }

    private class ColumnRemoveEdit
    extends AbstractUndoableEdit {
        private int[] columns;
        private List<List<Object>> removed;

        public ColumnRemoveEdit(int[] nArray, List<List<Object>> list) {
            this.columns = nArray;
            this.removed = list;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            UnboundTableKeyWidget.this.table.getModel().model.removeColumns(this.columns);
        }

        @Override
        public void undo() throws CannotUndoException {
            int n;
            super.undo();
            int[] nArray = new int[this.columns.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.columns[n] - n;
            }
            UnboundTableKeyWidget.this.table.getModel().model.insertColumns(nArray);
            for (n = 0; n < UnboundTableKeyWidget.this.table.getModel().getDataRowCount(); ++n) {
                for (int i = 0; i < this.columns.length; ++i) {
                    Object object = this.removed.get(i).get(n);
                    if (object == null) continue;
                    UnboundTableKeyWidget.this.table.getModel().setValueAt(object, n, this.columns[i]);
                }
            }
        }
    }

    private class SelectionEdit
    extends AbstractUndoableEdit {
        private int[] rows;
        private int[] columns;
        private boolean clear;

        public SelectionEdit(int[] nArray, int[] nArray2, boolean bl) {
            this.rows = nArray;
            this.columns = nArray2;
            this.clear = bl;
        }

        private void setSelection() {
            UnboundTableKeyWidget.this.table.clearSelection();
            for (int n : this.rows) {
                UnboundTableKeyWidget.this.table.addRowSelectionInterval(n, n);
            }
            for (int n : this.columns) {
                UnboundTableKeyWidget.this.table.addColumnSelectionInterval(n, n);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (!this.clear) {
                this.setSelection();
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.clear) {
                this.setSelection();
            }
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }

    private class RowHeaderTableModel
    extends AbstractTableModel {
        private UIUnboundTableModel model;

        public RowHeaderTableModel(UIUnboundTableModel uIUnboundTableModel) {
            this.model = uIUnboundTableModel;
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return " ";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Object.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.model.getRowName(n);
        }

        public boolean isDataRow(int n) {
            return this.model.isDataRow(n);
        }
    }
}

