/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.keyvalue;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.ViewOptions;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.feature.search.SearchResult;
import com.ef_prime.rflow.node.ui.OpViewFactory;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;

public abstract class Widget
extends JComponent {
    private ValueMap valueMap;
    private WidgetNode widgetNode;
    private boolean isContentLoaded;
    private boolean updating;

    public Widget(ValueMap valueMap, WidgetNode widgetNode) {
        this.valueMap = valueMap;
        this.widgetNode = widgetNode;
        this.prepareContent();
        if (this.shouldBeVisible()) {
            this.isContentLoaded = true;
            this.loadContent();
            this.contentDidload();
        }
        this.addHierarchyListener(new HierarchyHandler());
    }

    protected void prepareContent() {
    }

    protected abstract void loadContent();

    protected void contentDidload() {
        if (!this.isEnabled()) {
            UIUtility.setEnabled(false, this);
        }
    }

    protected boolean isContentLoaded() {
        return this.isContentLoaded;
    }

    public abstract boolean startEditing();

    public ValueMap getValueMap() {
        return this.valueMap;
    }

    public WidgetNode getWidgetNode() {
        return this.widgetNode;
    }

    public ViewOptions getViewOptions() {
        return (ViewOptions)this.getWidgetNode().getRoot().getProperty(OpViewFactory.PROPERTY_VIEW_OPTIONS);
    }

    public boolean isWizard() {
        return this.getViewOptions() != null && this.getViewOptions().isWizard();
    }

    public boolean isTab() {
        return this.getViewOptions() != null && this.getViewOptions().isTab();
    }

    public Component getLabel() {
        return null;
    }

    public Widget getWidget(Key<?> key) {
        return null;
    }

    public void select(SearchResult searchResult) {
    }

    public void clearSelection() {
    }

    public void setWidgetVisible(final boolean bl) {
        UIUtility.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Widget.this.isVisible() == bl) {
                    return;
                }
                if (bl && !Widget.this.isContentLoaded) {
                    Widget.this.isContentLoaded = true;
                    Widget.this.loadContent();
                    Widget.this.contentDidload();
                }
                Widget.this.setVisible(bl);
                if (Widget.this.getLabel() != null) {
                    Widget.this.getLabel().setVisible(bl);
                }
                Widget.this.visibleStateChanged();
            }
        });
    }

    protected void visibleStateChanged() {
    }

    public abstract void updateImmediately();

    public boolean isUpdating() {
        return this.updating;
    }

    public void updateWidgetValue() {
        this.updating = true;
        this.updateWidget();
        this.updating = false;
    }

    public abstract void updateWidget();

    protected void viewDidBecomeDisplayable() {
    }

    protected void viewDidBecomeUndisplayable() {
    }

    protected void viewShown() {
        this.revalidate();
        this.repaint();
    }

    protected void viewHidden() {
    }

    protected boolean shouldBeVisible() {
        if (!this.widgetNode.isKeyLink()) {
            return true;
        }
        for (KeyLink keyLink : this.widgetNode.getKeyLinks()) {
            boolean bl = keyLink.accept(this.valueMap);
            if ("VISIBLE_ON".equals(keyLink.getType())) {
                return bl;
            }
            if (!"VISIBLE_OFF".equals(keyLink.getType())) continue;
            return !bl;
        }
        return true;
    }

    protected Boolean[] getKeyLinkState(WidgetNode widgetNode) {
        Boolean bl = null;
        Boolean bl2 = null;
        for (KeyLink keyLink : widgetNode.getKeyLinks()) {
            boolean bl3 = keyLink.accept(this.valueMap);
            switch (keyLink.getType()) {
                case "VISIBLE_ON": {
                    if (Boolean.FALSE.equals(bl)) break;
                    bl = bl3;
                    break;
                }
                case "VISIBLE_OFF": {
                    if (Boolean.FALSE.equals(bl)) break;
                    bl = !bl3;
                    break;
                }
                case "EDITABLE_ON": {
                    if (Boolean.FALSE.equals(bl2)) break;
                    bl2 = bl3;
                    break;
                }
                case "EDITABLE_OFF": {
                    if (Boolean.FALSE.equals(bl2)) break;
                    bl2 = !bl3;
                    break;
                }
            }
        }
        return new Boolean[]{bl, bl2};
    }

    protected void refreshKeyLinkState(String string) {
        Boolean bl;
        Boolean[] booleanArray = this.getKeyLinkState(this.widgetNode);
        Boolean bl2 = booleanArray[0];
        if (bl2 != null) {
            this.setWidgetVisible(bl2);
        }
        if ((bl = booleanArray[1]) != null) {
            final boolean bl3 = bl;
            UIUtility.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIUtility.setEnabled(bl3, Widget.this);
                    if (Widget.this.getLabel() != null) {
                        UIUtility.setEnabled(bl3, Widget.this.getLabel());
                    }
                    Widget.this.enableStateChanged();
                }
            });
        }
    }

    protected void enableStateChanged() {
    }

    private class HierarchyHandler
    implements HierarchyListener,
    ValueChangeEventHandler {
        private boolean wasDisplayable;
        private boolean wasShown;

        private HierarchyHandler() {
        }

        private void installEventHandlers() {
            if (Widget.this.widgetNode.isValueChangeEventHandler()) {
                for (ValueChangeEventHandler valueChangeEventHandler : Widget.this.widgetNode.getValueChangeEventHandlers()) {
                    Widget.this.valueMap.addEventHandlerToFirst(valueChangeEventHandler);
                }
            }
            if (Widget.this.widgetNode.isKeyLink()) {
                Widget.this.refreshKeyLinkState(null);
                Widget.this.valueMap.addEventHandler(this);
            }
        }

        private void uninstallEventHandlers() {
            if (Widget.this.widgetNode.isValueChangeEventHandler()) {
                for (ValueChangeEventHandler valueChangeEventHandler : Widget.this.widgetNode.getValueChangeEventHandlers()) {
                    Widget.this.valueMap.removeEventHandler(valueChangeEventHandler);
                }
            }
            if (Widget.this.widgetNode.isKeyLink()) {
                Widget.this.valueMap.removeEventHandler(this);
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (UIUtility.isDisplayablityChanged(hierarchyEvent)) {
                if (Widget.this.isDisplayable()) {
                    if (!this.wasDisplayable) {
                        this.wasDisplayable = true;
                        Widget.this.viewDidBecomeDisplayable();
                        this.installEventHandlers();
                    }
                } else if (this.wasDisplayable) {
                    this.wasDisplayable = false;
                    Widget.this.viewDidBecomeUndisplayable();
                    this.uninstallEventHandlers();
                }
            }
            if (UIUtility.isShowingChanged(hierarchyEvent)) {
                if (Widget.this.isShowing()) {
                    if (!this.wasShown) {
                        this.wasShown = true;
                        Widget.this.viewShown();
                    }
                } else if (this.wasShown) {
                    this.wasShown = false;
                    Widget.this.viewHidden();
                }
            }
        }

        @Override
        public void valueChanged(ValueChangeEvent valueChangeEvent) {
            Widget.this.refreshKeyLinkState(valueChangeEvent.getKey().getId());
        }
    }
}

