/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.DataTable;
import com.ef_prime.rflow.ui.common.component.Refreshable;
import com.ef_prime.rflow.ui.common.table.DataTableModel;
import com.ef_prime.rflow.ui.common.table.NullDataTableModel;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;

public class DataTablePanel
extends JPanel
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DataTablePanel.class.getName());
    private DataTableModel model;
    private DataTable dataTable;
    private JButton first;
    private JButton back;
    private JButton next;
    private JButton last;
    private JLabel rowLabel;
    private JButton refresh;
    private int page;
    private JToolBar toolBar;
    private Refreshable refreshable;

    public DataTablePanel(Refreshable refreshable) {
        this.refreshable = refreshable;
        this.setLayout(new BorderLayout());
        this.dataTable = new DataTable();
        this.dataTable.getTable().setFont(new Font("Monospaced", 0, 12));
        this.dataTable.getRowHeaderTable().setFont(this.dataTable.getTable().getFont());
        this.add(this.dataTable);
        this.first = this.createButton("16/resultset_first.png", "first", Messages.getString("Action.first"));
        this.back = this.createButton("16/resultset_previous.png", "back", Messages.getString("Action.previous"));
        this.next = this.createButton("16/resultset_next.png", "next", Messages.getString("Action.next"));
        this.last = this.createButton("16/resultset_last.png", "last", Messages.getString("Action.last"));
        if (refreshable != null) {
            this.refresh = this.createButton("16/update.png", "refresh", Messages.getString("Action.refresh"));
        }
        this.rowLabel = new JLabel();
        this.toolBar = new JToolBar();
        this.toolBar.add(this.first);
        this.toolBar.add(this.back);
        this.toolBar.add(this.next);
        this.toolBar.add(this.last);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add(this.rowLabel);
        if (this.refresh != null) {
            this.toolBar.add(Box.createHorizontalStrut(5));
            this.toolBar.add(this.refresh);
        }
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        this.setModel(null);
    }

    private JButton createButton(String string, String string2, String string3) {
        JButton jButton = new JButton(Icons.getIcon(string));
        jButton.setActionCommand(string2);
        jButton.setToolTipText(string3);
        jButton.addActionListener(this);
        jButton.setFocusable(false);
        return jButton;
    }

    private JTable getTable() {
        return this.dataTable.getTable();
    }

    private JTable getRowHeaderTable() {
        return this.dataTable.getRowHeaderTable();
    }

    public void setModel(DataTableModel dataTableModel) {
        if (this.model != null) {
            this.model.dispose();
        }
        if (dataTableModel == null) {
            dataTableModel = new NullDataTableModel();
        }
        this.model = dataTableModel;
        boolean bl = this.page <= 0;
        int n = this.dataTable.getVerticalScrollBar().getValue();
        this.getTable().setModel(dataTableModel);
        this.getRowHeaderTable().setModel(new RowHeaderDataTableModel(dataTableModel));
        this.first.setEnabled(false);
        this.back.setEnabled(!dataTableModel.isForwardOnly());
        if (dataTableModel.isForwardOnly()) {
            this.page = -1;
            this.showNext();
        } else {
            this.page = 0;
            this.showPage(this.page);
        }
        UIUtility.resizeColumns(this.getTable(), 100, 0);
        UIUtility.resizeColumns(this.getRowHeaderTable(), 100, 0, 200);
        UIUtility.setPreferredWidth(this.getRowHeaderTable().getPreferredSize().width, this.dataTable.getRowHeader());
        this.dataTable.revalidate();
        if (bl) {
            this.dataTable.getVerticalScrollBar().setValue(n);
        }
    }

    private void setRange(int n, int n2) {
        boolean bl = false;
        int n3 = n + n2;
        if (this.model.getRowCount() < this.model.getPageSize()) {
            n3 = n + this.model.getRowCount();
            bl = true;
        }
        String string = n + 1 + " - " + n3;
        if (this.model.isTotalRow()) {
            string = string + " / " + this.model.getTotalRow();
            if (this.model.getTotalRow() == n3) {
                bl = true;
            }
        }
        this.rowLabel.setText(string);
        this.first.setEnabled(n != 0 && (!this.model.isForwardOnly() || this.model.canGoFirst()));
        this.back.setEnabled(!this.model.isForwardOnly() && n != 0);
        this.next.setEnabled(this.model.hasNext() && !bl);
        this.last.setEnabled(this.model.hasNext() && !bl);
    }

    private void scrollToTop() {
        this.getTable().scrollRectToVisible(this.getTable().getCellRect(0, 0, true));
    }

    public void goFirst() {
        try {
            if (this.model.isForwardOnly()) {
                if (this.model.canGoFirst()) {
                    this.model.first();
                    this.page = -1;
                    this.showNext();
                }
            } else {
                this.page = 0;
                this.showPage(this.page);
            }
            this.scrollToTop();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to move to first.", exception);
        }
    }

    public void goLast() {
        if (!this.model.isForwardOnly()) {
            if (this.model.isTotalRow() && this.model.getTotalRow() > 0) {
                this.page = (this.model.getTotalRow() - 1) / this.model.getPageSize();
                this.showPage(this.page);
            } else {
                while (this.next.isEnabled()) {
                    this.showPage(++this.page);
                }
            }
        } else {
            while (this.next.isEnabled()) {
                this.showNext();
            }
        }
        this.getTable().scrollRectToVisible(this.getTable().getCellRect(this.model.getRowCount() - 1, 0, true));
    }

    public void showPage(int n) {
        try {
            if (n < 0) {
                return;
            }
            int n2 = this.model.getPageSize();
            int n3 = n2 * n;
            this.model.setRange(n3, n2);
            this.setRange(n * n2, n2);
            this.scrollToTop();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to move to page " + n + ".", exception);
        }
    }

    public void showNext() {
        try {
            int n = this.model.getPageSize();
            ++this.page;
            this.model.next(n);
            this.setRange(this.page * n, n);
            this.scrollToTop();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to move to next page .", exception);
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.model == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("back")) {
            if (!this.model.isForwardOnly() && this.page > 0) {
                this.showPage(--this.page);
            }
        } else if (string.equals("next")) {
            if (this.model.isForwardOnly()) {
                this.showNext();
            } else {
                this.showPage(++this.page);
            }
        } else if (string.equals("first")) {
            this.goFirst();
        } else if (string.equals("last")) {
            this.goLast();
        } else if (string.equals("refresh") && this.refreshable != null) {
            this.refreshable.refresh();
        }
    }

    private class RowHeaderDataTableModel
    extends AbstractTableModel {
        private DataTableModel model;

        public RowHeaderDataTableModel(DataTableModel dataTableModel) {
            this.model = dataTableModel;
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return " ";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.model.getRowHeaderClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.model.getRowHeaderValueAt(n);
        }
    }
}

