/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.ui.common.component.TextComponentContainer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class EditingTable
extends JTable
implements FocusListener {
    private InputMethodRequests methodRequestsDummy;
    private boolean usingInputMethod;

    public EditingTable() {
        this.init();
    }

    public EditingTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    private void init() {
        this.enableEvents(2048L);
        this.addFocusListener(this);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.methodRequestsDummy == null) {
            this.methodRequestsDummy = new InputMethodRequests(){

                private InputMethodRequests getDelegate() {
                    Component component = EditingTable.this.getTextEditorComponent();
                    return component == null ? null : component.getInputMethodRequests();
                }

                @Override
                public Rectangle getTextLocation(TextHitInfo textHitInfo) {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? null : inputMethodRequests.getTextLocation(textHitInfo);
                }

                @Override
                public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? null : inputMethodRequests.getSelectedText(attributeArray);
                }

                @Override
                public TextHitInfo getLocationOffset(int n, int n2) {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? null : inputMethodRequests.getLocationOffset(n, n2);
                }

                @Override
                public int getInsertPositionOffset() {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? 0 : inputMethodRequests.getInsertPositionOffset();
                }

                @Override
                public int getCommittedTextLength() {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? 0 : inputMethodRequests.getCommittedTextLength();
                }

                @Override
                public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? null : inputMethodRequests.getCommittedText(n, n2, attributeArray);
                }

                @Override
                public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
                    InputMethodRequests inputMethodRequests = this.getDelegate();
                    return inputMethodRequests == null ? null : inputMethodRequests.cancelLatestCommittedText(attributeArray);
                }
            };
        }
        int n = this.getSelectionModel().getLeadSelectionIndex();
        int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n != -1 && n2 != -1 && this.isCellEditable(n, n2)) {
            return this.methodRequestsDummy;
        }
        return null;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        super.processInputMethodEvent(inputMethodEvent);
        this.usingInputMethod = true;
        Component component = this.getTextEditorComponent();
        if (component == null) {
            int n = this.getSelectionModel().getLeadSelectionIndex();
            int n2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n != -1 && n2 != -1 && !this.isEditing()) {
                if (!this.editCellAt(n, n2, inputMethodEvent)) {
                    this.usingInputMethod = false;
                    return;
                }
                component = this.getTextEditorComponent();
            }
        }
        if (component instanceof JComponent) {
            ((JComponent)component).dispatchEvent(inputMethodEvent);
            if (inputMethodEvent.getText() == null || inputMethodEvent.getText().last() == '\uffff') {
                this.usingInputMethod = false;
                component.requestFocus();
            }
        }
    }

    private Component getTextEditorComponent() {
        Component component = this.getEditorComponent();
        if (component instanceof JComboBox && ((JComboBox)component).isEditable()) {
            component = ((JComboBox)component).getEditor().getEditorComponent();
        } else if (component instanceof TextComponentContainer) {
            component = ((TextComponentContainer)((Object)component)).getTextComponent();
        }
        return component;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        Component component = this.getTextEditorComponent();
        if (component != null && this.usingInputMethod) {
            if (keyEvent.isShiftDown() || keyEvent.isAltDown() || keyEvent.isControlDown()) {
                return false;
            }
            if (keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 17) {
                return false;
            }
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.usingInputMethod = false;
    }
}

