/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.BatchAddSupport;
import com.ef_prime.rflow.core.common.keyvalue.BoolKey;
import com.ef_prime.rflow.core.common.keyvalue.ChoiceKey;
import com.ef_prime.rflow.core.common.keyvalue.FileKey;
import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.NonAtomicKey;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.TitleLink;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEvent;
import com.ef_prime.rflow.core.common.keyvalue.ValueChangeEventHandler;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEvent;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEventHandler;
import com.ef_prime.rflow.core.common.table.TableRow;
import com.ef_prime.rflow.core.feature.search.ListSearchResult;
import com.ef_prime.rflow.core.feature.search.TableTextSearchResult;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.base.UIColor;
import com.ef_prime.rflow.ui.common.component.ActionSupport;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.component.CodingTextArea;
import com.ef_prime.rflow.ui.common.component.CodingTextAreaContainer;
import com.ef_prime.rflow.ui.common.component.CodingTextField;
import com.ef_prime.rflow.ui.common.component.FlatSplitPane;
import com.ef_prime.rflow.ui.common.component.LabelArea;
import com.ef_prime.rflow.ui.common.component.LoggableAction;
import com.ef_prime.rflow.ui.common.component.SafeUndoManager;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.component.TableCodingTextAreaContainer;
import com.ef_prime.rflow.ui.common.component.TextComponentContainer;
import com.ef_prime.rflow.ui.common.keyvalue.BatchAddSupportUI;
import com.ef_prime.rflow.ui.common.keyvalue.ChoiceComboboxModel;
import com.ef_prime.rflow.ui.common.keyvalue.TableChoiceComboBox;
import com.ef_prime.rflow.ui.common.keyvalue.Widget;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetConstants;
import com.ef_prime.rflow.ui.common.table.EditingTable;
import com.ef_prime.rflow.ui.common.table.TableDataTransferable;
import com.ef_prime.rflow.ui.common.table.TableEdits;
import com.ef_prime.rflow.ui.common.table.UIGeneralTableModel;
import com.ef_prime.rflow.ui.util.FontSupport;
import com.ef_prime.rflow.ui.util.PlatformUtility;
import com.ef_prime.rflow.ui.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.LayerUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;

public class GeneralTable
extends JPanel
implements ListSelectionListener,
TableModelListener,
UndoableEditListener,
RowBasedTableModelEventHandler,
ValueChangeEventHandler,
HierarchyListener {
    private static final Logger LOGGER = Logger.getLogger(GeneralTable.class.getName());
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(2, 4, 2, 4);
    private static final Border SINGLE_FOCUS_BORDER = new CompoundBorder(new LineBorder(Color.BLACK, 2), new EmptyBorder(0, 2, 0, 2));
    private static final Border SINGLE_NO_FOCUS_BORDER = new CompoundBorder(new LineBorder(Color.BLACK, 1), new EmptyBorder(1, 3, 1, 3));
    private TableKey key;
    private KeysTableModel innerModel;
    protected UIGeneralTableModel model;
    protected JTable table;
    private JPanel tablePanel;
    private JLayer<Component> tableLayer;
    private JToolBar toolbar = new JToolBar(1);
    private SwitchPanel detailPanel;
    protected GeneralTableActions actions;
    protected ValueMap valueMap;
    protected Map<Integer, TableCellEditor> columnToEditor = new HashMap<Integer, TableCellEditor>();
    private UndoManager undoManager = new SafeUndoManager();
    private UndoableEditSupport undoableEditSupport = new TableUndoableEditSupport();
    private ConcurrentLinkedDeque<RowBasedTableModelEventHandler> internalTableModelHandlers = new ConcurrentLinkedDeque();
    private TableTextSearchResult searchResult;

    public GeneralTable(TableKey tableKey) {
        this.key = tableKey;
        this.table = this.createTable();
        this.table.setFont(new Font("Monospaced", 0, 12));
        this.table.setCellSelectionEnabled(true);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.table.setShowGrid(true);
        this.table.setGridColor(UIColor.TABLE_GRID);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().putClientProperty("substancelaf.highlight", Boolean.FALSE);
        Handlers handlers = new Handlers();
        UIUtility.insertMouseListener(this.table, handlers);
        this.table.addComponentListener(handlers);
        GeneralTableRenderer generalTableRenderer = new GeneralTableRenderer();
        this.table.setDefaultRenderer(String.class, generalTableRenderer);
        this.table.setDefaultRenderer(Integer.class, generalTableRenderer);
        this.table.setDefaultRenderer(Double.class, generalTableRenderer);
        this.table.setDefaultRenderer(Object.class, generalTableRenderer);
        UIUtility.setAutoResizeSupport(this.table);
        int n = this.table.getFontMetrics(this.table.getFont()).getHeight();
        this.table.setRowHeight((int)((double)n * 1.1));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.addMouseListener(new ScrollPaneMouseListener());
        this.tablePanel = new JPanel(new BorderLayout());
        this.tableLayer = new JLayer<Component>(jScrollPane, new TableLayerUI());
        this.tablePanel.add(this.tableLayer);
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.actions = this.createActions();
        this.actions.installActions(this.table, false, 1);
        this.table.getSelectionModel().addListSelectionListener(this.actions);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.actions);
        this.addUndoableEditListener(this.undoManager);
        this.addUndoableEditListener(this);
    }

    protected JTable createTable() {
        return new GeneralTableImpl();
    }

    protected GeneralTableActions createActions() {
        return new GeneralTableActions();
    }

    public void unload() {
        this.internalTableModelHandlers.clear();
        if (this.valueMap != null) {
            this.valueMap.removeEventHandler(this);
        }
        if (this.model != null) {
            this.model.unloadModel();
            this.model.removeRowBasedTableModelEventHandler(this);
            this.model.removeTableModelListener(this);
            this.model = null;
        }
        this.table.setRowSorter(null);
        this.innerModel = null;
    }

    public ValueMap getValueMap() {
        return this.valueMap;
    }

    public KeysTableModel getInnerModel() {
        return this.innerModel;
    }

    public UIGeneralTableModel getModel() {
        return this.model;
    }

    public TableKey getTableKey() {
        return this.key;
    }

    protected RowSorter<UIGeneralTableModel> createSorter(UIGeneralTableModel uIGeneralTableModel) {
        return null;
    }

    public void select(TableTextSearchResult tableTextSearchResult) {
        this.searchResult = tableTextSearchResult;
        this.table.editCellAt(tableTextSearchResult.getRow(), tableTextSearchResult.getColumn());
        Component component = this.table.getEditorComponent();
        component.addHierarchyListener(this);
        JComboBox jComboBox = null;
        if (component instanceof JComboBox) {
            jComboBox = (JComboBox)component;
        }
        if (component instanceof TextComponentContainer) {
            component = ((TextComponentContainer)((Object)component)).getTextComponent();
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).select(tableTextSearchResult.getOffset(), tableTextSearchResult.getOffset() + tableTextSearchResult.getLength());
            component.requestFocusInWindow();
            if (jComboBox != null) {
                JComboBox jComboBox2 = jComboBox;
                SwingUtilities.invokeLater(() -> jComboBox2.setPopupVisible(false));
            }
        }
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void select(ListSearchResult listSearchResult) {
        Component component;
        int[] nArray;
        if (!this.model.useLastColumnAsDetail() || this.detailPanel == null) {
            return;
        }
        int n = listSearchResult.getIndex();
        if (n < 0 || n >= this.model.getRowCount()) {
            return;
        }
        int[] nArray2 = this.table.getSelectedRows();
        if (nArray2.length != 1 || nArray2[0] != n) {
            this.table.setRowSelectionInterval(n, n);
        }
        if ((nArray = this.table.getSelectedColumns()).length != 1 || nArray[0] != 0) {
            this.table.setColumnSelectionInterval(0, 0);
        }
        if (!((component = this.detailPanel.get()) instanceof Widget)) {
            return;
        }
        ((Widget)component).select(listSearchResult.getResult());
    }

    public void clearDetailSelection() {
        if (this.detailPanel == null) {
            return;
        }
        Component component = this.detailPanel.get();
        if (!(component instanceof Widget)) {
            return;
        }
        ((Widget)component).clearSelection();
    }

    protected UIGeneralTableModel createUIGeneralTableModel(KeysTableModel keysTableModel) {
        return new UIGeneralTableModel(keysTableModel, this.getTableKey().isEditable());
    }

    public void setModel(KeysTableModel keysTableModel, ValueMap valueMap) {
        RowSorter<UIGeneralTableModel> rowSorter;
        this.unload();
        this.valueMap = valueMap;
        this.innerModel = keysTableModel;
        this.model = this.createUIGeneralTableModel(keysTableModel);
        this.model.addTableModelListener(this);
        this.model.addRowBasedTableModelEventHandler(this);
        this.table.setModel(this.model);
        if (!this.model.hideHeader()) {
            if (this.table.getTableHeader() == null) {
                this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()));
            }
        } else {
            this.table.setTableHeader(null);
        }
        this.columnToEditor.clear();
        this.tablePanel.remove(this.toolbar);
        this.toolbar.removeAll();
        this.configureToolBar(this.model, this.toolbar);
        this.removeAll();
        if (keysTableModel.useLastColumnAsDetail()) {
            if (this.detailPanel == null) {
                this.detailPanel = new SwitchPanel();
            }
            rowSorter = new FlatSplitPane(this.tablePanel, this.detailPanel);
            this.add((Component)((Object)rowSorter), "Center");
        } else {
            this.add((Component)this.tablePanel, "Center");
        }
        this.initColumns();
        if (this.getModel().rowHeightMayChange()) {
            this.refreshRowHeights();
        } else {
            rowSorter = new JTextField("dummy");
            ((JTextField)((Object)rowSorter)).setFont(this.table.getFont());
            this.table.setRowHeight(((JTextField)((Object)rowSorter)).getPreferredSize().height);
        }
        switch (keysTableModel.getSelectionMode()) {
            case 0: {
                this.table.setCellSelectionEnabled(true);
                this.table.getSelectionModel().setSelectionMode(2);
                break;
            }
            case 1: {
                this.table.setRowSelectionAllowed(true);
                this.table.setColumnSelectionAllowed(false);
                this.table.getSelectionModel().setSelectionMode(0);
                break;
            }
            case 2: {
                this.table.setRowSelectionAllowed(true);
                this.table.setColumnSelectionAllowed(false);
                this.table.getSelectionModel().setSelectionMode(2);
            }
        }
        switch (keysTableModel.getSelectionMode()) {
            case 1: 
            case 2: {
                rowSorter = (RowSorter<UIGeneralTableModel>)keysTableModel.getSelectedRows();
                if (ArrayUtils.isEmpty((int[])rowSorter)) break;
                this.table.clearSelection();
                for (Object object : rowSorter) {
                    object = this.table.convertRowIndexToView((int)object);
                    this.table.getSelectionModel().addSelectionInterval((int)object, (int)object);
                }
                break;
            }
        }
        rowSorter = this.createSorter(this.model);
        if (rowSorter != null) {
            this.table.setRowSorter(rowSorter);
        }
        this.revalidate();
        this.repaint();
        this.actions.updateState();
    }

    private void initColumns() {
        this.setupRenderers();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumnHandler tableColumnHandler = new TableColumnHandler();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Object object;
            int n = this.model.getFixedColumnWidth(i);
            if (n >= 0) {
                object = tableColumnModel.getColumn(i);
                ((TableColumn)object).setMaxWidth(n);
                ((TableColumn)object).setMinWidth(n);
                continue;
            }
            if (this.getModel().rowHeightMayChange(i)) {
                tableColumnModel.getColumn(i).addPropertyChangeListener(tableColumnHandler);
            }
            object = this.model.getColumnKey(i);
            if (this.valueMap.containsEventHandler(this) || !((Key)object).isKeyLink() && ((Key)object).getTitleLink() == null) continue;
            this.valueMap.addEventHandler(this);
        }
        if (this.valueMap.containsEventHandler(this)) {
            this.refreshKeyLinkState();
            this.refreshTitleLinkStates(null);
        }
    }

    protected void configureToolBar(UIGeneralTableModel uIGeneralTableModel, JToolBar jToolBar) {
        int[] nArray = uIGeneralTableModel.getUIControls();
        if (nArray == null) {
            return;
        }
        Key<?>[] keyArray = uIGeneralTableModel.getColumnKeys();
        boolean bl = false;
        if (keyArray.length > 0 && keyArray[0] instanceof FileKey) {
            bl = true;
            jToolBar.add(this.createControlButton(GeneralTableActions.ChooseFiles.class));
        }
        boolean bl2 = false;
        if (!bl) {
            for (Key<?> key : keyArray) {
                if (!(key instanceof ChoiceKey)) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            jToolBar.add(this.createControlButton("BATCH_ADD"));
        }
        block12: for (int n : nArray) {
            switch (n) {
                case 0: {
                    jToolBar.add(this.createControlButton("ADD"));
                    continue block12;
                }
                case 1: {
                    jToolBar.add(this.createControlButton("REMOVE_ROW"));
                    continue block12;
                }
                case 2: {
                    jToolBar.add(this.createControlButton("UP"));
                    continue block12;
                }
                case 3: {
                    jToolBar.add(this.createControlButton("DOWN"));
                    continue block12;
                }
                case 4: {
                    jToolBar.add(this.createControlButton("TOP"));
                    continue block12;
                }
                case 5: {
                    jToolBar.add(this.createControlButton("BOTTOM"));
                    continue block12;
                }
                case 7: {
                    jToolBar.add(this.createControlButton("SELECT_ALL"));
                    continue block12;
                }
                case 8: {
                    jToolBar.add(this.createControlButton("DESELECT_ALL"));
                    continue block12;
                }
                case 9: {
                    jToolBar.add(this.createControlButton("INVERT_SELECTION"));
                }
            }
        }
        this.tablePanel.add((Component)jToolBar, "West");
    }

    private JButton createControlButton(Object object) {
        Action action = this.actions.get(object);
        JButton jButton = new JButton(action);
        jButton.setHideActionText(true);
        jButton.setToolTipText((String)action.getValue("Name"));
        jButton.setFocusable(false);
        return jButton;
    }

    private void refreshKeyLinkState() {
        if (this.model.refreshFilter(this.valueMap, this.getTableKey())) {
            this.revalidate();
            this.repaint();
        }
    }

    private void refreshTitleLinkStates(String string) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        boolean bl = false;
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Key<?> key = this.model.getColumnKey(i);
            TitleLink titleLink = key.getTitleLink();
            if (titleLink == null || string != null && !titleLink.isLinked(string)) continue;
            String string2 = titleLink.getTitle(this.getValueMap());
            tableColumnModel.getColumn(i).setHeaderValue(string2);
            bl = true;
        }
        if (bl) {
            this.table.getTableHeader().repaint();
        }
    }

    public Object getValueAt(int n, int n2) {
        return this.table.getValueAt(n, n2);
    }

    public void setCellSelection(int n, int n2) {
        this.table.setRowSelectionInterval(this.table.convertColumnIndexToView(n), this.table.convertColumnIndexToView(n));
        this.table.setColumnSelectionInterval(n2, n2);
    }

    public void requestTableFocus() {
        this.table.requestFocusInWindow();
    }

    protected void setupRenderers() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer;
            Key<?> key = this.model.getColumnKey(i);
            if (key == null || (tableCellRenderer = this.getRenderer(key)) == null) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(tableCellRenderer);
        }
    }

    protected TableCellRenderer getRenderer(Key<?> key) {
        if (key instanceof ChoiceKey) {
            return new ChoiceCellRenderer(new TableChoiceComboBox(this, (ChoiceKey)key, this.valueMap, true));
        }
        if (key instanceof StrKey) {
            StrKey strKey = (StrKey)key;
            if (strKey.isMultiLine()) {
                return new CodingTextAreaRenderer(false, strKey.getDescriptionLink() != null);
            }
        } else if (key instanceof BoolKey) {
            return new BooleanRenderer();
        }
        return null;
    }

    public void stopEditing() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public void cancelEditing() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    protected Component createDetail(Object object) {
        return null;
    }

    protected void startDetailEditing() {
        Component component;
        if (this.model.useLastColumnAsDetail() && this.detailPanel != null && (component = this.detailPanel.get()) instanceof Widget) {
            ((Widget)component).startEditing();
        }
    }

    protected TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = this.columnToEditor.get(n2);
        if (tableCellEditor != null) {
            return tableCellEditor;
        }
        Key<?> key = this.model.getColumnKey(n2);
        if (key instanceof ChoiceKey) {
            tableCellEditor = new ChoiceCellEditor((ChoiceKey)key, this.createChoiceComboBox(n, n2));
        } else if (key instanceof StrKey && ((StrKey)key).isMultiLine()) {
            tableCellEditor = new CodingTextAreaCellEditor(false);
        } else if (key instanceof StrKey) {
            tableCellEditor = new StringCellEditor(new StringTextField());
        }
        if (tableCellEditor != null) {
            this.columnToEditor.put(n2, tableCellEditor);
        }
        return tableCellEditor;
    }

    protected TableChoiceComboBox createChoiceComboBox(int n, int n2) {
        TableChoiceComboBox tableChoiceComboBox = new TableChoiceComboBox(this, (ChoiceKey)this.model.getColumnKey(n2), this.valueMap, false);
        return tableChoiceComboBox;
    }

    protected void insert(ActionEvent actionEvent, int n) {
        if (n < 0) {
            n = this.model.getModelRowCount();
        }
        this.stopEditing();
        this.model.insertNewRow(n);
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.convertRowIndexToView(n), 0, true));
        this.selectCell(n, 0);
        this.startEdit(n, 0);
    }

    protected void editFinished() {
        int n = this.table.getEditingRow();
        int n2 = this.table.getEditingColumn();
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if (n >= 0 && n2 >= 0 && n < this.table.getRowCount() && n2 < this.table.getColumnCount()) {
            this.table.setRowSelectionInterval(n, n);
            this.table.setColumnSelectionInterval(n2, n2);
        }
    }

    protected static void configureRenderer(JComponent jComponent, JTable jTable, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            jComponent.setBackground(bl3 ? Color.WHITE : null);
            jComponent.setBorder(NO_FOCUS_BORDER);
        } else {
            boolean bl4;
            boolean bl5 = bl4 = (Boolean)jTable.getClientProperty("substancelaf.highlightCells") == false;
            if (bl4) {
                jComponent.setBackground(bl3 ? Color.WHITE : null);
                jComponent.setBorder(bl2 ? SINGLE_FOCUS_BORDER : SINGLE_NO_FOCUS_BORDER);
            } else {
                jComponent.setBackground(jTable.getSelectionBackground());
                jComponent.setBorder(NO_FOCUS_BORDER);
            }
        }
    }

    protected BatchAddSupport<?> getBatchAddSupport() {
        Key<?>[] keyArray;
        for (Key<?> key : keyArray = this.model.getColumnKeys()) {
            if (!(key instanceof ChoiceKey)) continue;
            return ((ChoiceKey)key).getBatchAddSupport();
        }
        return null;
    }

    protected void configurePopup(JPopupMenu jPopupMenu) {
        if (!this.getTableKey().isEditable()) {
            return;
        }
        jPopupMenu.add(this.actions.get("ADD"));
        jPopupMenu.add(this.actions.get("INSERT"));
        jPopupMenu.add(this.actions.get("REMOVE_ROW"));
        jPopupMenu.add(this.actions.get("MAKE_COPY"));
        JMenu jMenu = new JMenu(Messages.getString("Action.move"));
        jMenu.add(this.actions.get("TOP"));
        jMenu.add(this.actions.get("UP"));
        jMenu.add(this.actions.get("DOWN"));
        jMenu.add(this.actions.get("BOTTOM"));
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get("UNDO"));
        jPopupMenu.add(this.actions.get("REDO"));
        UIUtility.cleanUpPopupMenu(jPopupMenu);
    }

    public void refreshRowHeights() {
        if (!this.getModel().rowHeightMayChange()) {
            return;
        }
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            this.refreshRowHeight(i);
        }
    }

    public void refreshRowHeight(int n) {
        if (!this.getModel().rowHeightMayChange()) {
            return;
        }
        int n2 = 0;
        boolean bl = n == this.table.getEditingRow();
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            Object object;
            int n3 = 0;
            if (bl && i == this.table.getEditingColumn() && (object = this.table.getEditorComponent()) != null) {
                n3 = ((Component)object).getPreferredSize().height;
            }
            if (n3 == 0) {
                object = this.table.getCellRenderer(n, i);
                Component component = this.table.prepareRenderer((TableCellRenderer)object, n, i);
                n3 = component.getPreferredSize().height;
            }
            if (n2 >= ++n3) continue;
            n2 = n3;
        }
        this.table.setRowHeight(n, n2);
    }

    public void refreshEditingRowHeight() {
        int n = this.table.getEditingRow();
        if (n >= 0) {
            this.refreshRowHeight(n);
        }
    }

    public void addRowSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeRowSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public int[] getModelSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return nArray;
        }
        return Arrays.stream(nArray).map(n -> this.table.convertRowIndexToModel(n)).toArray();
    }

    protected Color darker(Color color) {
        float f = 0.8f;
        return new Color(Math.max((int)((float)color.getRed() * f), 0), Math.max((int)((float)color.getGreen() * f), 0), Math.max((int)((float)color.getBlue() * f), 0));
    }

    protected void selectCell(int n, int n2) {
        if (n < 0 || n >= this.table.getRowCount() || n2 < 0 || n2 >= this.table.getColumnCount()) {
            return;
        }
        this.table.setRowSelectionInterval(this.table.convertRowIndexToView(n), this.table.convertRowIndexToView(n));
        this.table.setColumnSelectionInterval(n2, n2);
    }

    protected void startEdit(int n, int n2) {
        this.table.editCellAt(this.table.convertRowIndexToView(n), n2);
        final Component component = this.table.getEditorComponent();
        if (component != null) {
            if (component instanceof JComboBox) {
                FocusListener focusListener = new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        ((Component)focusEvent.getSource()).removeFocusListener(this);
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JComboBox)component).showPopup();
                            }
                        });
                    }
                };
                if (((JComboBox)component).isEditable()) {
                    ((JComboBox)component).getEditor().getEditorComponent().addFocusListener(focusListener);
                } else {
                    component.addFocusListener(focusListener);
                }
            }
            component.requestFocusInWindow();
        }
    }

    public void next(boolean bl) {
        if (!this.table.isEditing()) {
            return;
        }
        int n = this.table.getEditingRow();
        int n2 = this.table.getEditingColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        this.table.getCellEditor().stopCellEditing();
        int n3 = n;
        int n4 = n2;
        if (bl) {
            if (n2 == this.model.getColumnCount() - 1) {
                ++n3;
                n4 = 0;
            } else {
                ++n4;
            }
            if (n3 >= this.model.getRowCount()) {
                n3 = 0;
            }
        } else {
            if (n2 == 0) {
                --n3;
                n4 = this.model.getColumnCount() - 1;
            } else {
                --n4;
            }
            if (n3 < 0) {
                n3 = this.model.getRowCount() - 1;
            }
        }
        this.selectCell(n3, n4);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.model != null && this.model.useLastColumnAsDetail() && this.detailPanel != null) {
            int n;
            Component component = null;
            int[] nArray = this.getModelSelectedRows();
            if (!ArrayUtils.isEmpty((int[])nArray) && !this.model.isRowOutOfModelArea(n = nArray[0])) {
                int n2 = this.model.getColumnCount() - 1;
                component = this.createDetail(this.model.getValueAt(n, n2));
            }
            this.detailPanel.set(component);
        }
        if (this.model != null && !listSelectionEvent.getValueIsAdjusting()) {
            this.model.setSelectedRows(this.getModelSelectedRows());
        }
        boolean bl = this.table.getSelectedRowCount() == 1 && this.table.getSelectedColumnCount() == 1 && this.table.getCellSelectionEnabled();
        this.table.putClientProperty("substancelaf.highlightCells", !bl);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        switch (tableModelEvent.getType()) {
            case 1: {
                this.table.clearSelection();
                this.tableLayer.repaint();
                break;
            }
            case -1: {
                this.tableLayer.repaint();
                break;
            }
            case 0: {
                if (tableModelEvent.getFirstRow() != -1 || tableModelEvent.getColumn() != -1) break;
                this.initColumns();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.table.repaint();
    }

    @Override
    public void rowBasedTableChanged(RowBasedTableModelEvent rowBasedTableModelEvent) {
        for (RowBasedTableModelEventHandler tableRowArray : this.internalTableModelHandlers) {
            tableRowArray.rowBasedTableChanged(rowBasedTableModelEvent);
        }
        switch (rowBasedTableModelEvent.getType()) {
            case 2: {
                this.refreshRowHeight(rowBasedTableModelEvent.getUpdatedRow());
                this.undoableEditSupport.postEdit(new TableEdits.CellUpdateEdit(this.table, rowBasedTableModelEvent.getModel(), rowBasedTableModelEvent.getUpdatedRow(), rowBasedTableModelEvent.getUpdatedColumn(), rowBasedTableModelEvent.getOldValue(), rowBasedTableModelEvent.getNewValue()));
                break;
            }
            case 0: {
                Object object = rowBasedTableModelEvent.getRows();
                TableRow[] tableRowArray = new TableRow[((Object)object).length];
                for (int i = 0; i < tableRowArray.length; ++i) {
                    tableRowArray[i] = rowBasedTableModelEvent.getModel().getRow((int)object[i]);
                    this.refreshRowHeight((int)object[i]);
                }
                this.undoableEditSupport.postEdit(new TableEdits.InsertRowsEdit(this.table, rowBasedTableModelEvent.getModel(), (int[])object, tableRowArray));
                break;
            }
            case 1: {
                this.undoableEditSupport.postEdit(new TableEdits.RemoveRowsEdit(this.table, rowBasedTableModelEvent.getModel(), rowBasedTableModelEvent.getRows(), rowBasedTableModelEvent.getDeleted()));
                break;
            }
            case 3: {
                this.refreshRowHeight(rowBasedTableModelEvent.getRows()[0]);
                this.refreshRowHeight(rowBasedTableModelEvent.getRows()[1]);
                this.undoableEditSupport.postEdit(new TableEdits.MoveRowEdit(this.table, rowBasedTableModelEvent.getModel(), rowBasedTableModelEvent.getRows()[0], rowBasedTableModelEvent.getRows()[1]));
            }
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        UIUtility.invokeLater(() -> {
            this.refreshKeyLinkState();
            this.refreshTitleLinkStates(valueChangeEvent.getKey().getId());
        });
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 2L) == 0L) {
            return;
        }
        Component component = hierarchyEvent.getComponent();
        if (component == null) {
            return;
        }
        if (!component.isDisplayable()) {
            this.searchResult = null;
            component.removeHierarchyListener(this);
        }
    }

    private class TableUndoableEditSupport
    extends UndoableEditSupport {
        private TableUndoableEditSupport() {
        }

        @Override
        public synchronized void beginUpdate() {
            super.beginUpdate();
            this.compoundEdit.addEdit(new TableEdits.SelectionEdit(GeneralTable.this.table, GeneralTable.this.table.getSelectedRows(), GeneralTable.this.table.getSelectedColumns(), true));
        }

        @Override
        public synchronized void endUpdate() {
            this.compoundEdit.addEdit(new TableEdits.SelectionEdit(GeneralTable.this.table, GeneralTable.this.table.getSelectedRows(), GeneralTable.this.table.getSelectedColumns(), false));
            super.endUpdate();
        }
    }

    private class Handlers
    extends MouseAdapter
    implements ComponentListener {
        private Handlers() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = GeneralTable.this.table.rowAtPoint(mouseEvent.getPoint());
            int n2 = GeneralTable.this.table.columnAtPoint(mouseEvent.getPoint());
            if (n2 < 0 || n < 0) {
                return;
            }
            Key<?> key = GeneralTable.this.model.getColumnKey(n2);
            if (!(key instanceof BoolKey)) {
                return;
            }
            if (!GeneralTable.this.model.isCellEditable(GeneralTable.this.table.convertRowIndexToModel(n), n2)) {
                return;
            }
            int[] nArray = GeneralTable.this.table.getSelectedRows();
            if (nArray.length <= 1 || Arrays.binarySearch(nArray, n) < 0) {
                return;
            }
            boolean bl = (Boolean)GeneralTable.this.model.getValueAt(GeneralTable.this.table.convertRowIndexToModel(n), n2) == false;
            for (int n3 : nArray) {
                if (!GeneralTable.this.model.isCellEditable(n3 = GeneralTable.this.table.convertRowIndexToModel(n3), n2)) continue;
                GeneralTable.this.model.setValueAt(bl, n3, n2);
            }
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            if (!UIUtility.isRightMouseButton(mouseEvent)) {
                return;
            }
            int n2 = GeneralTable.this.table.rowAtPoint(mouseEvent.getPoint());
            if (!GeneralTable.this.table.isCellSelected(n2, n = GeneralTable.this.table.columnAtPoint(mouseEvent.getPoint()))) {
                GeneralTable.this.table.setRowSelectionInterval(n2, n2);
                GeneralTable.this.table.setColumnSelectionInterval(n, n);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            GeneralTable.this.configurePopup(jPopupMenu);
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (GeneralTable.this.table.getWidth() > 0) {
                GeneralTable.this.refreshRowHeights();
                GeneralTable.this.table.removeComponentListener(this);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    protected class GeneralTableRenderer
    extends DefaultTableCellRenderer {
        private String emptyMessage;

        protected GeneralTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(null);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Class<?> clazz = GeneralTable.this.model.getColumnClass(n2);
            if (Number.class.isAssignableFrom(clazz)) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            String string = GeneralTable.this.model.valueToString(object, n, n2);
            this.setText(string);
            this.emptyMessage = null;
            Key<?> key = GeneralTable.this.model.getColumnKey(n2);
            if (string.isEmpty()) {
                Object object2;
                if (key.isDynamicDefault()) {
                    object2 = GeneralTable.this.getValueMap().getDynamicDefaultValue(GeneralTable.this.getInnerModel(), n, key);
                    if (object2 instanceof String) {
                        this.emptyMessage = "(" + (String)object2 + ")";
                    }
                } else if (key instanceof StrKey && ((StrKey)(object2 = (StrKey)key)).isEmptyMessage()) {
                    this.emptyMessage = "(" + ((StrKey)object2).getEmptyMessage(GeneralTable.this.getValueMap()) + ")";
                }
            }
            if (!bl) {
                this.setForeground(Color.BLACK);
            }
            boolean bl3 = jTable.isCellEditable(n, n2);
            GeneralTable.configureRenderer(this, jTable, bl, bl2, bl3);
            if (!bl && !bl3) {
                SubstanceStripingUtils.applyStripedBackground((JComponent)jTable, (int)n, (JComponent)this);
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.paintEmptyMessage(graphics);
        }

        private void paintEmptyMessage(Graphics graphics) {
            String string = this.getText();
            if (string.length() > 0 || StringUtils.isEmpty((CharSequence)this.emptyMessage)) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Insets insets = this.getInsets();
            Color color = graphics.getColor();
            graphics.setColor(WidgetConstants.AUTO_FONT_COLOR);
            UIUtility.drawString(graphics, this.emptyMessage, insets.left, insets.top + fontMetrics.getHeight() - fontMetrics.getDescent());
            graphics.setColor(color);
        }
    }

    private class ScrollPaneMouseListener
    extends MouseAdapter {
        private ScrollPaneMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!UIUtility.isRightMouseButton(mouseEvent)) {
                return;
            }
            GeneralTable.this.table.clearSelection();
            JPopupMenu jPopupMenu = new JPopupMenu();
            GeneralTable.this.configurePopup(jPopupMenu);
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
    }

    private class TableLayerUI
    extends LayerUI<Component> {
        private CellRendererPane cellRendererPane;
        private LabelArea label;

        private TableLayerUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            if (GeneralTable.this.model.getModelRowCount() == 0 && GeneralTable.this.model.getEmptyMessage() != null) {
                JLayer jLayer = (JLayer)jComponent;
                if (this.label == null) {
                    this.cellRendererPane = new CellRendererPane();
                    ((Container)jLayer.getView()).add(this.cellRendererPane);
                    this.label = new LabelArea(GeneralTable.this.model.getEmptyMessage());
                    this.label.setLineWrap(false);
                    FontSupport.setFont(this.label, Settings.BASIC_FONT_SIZE);
                    this.label.setForeground(Color.GRAY);
                    this.label.setDisabledTextColor(this.label.getForeground());
                }
                Dimension dimension = this.label.getPreferredSize();
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.cellRendererPane.paintComponent(graphics2D, this.label, (Container)jLayer.getView(), jComponent.getWidth() / 2 - dimension.width / 2, jComponent.getHeight() / 2 - dimension.height / 2, dimension.width, dimension.height, true);
                graphics2D.dispose();
            }
        }
    }

    protected class GeneralTableActions
    extends Actions
    implements ListSelectionListener {
        private static final String PROCEED = "PROCEED";
        private static final String ADD = "ADD";
        private static final String INSERT = "INSERT";
        private static final String CLEAR = "CLEAR";
        private static final String REMOVE_ROW = "REMOVE_ROW";
        private static final String UP = "UP";
        private static final String DOWN = "DOWN";
        private static final String TOP = "TOP";
        private static final String BOTTOM = "BOTTOM";
        private static final String COPY = "COPY";
        private static final String CUT = "CUT";
        private static final String PASTE = "PASTE";
        private static final String MAKE_COPY = "MAKE_COPY";
        private static final String UNDO = "UNDO";
        private static final String REDO = "REDO";
        private static final String BATCH_ADD = "BATCH_ADD";
        private static final String SELECT_ALL = "SELECT_ALL";
        private static final String DESELECT_ALL = "DESELECT_ALL";
        private static final String INVERT_SELECTION = "INVERT_SELECTION";

        public GeneralTableActions() {
            this.put(PROCEED, new Proceed());
            this.put(ADD, new Add());
            this.put(INSERT, new Insert());
            this.put(CLEAR, new Clear());
            this.put(REMOVE_ROW, new RemoveRow());
            this.put(UP, new Up());
            this.put(DOWN, new Down());
            this.put(TOP, new Top());
            this.put(BOTTOM, new Bottom());
            this.put(COPY, new Copy());
            this.put(CUT, new Cut());
            this.put(PASTE, new Paste());
            this.put(MAKE_COPY, new MakeCopy());
            this.put(UNDO, new Undo());
            this.put(REDO, new Redo());
            this.put(BATCH_ADD, new BatchAdd());
            this.put(SELECT_ALL, new SelectAll());
            this.put(DESELECT_ALL, new DeselectAll());
            this.put(INVERT_SELECTION, new InvertSelection());
            this.put(new ChooseFiles());
        }

        private String getValueForCopyAt(int n, int n2) {
            Object object = GeneralTable.this.table.getValueAt(n, n2);
            if (object == null) {
                return "";
            }
            return object.toString();
        }

        private void selectAll(boolean bl) {
            GeneralTable.this.model.beginValueChange();
            try {
                for (int i = 0; i < GeneralTable.this.model.getRowCount(); ++i) {
                    GeneralTable.this.model.setValueAt(bl, i, 0);
                }
            }
            finally {
                GeneralTable.this.model.endValueChange();
            }
        }

        protected void updateState() {
            boolean bl = GeneralTable.this.table.getSelectionModel().isSelectionEmpty();
            boolean bl2 = GeneralTable.this.table.getColumnModel().getSelectionModel().isSelectionEmpty();
            boolean bl3 = bl && bl2;
            this.get(INSERT).setEnabled(!bl);
            this.get(REMOVE_ROW).setEnabled(!bl);
            this.get(TOP).setEnabled(!bl);
            this.get(BOTTOM).setEnabled(!bl);
            this.get(UP).setEnabled(!bl);
            this.get(DOWN).setEnabled(!bl);
            this.get(MAKE_COPY).setEnabled(!bl);
            this.get(CLEAR).setEnabled(!bl3);
            this.get(COPY).setEnabled(!bl3);
            this.get(CUT).setEnabled(!bl3);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateState();
        }

        private class Proceed
        extends AbstractAction {
            public Proceed() {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GeneralTable.this.table.convertRowIndexToModel(GeneralTable.this.table.getSelectedRow());
                int n2 = GeneralTable.this.table.getSelectedColumn();
                if (n < 0 || n2 < 0 || GeneralTable.this.table.getSelectedRowCount() > 1 || GeneralTable.this.table.getSelectedColumnCount() > 1) {
                    return;
                }
                int n3 = n;
                int n4 = n2;
                if (n2 == GeneralTable.this.model.getColumnCount() - 1) {
                    ++n3;
                    n4 = 0;
                } else {
                    ++n4;
                }
                GeneralTable.this.selectCell(n3, n4);
            }
        }

        private class Add
        extends AbstractAction {
            public Add() {
                this.putValue("Name", Messages.getString("Action.add"));
                this.putValue("SmallIcon", Icons.getIcon("16/add.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.insert(actionEvent, GeneralTable.this.model.getModelRowCount());
            }
        }

        private class Insert
        extends AbstractAction {
            public Insert() {
                this.putValue("Name", Messages.getString("Action.insert"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GeneralTable.this.table.convertRowIndexToModel(GeneralTable.this.table.getSelectedRow());
                if (n < 0) {
                    n = GeneralTable.this.model.getModelRowCount();
                }
                GeneralTable.this.insert(actionEvent, n);
            }
        }

        private class Clear
        extends AbstractAction {
            public Clear() {
                this.putValue("Name", Messages.getString("Action.clear"));
                this.putValue("AcceleratorKey", PlatformUtility.getDeleteKeyStroke());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = GeneralTable.this.table.getSelectedRows();
                int[] nArray2 = GeneralTable.this.table.getSelectedColumns();
                if (ArrayUtils.isEmpty((int[])nArray) || ArrayUtils.isEmpty((int[])nArray2)) {
                    return;
                }
                if (nArray2.length == GeneralTable.this.table.getColumnCount()) {
                    GeneralTableActions.this.get(GeneralTableActions.REMOVE_ROW).actionPerformed(actionEvent);
                    return;
                }
                GeneralTable.this.cancelEditing();
                GeneralTable.this.model.beginValueChange();
                GeneralTable.this.undoableEditSupport.beginUpdate();
                try {
                    for (int i = 0; i < nArray.length; ++i) {
                        for (int j = 0; j < nArray2.length; ++j) {
                            GeneralTable.this.model.setValueAt(null, GeneralTable.this.table.convertRowIndexToModel(nArray[i]), nArray2[j]);
                        }
                    }
                }
                finally {
                    GeneralTable.this.model.endValueChange();
                    GeneralTable.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class RemoveRow
        extends AbstractAction {
            public RemoveRow() {
                this.putValue("Name", Messages.getString("Action.delete"));
                this.putValue("SmallIcon", Icons.getIcon("16/delete.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                int[] nArray = GeneralTable.this.getModelSelectedRows();
                if (nArray.length <= 0) {
                    return;
                }
                int n = GeneralTable.this.table.getSelectionModel().getMinSelectionIndex();
                GeneralTable.this.model.removeRows(nArray);
                if (n >= GeneralTable.this.model.getModelRowCount()) {
                    n = GeneralTable.this.model.getModelRowCount() - 1;
                }
                GeneralTable.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        }

        private class Up
        extends AbstractAction {
            public Up() {
                this.putValue("Name", Messages.getString("Action.up"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_up.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                int[] nArray = GeneralTable.this.table.getSelectedRows();
                if (nArray.length <= 0 || nArray[0] == 0) {
                    return;
                }
                GeneralTable.this.table.addColumnSelectionInterval(0, GeneralTable.this.table.getColumnCount() - 1);
                GeneralTable.this.undoableEditSupport.beginUpdate();
                GeneralTable.this.table.getSelectionModel().clearSelection();
                try {
                    for (int i = 0; i < nArray.length; ++i) {
                        GeneralTable.this.model.moveRow(nArray[i], nArray[i] - 1);
                        GeneralTable.this.table.addRowSelectionInterval(nArray[i] - 1, nArray[i] - 1);
                    }
                    GeneralTable.this.table.scrollRectToVisible(GeneralTable.this.table.getCellRect(nArray[0] - 1, 0, true));
                }
                finally {
                    GeneralTable.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class Down
        extends AbstractAction {
            public Down() {
                this.putValue("Name", Messages.getString("Action.down"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_down.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                int[] nArray = GeneralTable.this.table.getSelectedRows();
                if (nArray.length <= 0 || nArray[nArray.length - 1] == GeneralTable.this.model.getModelRowCount() - 1) {
                    return;
                }
                GeneralTable.this.table.addColumnSelectionInterval(0, GeneralTable.this.table.getColumnCount() - 1);
                GeneralTable.this.undoableEditSupport.beginUpdate();
                GeneralTable.this.table.getSelectionModel().clearSelection();
                try {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        GeneralTable.this.model.moveRow(nArray[i], nArray[i] + 1);
                        GeneralTable.this.table.addRowSelectionInterval(nArray[i] + 1, nArray[i] + 1);
                    }
                    GeneralTable.this.table.scrollRectToVisible(GeneralTable.this.table.getCellRect(nArray[nArray.length - 1] + 1, 0, true));
                }
                finally {
                    GeneralTable.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class Top
        extends AbstractAction {
            public Top() {
                this.putValue("Name", Messages.getString("Action.top"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_top.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                int[] nArray = GeneralTable.this.table.getSelectedRows();
                if (nArray.length <= 0) {
                    return;
                }
                GeneralTable.this.table.addColumnSelectionInterval(0, GeneralTable.this.table.getColumnCount() - 1);
                GeneralTable.this.undoableEditSupport.beginUpdate();
                GeneralTable.this.table.getSelectionModel().clearSelection();
                try {
                    for (int i = 0; i < nArray.length; ++i) {
                        GeneralTable.this.model.moveRow(nArray[i], i);
                    }
                    GeneralTable.this.table.addRowSelectionInterval(0, nArray.length - 1);
                    GeneralTable.this.table.scrollRectToVisible(GeneralTable.this.table.getCellRect(0, 0, true));
                }
                finally {
                    GeneralTable.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class Bottom
        extends AbstractAction {
            public Bottom() {
                this.putValue("Name", Messages.getString("Action.bottom"));
                this.putValue("SmallIcon", Icons.getIcon("16/bullet_arrow_bottom.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                int[] nArray = GeneralTable.this.table.getSelectedRows();
                if (nArray.length <= 0) {
                    return;
                }
                GeneralTable.this.table.addColumnSelectionInterval(0, GeneralTable.this.table.getColumnCount() - 1);
                GeneralTable.this.undoableEditSupport.beginUpdate();
                GeneralTable.this.table.getSelectionModel().clearSelection();
                int n = GeneralTable.this.model.getModelRowCount();
                int n2 = n - 1;
                try {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        GeneralTable.this.model.moveRow(nArray[i], n2--);
                    }
                    GeneralTable.this.table.addRowSelectionInterval(n - nArray.length, n - 1);
                    GeneralTable.this.table.scrollRectToVisible(GeneralTable.this.table.getCellRect(GeneralTable.this.table.getRowCount() - 1, 0, true));
                }
                finally {
                    GeneralTable.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class Copy
        extends AbstractAction {
            public Copy() {
                this.putValue("Name", Messages.getString("Action.copy"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                boolean bl = false;
                int[] nArray = GeneralTable.this.table.getSelectedColumns();
                int[] nArray2 = GeneralTable.this.getModelSelectedRows();
                nArray2 = GeneralTable.this.model.getValidRows(nArray2);
                if (!GeneralTable.this.table.getRowSelectionAllowed()) {
                    nArray2 = new int[]{};
                }
                if (!GeneralTable.this.table.getColumnSelectionAllowed()) {
                    nArray = new int[]{};
                }
                if (nArray.length == 0 && nArray2.length == 0) {
                    return;
                }
                int n = GeneralTable.this.table.getRowSelectionAllowed() ? nArray2.length + 1 : GeneralTable.this.table.getRowCount() + 1;
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>(n);
                if (nArray.length > 0 && nArray2.length == 0) {
                    if (bl) {
                        ArrayList<String> arrayList2 = new ArrayList<String>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList2.add(GeneralTable.this.table.getColumnName(nArray[i]));
                        }
                        arrayList.add(arrayList2);
                    }
                    for (var7_8 = 0; var7_8 < GeneralTable.this.table.getRowCount(); ++var7_8) {
                        ArrayList<String> arrayList3 = new ArrayList<String>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList3.add(GeneralTableActions.this.getValueForCopyAt(var7_8, nArray[i]));
                        }
                        arrayList.add(arrayList3);
                    }
                } else if (nArray.length == 0 && nArray2.length > 0) {
                    if (bl) {
                        ArrayList<String> arrayList4 = new ArrayList<String>(GeneralTable.this.table.getColumnCount());
                        for (int i = 0; i < GeneralTable.this.table.getColumnCount(); ++i) {
                            arrayList4.add(GeneralTable.this.table.getColumnName(i));
                        }
                        arrayList.add(arrayList4);
                    }
                    for (var7_8 = 0; var7_8 < nArray2.length; ++var7_8) {
                        ArrayList<String> arrayList5 = new ArrayList<String>(GeneralTable.this.table.getColumnCount());
                        for (int i = 0; i < GeneralTable.this.table.getColumnCount(); ++i) {
                            arrayList5.add(GeneralTableActions.this.getValueForCopyAt(nArray2[var7_8], i));
                        }
                        arrayList.add(arrayList5);
                    }
                } else if (nArray.length > 0 && nArray2.length > 0) {
                    if (bl) {
                        ArrayList<String> arrayList6 = new ArrayList<String>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList6.add(GeneralTable.this.table.getColumnName(nArray[i]));
                        }
                        arrayList.add(arrayList6);
                    }
                    for (var7_8 = 0; var7_8 < nArray2.length; ++var7_8) {
                        ArrayList<String> arrayList7 = new ArrayList<String>(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            arrayList7.add(GeneralTableActions.this.getValueForCopyAt(nArray2[var7_8], nArray[i]));
                        }
                        arrayList.add(arrayList7);
                    }
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new TableDataTransferable(arrayList), null);
            }
        }

        private class Cut
        extends AbstractAction {
            public Cut() {
                this.putValue("Name", Messages.getString("Action.cut"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTableActions.this.get(GeneralTableActions.COPY).actionPerformed(actionEvent);
                GeneralTableActions.this.get(GeneralTableActions.CLEAR).actionPerformed(actionEvent);
            }
        }

        private class Paste
        extends AbstractAction {
            public Paste() {
                this.putValue("Name", Messages.getString("Action.paste"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, UIUtility.MENU_KEY_MASK));
            }

            private Object getPasteValue(int n, String string) {
                Object object;
                Key<?> key = GeneralTable.this.model.getColumnKey(n);
                if (key instanceof NonAtomicKey) {
                    return null;
                }
                if (key instanceof ChoiceKey && (object = ((ChoiceKey)key).getValue(string)) != null) {
                    return object;
                }
                object = key.stringToValue(string);
                return object;
            }

            private boolean isAcceptable(int n, String string) {
                Key<?> key = GeneralTable.this.model.getColumnKey(n);
                if (key instanceof ChoiceKey) {
                    ChoiceKey choiceKey = (ChoiceKey)key;
                    return choiceKey.isAcceptable(string);
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                String[] stringArray;
                int n4;
                String string;
                GeneralTable.this.stopEditing();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    return;
                }
                try {
                    string = (String)clipboard.getData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                    return;
                }
                int[] nArray = GeneralTable.this.table.getSelectedRows();
                int[] nArray2 = GeneralTable.this.table.getSelectedColumns();
                int n5 = ArrayUtils.isEmpty((int[])nArray) ? 0 : nArray[0];
                int n6 = ArrayUtils.isEmpty((int[])nArray) ? 0 : nArray[nArray.length - 1];
                int n7 = ArrayUtils.isEmpty((int[])nArray2) ? 0 : nArray2[0];
                int n8 = ArrayUtils.isEmpty((int[])nArray2) ? 0 : nArray2[nArray2.length - 1];
                boolean bl = n5 == n6 && n7 == n8;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                int n9 = 0;
                try (LineIterator lineIterator = IOUtils.lineIterator((Reader)new StringReader(string));){
                    while (lineIterator.hasNext()) {
                        String string2 = lineIterator.nextLine();
                        String[] stringArray2 = string2.split("\t");
                        arrayList.add(stringArray2);
                        n9 = Math.max(stringArray2.length, n9);
                    }
                }
                boolean bl2 = true;
                int n10 = 0;
                int n11 = 3;
                StringBuilder stringBuilder = new StringBuilder();
                for (n4 = 0; n10 <= n11 && n4 < arrayList.size(); ++n4) {
                    stringArray = (String[])arrayList.get(n4);
                    for (n3 = 0; n3 < stringArray.length && (n2 = n7 + n3) < GeneralTable.this.model.getColumnCount(); ++n3) {
                        n = this.isAcceptable(n2, stringArray[n3]);
                        boolean bl3 = bl2 = bl2 && n != 0;
                        if (n != 0) continue;
                        if (++n10 <= n11) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(stringArray[n3]);
                            continue;
                        }
                        if (n10 != n11 + 1) continue;
                        stringBuilder.append(", ...");
                    }
                }
                if (!bl2) {
                    UIUtility.showErrorDialog((Component)GeneralTable.this, Messages.getString("GeneralTable.pasteIsNotAcceptable") + "\n" + stringBuilder.toString());
                    return;
                }
                GeneralTable.this.model.beginValueChange();
                GeneralTable.this.undoableEditSupport.beginUpdate();
                try {
                    if (bl) {
                        for (n4 = 0; n4 < arrayList.size(); ++n4) {
                            stringArray = (String[])arrayList.get(n4);
                            for (n3 = 0; n3 < stringArray.length && (n2 = n7 + n3) < GeneralTable.this.model.getColumnCount(); ++n3) {
                                Object object = this.getPasteValue(n2, stringArray[n3]);
                                if (object == null) continue;
                                GeneralTable.this.table.setValueAt(object, n5 + n4, n2);
                            }
                        }
                    } else {
                        n4 = n5;
                        int n12 = 0;
                        while (n4 <= n6) {
                            if (n12 >= arrayList.size()) {
                                n12 = 0;
                            }
                            String[] stringArray3 = (String[])arrayList.get(n12);
                            n2 = n7;
                            n = 0;
                            while (n2 <= n8) {
                                Object object;
                                if (n >= n9) {
                                    n = 0;
                                }
                                if (n < stringArray3.length && (object = this.getPasteValue(n2, stringArray3[n])) != null) {
                                    GeneralTable.this.table.setValueAt(object, n4, n2);
                                }
                                ++n2;
                                ++n;
                            }
                            ++n4;
                            ++n12;
                        }
                    }
                }
                finally {
                    GeneralTable.this.model.endValueChange();
                    GeneralTable.this.undoableEditSupport.endUpdate();
                }
            }
        }

        private class MakeCopy
        extends AbstractAction {
            public MakeCopy() {
                this.putValue("Name", Messages.getString("Action.replicate"));
                this.putValue("SmallIcon", Icons.getIcon("16/page_white_copy.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralTable.this.stopEditing();
                int[] nArray = GeneralTable.this.getModelSelectedRows();
                if (nArray.length <= 0) {
                    return;
                }
                GeneralTable.this.model.makeCopies(nArray);
            }
        }

        private class Undo
        extends AbstractAction {
            public Undo() {
                this.putValue("Name", Messages.getString("Action.undo"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GeneralTable.this.undoManager.canUndo()) {
                    GeneralTable.this.getModel().beginValueChange();
                    try {
                        GeneralTable.this.undoManager.undo();
                    }
                    finally {
                        GeneralTable.this.getModel().endValueChange();
                    }
                }
            }
        }

        private class Redo
        extends AbstractAction {
            public Redo() {
                this.putValue("Name", Messages.getString("Action.redo"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, UIUtility.MENU_KEY_MASK));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GeneralTable.this.undoManager.canRedo()) {
                    GeneralTable.this.getModel().beginValueChange();
                    try {
                        GeneralTable.this.undoManager.redo();
                    }
                    finally {
                        GeneralTable.this.getModel().endValueChange();
                    }
                }
            }
        }

        private class BatchAdd
        extends AbstractAction {
            public BatchAdd() {
                this.putValue("Name", Messages.getStringWithDots("Action.bulk_add"));
                this.putValue("SmallIcon", Icons.getIcon("16/magic_wand_2.png"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BatchAddSupport<?> batchAddSupport = GeneralTable.this.getBatchAddSupport();
                if (batchAddSupport == null) {
                    return;
                }
                BatchAddSupportUI.show(GeneralTable.this, GeneralTable.this.key, GeneralTable.this.valueMap, batchAddSupport);
            }
        }

        private class SelectAll
        extends LoggableAction {
            public SelectAll() {
                this.putValue("Name", Messages.getString("Action.select_all"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/tick.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                GeneralTableActions.this.selectAll(true);
            }
        }

        private class DeselectAll
        extends LoggableAction {
            public DeselectAll() {
                this.putValue("Name", Messages.getString("Action.deselect_all"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/cross.png"));
            }

            @Override
            public void action(ActionEvent actionEvent) {
                GeneralTableActions.this.selectAll(false);
            }
        }

        private class InvertSelection
        extends LoggableAction {
            public InvertSelection() {
                this.putValue("Name", Messages.getString("Action.invert_all"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/select_invert.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                GeneralTable.this.model.beginValueChange();
                try {
                    for (int i = 0; i < GeneralTable.this.model.getRowCount(); ++i) {
                        Boolean bl = (Boolean)GeneralTable.this.model.getValueAt(i, 0);
                        GeneralTable.this.model.setValueAt(bl == false, i, 0);
                    }
                }
                finally {
                    GeneralTable.this.model.endValueChange();
                }
            }
        }

        private class ChooseFiles
        extends LoggableAction {
            public ChooseFiles() {
                this.putValue("Name", Messages.getStringWithDots("Action.choose_files"));
                this.putValue("SwingLargeIconKey", Icons.getIcon("16/folder_add.png"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(ActionEvent actionEvent) {
                Key<?> key = GeneralTable.this.model.getColumnKey(0);
                if (!(key instanceof FileKey)) {
                    return;
                }
                FileKey fileKey = (FileKey)key;
                int n = fileKey.getType() == 1 ? 1 : 0;
                FileFilter[] fileFilterArray = UIUtility.toFileFilter(fileKey.getExtensionFilters());
                File[] fileArray = UIUtility.chooseFiles(GeneralTable.this, new File(fileKey.getDefaultDirectory()), n, fileFilterArray);
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                GeneralTable.this.model.beginValueChange();
                try {
                    for (File file : fileArray) {
                        GeneralTable.this.model.addNewRow();
                        GeneralTable.this.model.setValueAt(file.getPath(), GeneralTable.this.model.getModelRowCount() - 1, 0);
                    }
                }
                finally {
                    GeneralTable.this.model.endValueChange();
                }
            }
        }
    }

    protected class GeneralTableImpl
    extends EditingTable {
        private JLayer<Component> rendererLayer;
        private HelperCellRenderer helperCellRenderer;
        private boolean layoutDone;
        private int preferredWidth = -1;

        public GeneralTableImpl() {
            this.rendererLayer = new JLayer<Component>(null, new CellRendererLayerUI());
            this.helperCellRenderer = new HelperCellRenderer();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            super.tableChanged(tableModelEvent);
            if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
                this.preferredWidth = -1;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.preferredWidth < 0) {
                this.preferredWidth = 0;
                for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
                    int n = this.getPreferredWidth(i);
                    if (n == 0) {
                        n = 300;
                    }
                    this.preferredWidth += n;
                }
            }
            dimension.width = this.preferredWidth;
            return dimension;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!GeneralTable.this.key.isEditable()) {
                return false;
            }
            return super.isCellEditable(n, n2);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (GeneralTable.this.model.isRowOutOfModelArea(n)) {
                return this.helperCellRenderer;
            }
            return super.getCellRenderer(n, n2);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            TableCellEditor tableCellEditor = GeneralTable.this.getCellEditor(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
            if (tableCellEditor == null) {
                tableCellEditor = super.getCellEditor(n, n2);
            }
            return tableCellEditor;
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl) {
                JTextComponent jTextComponent;
                Component component = this.getEditorComponent();
                if (component instanceof TextComponentContainer && (jTextComponent = ((TextComponentContainer)((Object)component)).getTextComponent()) != null) {
                    component = jTextComponent;
                }
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
            }
            return bl;
        }

        @Override
        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            if (GeneralTable.this.model.isRowOutOfModelArea(n)) {
                GeneralTable.this.model.fillNewRow(n);
            }
            Component component = super.prepareEditor(tableCellEditor, n, n2);
            component.setFont(this.getFont());
            if (component instanceof TableChoiceComboBox) {
                TableChoiceComboBox tableChoiceComboBox = (TableChoiceComboBox)component;
                ComboBoxModel comboBoxModel = tableChoiceComboBox.getModel();
                ((ChoiceComboboxModel)comboBoxModel).clearFilter();
            }
            return component;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (this.getColumnClass(n2) == Boolean.class) {
                return component;
            }
            this.rendererLayer.setView(component);
            ((CellRendererLayerUI)this.rendererLayer.getUI()).setCell(n, n2);
            return this.rendererLayer;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            if (GeneralTable.this.model != null && GeneralTable.this.model.isError()) {
                Point point = mouseEvent.getPoint();
                int n = GeneralTable.this.table.rowAtPoint(point);
                int n2 = GeneralTable.this.table.columnAtPoint(point);
                if (n >= 0 && n2 >= 0) {
                    ValueError valueError;
                    Rectangle rectangle = this.getCellRect(n, n2, true);
                    int n3 = 15;
                    if (point.x < rectangle.x + n3 && point.y < rectangle.y + n3 && (valueError = GeneralTable.this.model.getError(GeneralTable.this.table.convertRowIndexToModel(n), n2)) != null) {
                        return UIUtility.convertToHTML(valueError.getMessage(false, false));
                    }
                }
            }
            return super.getToolTipText(mouseEvent);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = this.getPreferredSize();
            return new Dimension(dimension.width, this.getRowCount() * this.getRowHeight());
        }

        @Override
        public void doLayout() {
            TableTextSearchResult tableTextSearchResult = GeneralTable.this.searchResult;
            if (!this.layoutDone && this.getWidth() > 0) {
                this.adjustColumns();
                this.layoutDone = true;
            }
            super.doLayout();
            if (tableTextSearchResult != null && GeneralTable.this.searchResult == null) {
                GeneralTable.this.select(tableTextSearchResult);
            }
        }

        private void adjustColumns() {
            int n;
            int n2;
            int n3 = this.getWidth();
            int n4 = 0;
            TableColumnModel tableColumnModel = GeneralTable.this.table.getColumnModel();
            int n5 = tableColumnModel.getColumnCount();
            int n6 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                n = this.getPreferredWidth(n2);
                if (n <= 0) {
                    ++n6;
                }
                n4 += n;
            }
            if (n4 < n3 && n6 > 0) {
                n2 = n3 - n4;
                n = n6 == 0 ? 0 : n2 / n6;
                int n7 = n3;
                for (int i = 0; i < n5; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    if (i < n5 - 1) {
                        int n8 = this.getPreferredWidth(i);
                        if (n8 > 0) {
                            tableColumn.setPreferredWidth(n8);
                            n7 -= n8;
                            continue;
                        }
                        tableColumn.setPreferredWidth(n);
                        n7 -= n;
                        continue;
                    }
                    tableColumn.setPreferredWidth(n7);
                }
            } else {
                for (n2 = 0; n2 < n5; ++n2) {
                    TableColumn tableColumn = tableColumnModel.getColumn(n2);
                    int n9 = this.getPreferredWidth(n2);
                    if (n9 > 0) {
                        tableColumn.setPreferredWidth(n9);
                        continue;
                    }
                    tableColumn.setPreferredWidth(300);
                }
            }
        }

        private int getPreferredWidth(int n) {
            int n2 = GeneralTable.this.model.getFixedColumnWidth(n);
            if (n2 > 0) {
                return n2;
            }
            int n3 = GeneralTable.this.model.getColumnWidth(n);
            if (n3 > 0) {
                return n3;
            }
            return 0;
        }
    }

    private class TableColumnHandler
    implements PropertyChangeListener {
        private TableColumnHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("width".equals(propertyChangeEvent.getPropertyName())) {
                GeneralTable.this.refreshRowHeights();
            }
        }
    }

    protected class ChoiceCellRenderer
    implements TableCellRenderer {
        private TableChoiceComboBox choiceComboBox;
        private JPanel emptyPanel;

        public ChoiceCellRenderer(TableChoiceComboBox tableChoiceComboBox) {
            this.choiceComboBox = tableChoiceComboBox;
            this.choiceComboBox.setFont(GeneralTable.this.table.getFont());
            this.choiceComboBox.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.emptyPanel = new JPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (GeneralTable.this.model.isRowOutOfModelArea(n)) {
                this.emptyPanel.setBackground(bl ? jTable.getSelectionBackground() : GeneralTable.this.darker(Color.WHITE));
                return this.emptyPanel;
            }
            Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            this.choiceComboBox.setRow(n);
            this.choiceComboBox.setSelectedItem(object);
            this.choiceComboBox.setForeground(color);
            this.choiceComboBox.setOpaque(true);
            GeneralTable.configureRenderer(this.choiceComboBox, jTable, bl, bl2, this.choiceComboBox.isEditable());
            return this.choiceComboBox;
        }
    }

    protected class CodingTextAreaRenderer
    implements TableCellRenderer,
    RowBasedTableModelEventHandler {
        private CodingTextArea textArea = this.createTextArea();
        private CodingTextAreaContainer scrollPane;
        private Map<TableRow, String> descriptions;

        public CodingTextAreaRenderer(boolean bl, boolean bl2) {
            this.textArea.setLineWrap(!bl);
            this.textArea.setEditable(false);
            this.textArea.setAnimateBracketMatching(false);
            this.textArea.setBracketMatchingEnabled(false);
            this.textArea.setEmptyMessageColor(WidgetConstants.INFO_FONT_COLOR);
            if (this.textArea.getForeground() != null && !(this.textArea.getForeground() instanceof UIResource)) {
                this.textArea.setForeground(new ColorUIResource(this.textArea.getForeground()));
            }
            if (GeneralTable.this.getBackground() != null && !(GeneralTable.this.getBackground() instanceof UIResource)) {
                this.textArea.setBackground(new ColorUIResource(this.textArea.getBackground()));
            }
            this.textArea.setBackground(Color.WHITE);
            if (!bl) {
                this.scrollPane = new CodingTextAreaContainer(this.textArea);
            }
            if (bl2) {
                GeneralTable.this.internalTableModelHandlers.addLast(this);
            }
        }

        protected CodingTextArea createTextArea() {
            return new CodingTextField();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            this.textArea.setText(GeneralTable.this.model.valueToString(object, n, n2));
            String string = null;
            Key<?> key = GeneralTable.this.model.getColumnKey(n2);
            if (this.textArea.getText().isEmpty()) {
                if (key.isDynamicDefault()) {
                    object2 = GeneralTable.this.getValueMap().getDynamicDefaultValue(GeneralTable.this.getInnerModel(), n, key);
                    if (object2 instanceof String) {
                        string = "(" + (String)object2 + ")";
                    }
                } else if (key instanceof StrKey && ((StrKey)(object2 = (StrKey)key)).isEmptyMessage()) {
                    string = "(" + ((StrKey)object2).getEmptyMessage(GeneralTable.this.getValueMap()) + ")";
                }
                this.textArea.setEmptyMessageColor(WidgetConstants.AUTO_FONT_COLOR);
            }
            this.textArea.setEmptyMessage(string);
            if (key instanceof StrKey && (object2 = ((StrKey)key).getDescriptionLink()) != null) {
                TableRow tableRow;
                String string2;
                if (this.descriptions == null) {
                    this.descriptions = new HashMap<TableRow, String>();
                }
                if ((string2 = this.descriptions.get(tableRow = GeneralTable.this.model.getRow(n))) == null) {
                    string2 = object2.getDescription(key, object, GeneralTable.this.valueMap);
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.descriptions.put(tableRow, string2);
                }
                this.textArea.setDescription(string2);
            }
            if (this.scrollPane != null) {
                this.scrollPane.getVerticalScrollBar().setValue(0);
            }
            GeneralTable.configureRenderer((JComponent)((Object)this.textArea), jTable, bl, bl2, jTable.isCellEditable(n, n2));
            if (this.scrollPane != null) {
                return this.scrollPane;
            }
            return this.textArea;
        }

        @Override
        public void rowBasedTableChanged(RowBasedTableModelEvent rowBasedTableModelEvent) {
            if (this.descriptions == null) {
                return;
            }
            switch (rowBasedTableModelEvent.getType()) {
                case 2: {
                    this.descriptions.remove(rowBasedTableModelEvent.getModel().getRow(rowBasedTableModelEvent.getUpdatedRow()));
                    break;
                }
                case 0: {
                    int[] nArray;
                    for (int n : nArray = rowBasedTableModelEvent.getRows()) {
                        this.descriptions.remove(rowBasedTableModelEvent.getModel().getRow(n));
                    }
                    break;
                }
                case 1: {
                    for (TableRow tableRow : rowBasedTableModelEvent.getDeleted()) {
                        this.descriptions.remove(tableRow);
                    }
                    break;
                }
            }
        }
    }

    static class BooleanRenderer
    implements TableCellRenderer,
    UIResource {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            jCheckBox.setVerticalAlignment(0);
            jCheckBox.setSelected(object != null && (Boolean)object != false);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jCheckBox, "Center");
            GeneralTable.configureRenderer(jPanel, jTable, bl, bl2, false);
            return jPanel;
        }
    }

    protected class ChoiceCellEditor
    extends DefaultCellEditor
    implements FocusListener,
    ActionListener {
        private ChoiceKey key;
        private TableChoiceComboBox comboBox;

        public ChoiceCellEditor(ChoiceKey choiceKey, TableChoiceComboBox tableChoiceComboBox) {
            super(tableChoiceComboBox);
            this.key = choiceKey;
            this.comboBox = tableChoiceComboBox;
            tableChoiceComboBox.setFont(GeneralTable.this.table.getFont());
            this.setClickCountToStart(tableChoiceComboBox.isEditable() ? 2 : 1);
            if (tableChoiceComboBox.isEditable()) {
                Component component = tableChoiceComboBox.getEditor().getEditorComponent();
                if (component != null) {
                    component.addFocusListener(this);
                }
                tableChoiceComboBox.addActionListener(this);
            }
        }

        public TableChoiceComboBox getComboBox() {
            return this.comboBox;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                Point point = mouseEvent.getPoint();
                int n = GeneralTable.this.table.rowAtPoint(point);
                if (n >= GeneralTable.this.model.getModelRowCount() && mouseEvent.getClickCount() <= 1) {
                    return false;
                }
                Rectangle rectangle = GeneralTable.this.table.getCellRect(n, GeneralTable.this.table.columnAtPoint(point), false);
                point = new Point(point);
                point.translate(-rectangle.x, -rectangle.y);
                if (this.comboBox.isButton(rectangle.getSize(), point)) {
                    return true;
                }
            }
            return super.isCellEditable(eventObject);
        }

        @Override
        public boolean stopCellEditing() {
            if (this.comboBox.isEditable()) {
                this.comboBox.actionPerformed(new ActionEvent(this.comboBox.getEditor(), 0, ""));
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.comboBox.setRow(n);
            if (this.key.getChoiceProvider() != null) {
                ComboBoxModel comboBoxModel = this.getComboBox().getModel();
                ((ChoiceComboboxModel)comboBoxModel).setData(this.key.getChoices(GeneralTable.this.valueMap));
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.stopCellEditing();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = GeneralTable.this.table.getEditingRow();
            int n2 = GeneralTable.this.table.getEditingColumn();
            this.stopCellEditing();
            if (n >= 0 && n2 >= 0 && n < GeneralTable.this.table.getRowCount() && n2 < GeneralTable.this.table.getColumnCount()) {
                GeneralTable.this.selectCell(n, n2);
            }
        }
    }

    protected class CodingTextAreaCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    ActionListener {
        protected CodingTextArea textField = this.createCodingTextArea();
        protected TableCodingTextAreaContainer textArea;

        public CodingTextAreaCellEditor(boolean bl) {
            if (this.textField instanceof ActionSupport) {
                ((ActionSupport)((Object)this.textField)).addActionListener(this);
            }
            this.textField.addFocusListener(this);
            this.textField.setBorder(new CompoundBorder(new LineBorder(Color.GRAY){

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 0, 0, 0);
                }

                @Override
                public Insets getBorderInsets(Component component, Insets insets) {
                    insets.bottom = 0;
                    insets.right = 0;
                    insets.top = 0;
                    insets.left = 0;
                    return insets;
                }
            }, new EmptyBorder(2, 4, 2, 4)));
            if (!bl) {
                this.textArea = new TableCodingTextAreaContainer(this.textField, bl, GeneralTable.this);
            }
        }

        protected CodingTextArea createCodingTextArea() {
            return new CodingTextField(){

                @Override
                protected void tabPressed() {
                    GeneralTable.this.next(true);
                }

                @Override
                protected void shiftTabPressed() {
                    GeneralTable.this.next(false);
                }
            };
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.textField.setText((String)object);
            this.textField.discardAllEdits();
            if (this.textArea != null) {
                return this.textArea;
            }
            return this.textField;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!this.textField.isKeepEditingInTable()) {
                this.stopCellEditing();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GeneralTable.this.editFinished();
        }
    }

    private static class StringCellEditor
    extends DefaultCellEditor {
        public StringCellEditor(StringTextField stringTextField) {
            super(stringTextField);
            stringTextField.setBorder(new CompoundBorder(new LineBorder(Color.GRAY){

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 0, 0, 0);
                }

                @Override
                public Insets getBorderInsets(Component component, Insets insets) {
                    insets.bottom = 0;
                    insets.right = 0;
                    insets.top = 0;
                    insets.left = 0;
                    return insets;
                }
            }, new EmptyBorder(2, 4, 2, 4)));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            ((StringTextField)component).discardAllEdits();
            return component;
        }
    }

    private static class StringTextField
    extends JTextField {
        private UndoManager undoManager = UIUtility.setTextComponentUndoable(this);

        public StringTextField() {
            UIUtility.setTextComponentPopupMenu(this);
        }

        public void discardAllEdits() {
            this.undoManager.discardAllEdits();
        }
    }

    private class HelperCellRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JPanel jPanel = new JPanel(new BorderLayout());
            Key<?> key = GeneralTable.this.model.getColumnKey(n2);
            if (key instanceof BoolKey) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected((Boolean)key.getDefaultValue());
                jCheckBox.setHorizontalAlignment(0);
                jCheckBox.setVerticalAlignment(0);
                jCheckBox.setBackground(Color.WHITE);
                jPanel.add((Component)jCheckBox, "Center");
                GeneralTable.configureRenderer(jPanel, jTable, bl, bl2, false);
            } else {
                JLabel jLabel = new JLabel();
                jLabel.setText("-");
                jLabel.setHorizontalAlignment(0);
                jLabel.setVerticalAlignment(0);
                jLabel.setForeground(Color.GRAY);
                jPanel.add((Component)jLabel, "Center");
                boolean bl3 = true;
                if (key instanceof ChoiceKey) {
                    ChoiceKey choiceKey = (ChoiceKey)key;
                    bl3 = choiceKey.isChoiceEditable();
                }
                GeneralTable.configureRenderer(jPanel, jTable, bl, bl2, bl3);
            }
            return jPanel;
        }
    }

    private class CellRendererLayerUI
    extends LayerUI<Component> {
        private int row;
        private int column;

        private CellRendererLayerUI() {
        }

        public void setCell(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            if (!GeneralTable.this.model.isError()) {
                return;
            }
            ValueError valueError = GeneralTable.this.model.getError(this.row, this.column);
            if (valueError != null) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setPaint(WidgetConstants.getErrorColor(valueError));
                graphics2D.fillPolygon(new int[]{0, 6, 0}, new int[]{0, 0, 6}, 3);
                graphics2D.dispose();
            }
        }
    }
}

