/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ListTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private List<Object[]> model;
    private boolean autoCreateLastRow;

    public ListTableModel(String[] stringArray, List<Object[]> list, boolean bl) {
        this.columnNames = stringArray;
        this.model = list;
        this.autoCreateLastRow = bl;
    }

    public List<Object[]> getData() {
        return this.model;
    }

    public List<Object> getColumn(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object[] objectArray : this.model) {
            arrayList.add(objectArray[n]);
        }
        return arrayList;
    }

    private Object[] newRow() {
        Object[] objectArray = new Object[this.getColumnCount()];
        Arrays.fill(objectArray, "");
        return objectArray;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.autoCreateLastRow ? this.model.size() + 1 : this.model.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.model.size()) {
            return "";
        }
        return this.model.get(n)[n2];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.autoCreateLastRow && this.model.size() == n) {
            this.model.add(this.newRow());
            this.fireTableRowsInserted(n, n);
        }
        this.model.get((int)n)[n2] = object;
        this.fireTableCellUpdated(n, n);
    }

    public void addRow(Object[] objectArray) {
        this.addRow(this.model.size(), objectArray);
    }

    public void addRow(int n, Object[] objectArray) {
        this.model.add(n, objectArray);
        this.fireTableRowsInserted(n, n);
    }

    public void removeRow(int n) {
        if (n >= this.model.size()) {
            return;
        }
        this.model.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void moveRow(int n, int n2) {
        if (n == n2) {
            return;
        }
        Object[] objectArray = this.model.remove(n);
        if (n < n2) {
            this.model.add(n2 - 1, objectArray);
            this.fireTableRowsUpdated(n, n2);
        } else {
            this.model.add(n2, objectArray);
            this.fireTableRowsUpdated(n2, n);
        }
    }
}

