/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.ui.common.table.TableDataFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

public class TableDataTransferable
implements Transferable {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{DataFlavor.stringFlavor, TableDataFlavor.getInstance()};
    private List<List<String>> data;

    public TableDataTransferable(List<List<String>> list) {
        this.data = list;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!dataFlavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (FLAVORS[1].equals(dataFlavor)) {
            return this.data;
        }
        if (FLAVORS[0].equals(dataFlavor)) {
            if (this.data.isEmpty()) {
                return "";
            }
            if (this.data.size() == 1 && this.data.get(0).size() == 1) {
                return this.data.get(0).get(0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "\t";
            String string2 = "\n";
            for (List<String> list : this.data) {
                if (!list.isEmpty()) {
                    stringBuilder.append(list.get(0));
                    for (int i = 1; i < list.size(); ++i) {
                        stringBuilder.append(string);
                        stringBuilder.append(list.get(i));
                    }
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

