/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.core.common.table.RowBasedTableModel;
import com.ef_prime.rflow.core.common.table.TableRow;
import javax.swing.JTable;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableEdits {

    public static class SelectionEdit
    extends AbstractUndoableEdit {
        private JTable table;
        private int[] rows;
        private int[] columns;
        private boolean clear;

        public SelectionEdit(JTable jTable, int[] nArray, int[] nArray2, boolean bl) {
            this.table = jTable;
            this.rows = nArray;
            this.columns = nArray2;
            this.clear = bl;
        }

        private void setSelection() {
            this.table.clearSelection();
            for (int n : this.rows) {
                this.table.addRowSelectionInterval(n, n);
            }
            for (int n : this.columns) {
                this.table.addColumnSelectionInterval(n, n);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (!this.clear) {
                this.setSelection();
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.clear) {
                this.setSelection();
            }
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }

    public static class MoveRowEdit
    extends AbstractUndoableEdit {
        private JTable table;
        private RowBasedTableModel<?> model;
        private int from;
        private int to;

        public MoveRowEdit(JTable jTable, RowBasedTableModel<?> rowBasedTableModel, int n, int n2) {
            this.table = jTable;
            this.model = rowBasedTableModel;
            this.from = n;
            this.to = n2;
        }

        public RowBasedTableModel<?> getModel() {
            return this.model;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        private void setSelection(int n) {
            this.table.clearSelection();
            this.table.setColumnSelectionInterval(0, this.model.getColumnCount() - 1);
            this.table.setRowSelectionInterval(n, n);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.moveRow(this.from, this.to);
            this.setSelection(this.to);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.moveRow(this.to, this.from);
            this.setSelection(this.from);
        }
    }

    public static class InsertRowsEdit
    extends AbstractUndoableEdit {
        private JTable table;
        private RowBasedTableModel<?> model;
        private int[] rows;
        private TableRow[] tableRows;

        public InsertRowsEdit(JTable jTable, RowBasedTableModel<?> rowBasedTableModel, int[] nArray, TableRow[] tableRowArray) {
            this.table = jTable;
            this.model = rowBasedTableModel;
            this.rows = nArray;
            this.tableRows = tableRowArray;
        }

        public int[] getRows() {
            return this.rows;
        }

        public TableRow[] getTableRows() {
            return this.tableRows;
        }

        private void setSelection() {
            this.table.clearSelection();
            this.table.setColumnSelectionInterval(0, this.model.getColumnCount() - 1);
            for (int n : this.rows) {
                this.table.addRowSelectionInterval(n, n);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.beginValueChange();
            try {
                for (int i = 0; i < this.rows.length; ++i) {
                    this.model.insertRow(this.rows[i], this.tableRows[i]);
                }
            }
            finally {
                this.model.endValueChange();
            }
            this.setSelection();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.removeRows(this.rows);
        }
    }

    public static class RemoveRowsEdit
    extends AbstractUndoableEdit {
        private JTable table;
        private RowBasedTableModel<?> model;
        private int[] rows;
        private TableRow[] tableRows;

        public RemoveRowsEdit(JTable jTable, RowBasedTableModel<?> rowBasedTableModel, int[] nArray, TableRow[] tableRowArray) {
            this.table = jTable;
            this.model = rowBasedTableModel;
            this.rows = nArray;
            this.tableRows = tableRowArray;
        }

        public int[] getRows() {
            return this.rows;
        }

        public TableRow[] getTableRows() {
            return this.tableRows;
        }

        private void setSelection() {
            this.table.clearSelection();
            this.table.setColumnSelectionInterval(0, this.model.getColumnCount() - 1);
            for (int n : this.rows) {
                this.table.addRowSelectionInterval(n, n);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.removeRows(this.rows);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.beginValueChange();
            try {
                for (int i = 0; i < this.rows.length; ++i) {
                    this.model.insertRow(this.rows[i], this.tableRows[i]);
                }
            }
            finally {
                this.model.endValueChange();
            }
            this.setSelection();
        }
    }

    public static class CellUpdateEdit
    extends AbstractUndoableEdit {
        private JTable table;
        private RowBasedTableModel<?> model;
        private int row;
        private int column;
        private Object oldValue;
        private Object newValue;

        public CellUpdateEdit(JTable jTable, RowBasedTableModel<?> rowBasedTableModel, int n, int n2, Object object, Object object2) {
            this.table = jTable;
            this.model = rowBasedTableModel;
            this.row = n;
            this.column = n2;
            this.oldValue = object;
            this.newValue = object2;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.model.setValueAt(this.newValue, this.row, this.column);
            this.setSelection();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.model.setValueAt(this.oldValue, this.row, this.column);
            this.setSelection();
        }

        private void setSelection() {
            this.table.setRowSelectionInterval(this.row, this.row);
            this.table.setColumnSelectionInterval(this.column, this.column);
        }
    }
}

