/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.ui.common.event.EventSupport;
import com.ef_prime.rflow.ui.common.table.SortEvent;
import com.ef_prime.rflow.ui.common.table.SortEventHandler;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ThreeClickRowSorter<M extends TableModel>
extends TableRowSorter<M> {
    private EventSupport<SortEvent, SortEventHandler> eventSupport = new EventSupport();

    public ThreeClickRowSorter() {
    }

    public ThreeClickRowSorter(M m) {
        super(m);
    }

    @Override
    public void toggleSortOrder(int n) {
        int n2;
        if (n < 0 || n >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.isSortable(n)) {
            return;
        }
        List<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        for (n2 = list.size() - 1; n2 >= 0 && ((RowSorter.SortKey)list.get(n2)).getColumn() != n; --n2) {
        }
        if (n2 == -1) {
            list.add(0, new RowSorter.SortKey(n, SortOrder.ASCENDING));
            this.eventSupport.dispatchEvent(SortEvent.added(n, 1));
        } else {
            RowSorter.SortKey sortKey = (RowSorter.SortKey)list.get(n2);
            SortOrder sortOrder = null;
            int n3 = 0;
            switch (sortKey.getSortOrder()) {
                case ASCENDING: {
                    sortOrder = SortOrder.DESCENDING;
                    n3 = 2;
                    break;
                }
                case DESCENDING: {
                    sortOrder = null;
                    break;
                }
                case UNSORTED: {
                    sortOrder = SortOrder.ASCENDING;
                    n3 = 1;
                }
            }
            if (sortOrder != null) {
                list.set(n2, new RowSorter.SortKey(n, sortOrder));
                this.eventSupport.dispatchEvent(SortEvent.changed(n, n3));
            } else {
                list.remove(n2);
                this.eventSupport.dispatchEvent(SortEvent.removed(n));
            }
        }
        if (list.size() > this.getMaxSortKeys()) {
            list = list.subList(0, this.getMaxSortKeys());
        }
        this.setNewSortKeys(list);
    }

    protected void setNewSortKeys(List<RowSorter.SortKey> list) {
        this.setSortKeys(list);
    }

    public void addSortEventHandler(SortEventHandler sortEventHandler) {
        this.eventSupport.addEventHandler(sortEventHandler);
    }

    public void removeSortEventHandler(SortEventHandler sortEventHandler) {
        this.eventSupport.removeEventHandler(sortEventHandler);
    }
}

