/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import com.ef_prime.rflow.core.common.keyvalue.Key;
import com.ef_prime.rflow.core.common.keyvalue.KeyLink;
import com.ef_prime.rflow.core.common.keyvalue.StrKey;
import com.ef_prime.rflow.core.common.keyvalue.TableKey;
import com.ef_prime.rflow.core.common.keyvalue.ValueError;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.table.GeneralTableModelEvent;
import com.ef_prime.rflow.core.common.table.GeneralTableModelEventHandler;
import com.ef_prime.rflow.core.common.table.KeysTableModel;
import com.ef_prime.rflow.core.common.table.KeysTableRow;
import com.ef_prime.rflow.core.common.table.RowBasedTableModel;
import com.ef_prime.rflow.core.common.table.RowBasedTableModelEventHandler;
import com.ef_prime.rflow.core.common.table.TableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.IntStream;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.ArrayUtils;

public class UIGeneralTableModel
extends AbstractTableModel
implements GeneralTableModelEventHandler {
    private KeysTableModel model;
    private boolean editable;
    private int visibleRowCount = 1;
    private Boolean rowHeightMayChange;
    private int[] viewToModel;
    private int[] modelToView;

    public UIGeneralTableModel(KeysTableModel keysTableModel, boolean bl) {
        this.model = keysTableModel;
        this.editable = bl;
        this.loadModel();
    }

    public void loadModel() {
        this.model.addEventHandler(this);
    }

    public void unloadModel() {
        this.model.removeEventHandler(this);
    }

    private boolean isUnboundTableArea() {
        return this.model.isUnboundTableArea() && this.editable;
    }

    private int toModel(int n) {
        if (this.viewToModel == null) {
            return n;
        }
        return this.viewToModel[n];
    }

    private int toView(int n) {
        if (this.modelToView == null) {
            return n;
        }
        return this.modelToView[n];
    }

    public boolean refreshFilter(ValueMap valueMap, TableKey tableKey) {
        int[] nArray = IntStream.range(0, this.model.getColumnCount()).filter(n -> {
            Key<?> key = this.model.getColumnKey(n);
            if (!key.isKeyLink()) {
                return true;
            }
            Boolean bl = null;
            for (KeyLink keyLink : key.getKeyLinks()) {
                boolean bl2 = keyLink.accept(valueMap);
                switch (keyLink.getType()) {
                    case "VISIBLE_OFF": {
                        bl2 = !bl2;
                    }
                    case "VISIBLE_ON": {
                        if (bl != null) break;
                        bl = bl2;
                        break;
                    }
                }
            }
            return bl == null || bl != false;
        }).toArray();
        if (nArray.length == this.model.getColumnCount()) {
            nArray = null;
        }
        if (!Arrays.equals(nArray, this.viewToModel)) {
            this.viewToModel = nArray;
            if (this.viewToModel == null) {
                this.modelToView = null;
            } else {
                this.modelToView = new int[this.model.getColumnCount()];
                int n2 = 0;
                for (int i = 0; i < this.modelToView.length; ++i) {
                    this.modelToView[i] = n2 < nArray.length && nArray[n2] == i ? n2++ : -1;
                }
            }
            tableKey.revalidate(this.model);
            this.fireTableStructureChanged();
            this.fireChangedEvent();
            return true;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.isUnboundTableArea()) {
            return this.model.getRowCount() + this.visibleRowCount;
        }
        return this.model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.viewToModel == null) {
            return this.model.getColumnCount();
        }
        return this.viewToModel.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.model.getColumnName(this.toModel(n));
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.model.getColumnClass(this.toModel(n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isRowOutOfModelArea(n)) {
            return true;
        }
        return this.model.isCellEditable(n, this.toModel(n2));
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isRowOutOfModelArea(n)) {
            return null;
        }
        return this.model.getValueAt(n, this.toModel(n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.isRowOutOfModelArea(n)) {
            this.fillNewRow(n);
        }
        this.model.setValueAt(object, n, this.toModel(n2));
    }

    public TableRow getRow(int n) {
        return this.model.getRow(n);
    }

    public int[] getUIControls() {
        return this.model.getUIControls();
    }

    public int getModelRowCount() {
        return this.model.getRowCount();
    }

    public Key<?> getColumnKey(int n) {
        return this.model.getColumnKey(this.toModel(n));
    }

    public Key<?>[] getColumnKeys() {
        return this.model.getColumnKeys();
    }

    public int getColumnIndex(Key<?> key) {
        return this.model.getColumnIndex(key);
    }

    public int getFixedColumnWidth(int n) {
        return this.model.getFixedColumnWidth(this.toModel(n));
    }

    public int getColumnWidth(int n) {
        return this.model.getColumnWidth(this.toModel(n));
    }

    public boolean useLastColumnAsDetail() {
        return this.model.useLastColumnAsDetail();
    }

    public boolean hideHeader() {
        return this.model.hideHeader();
    }

    public String getEmptyMessage() {
        String string = this.model.getEmptyMessage();
        if (this.model.isDefaultMessage() && string != null) {
            return Key.toDefault(string);
        }
        return string;
    }

    public int[] getValidRows(int[] nArray) {
        if (this.isUnboundTableArea()) {
            Arrays.sort(nArray);
            int n = Arrays.binarySearch(nArray, this.model.getRowCount());
            if (n < 0) {
                n = Math.abs(n) - 1;
            }
            if (n < nArray.length) {
                nArray = ArrayUtils.subarray((int[])nArray, (int)0, (int)n);
            }
        }
        return nArray;
    }

    public void removeRows(int[] nArray) {
        int[] nArray2 = this.getValidRows(nArray);
        for (int i = 0; i < nArray2.length; ++i) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (!((KeysTableRow)this.model.getRow(nArray2[i])).isRemovable()) {
                hashSet.add(i);
            }
            if (hashSet.isEmpty()) continue;
            Integer[] integerArray = hashSet.toArray(new Integer[hashSet.size()]);
            nArray2 = ArrayUtils.removeAll((int[])nArray2, (int[])ArrayUtils.toPrimitive((Integer[])integerArray));
        }
        this.model.removeRows(nArray2);
    }

    public void moveRow(int n, int n2) {
        if (this.isUnboundTableArea()) {
            boolean bl = this.isRowOutOfModelArea(n);
            boolean bl2 = this.isRowOutOfModelArea(n2);
            if (bl && bl2) {
                return;
            }
            if (bl || bl2) {
                this.fillNewRow(Math.max(n, n2));
            }
        }
        this.model.moveRow(n, n2);
    }

    public void makeCopies(int[] nArray) {
        this.model.makeCopies(this.getValidRows(nArray));
    }

    public void fillNewRow(int n) {
        if (n < this.model.getRowCount()) {
            return;
        }
        this.model.insertNewRows(this.model.getRowCount(), n);
    }

    public void addNewRow() {
        this.model.addNewRow();
    }

    public void addNewRow(Object ... objectArray) {
        if (this.modelToView == null) {
            this.model.addNewRow(objectArray);
        } else {
            KeysTableRow keysTableRow = (KeysTableRow)this.model.getDefaultRow();
            for (int i = 0; i < objectArray.length; ++i) {
                keysTableRow.setValue(objectArray[i], this.toModel(i));
            }
            this.model.addRow(keysTableRow);
        }
    }

    public void insertNewRow(int n) {
        this.model.insertNewRow(n);
    }

    public String valueToString(Object object, int n, int n2) {
        if (this.isRowOutOfModelArea(n)) {
            return "";
        }
        return this.model.valueToString(object, n, this.toModel(n2));
    }

    public void addRowBasedTableModelEventHandler(RowBasedTableModelEventHandler rowBasedTableModelEventHandler) {
        if (this.model instanceof RowBasedTableModel) {
            this.model.addRowBasedTableModelEventHandler(rowBasedTableModelEventHandler);
        }
    }

    public void removeRowBasedTableModelEventHandler(RowBasedTableModelEventHandler rowBasedTableModelEventHandler) {
        if (this.model instanceof RowBasedTableModel) {
            this.model.removeRowBasedTableModelEventHandler(rowBasedTableModelEventHandler);
        }
    }

    public boolean isRowOutOfModelArea(int n) {
        return this.model.getRowCount() <= n;
    }

    public void setSelectedRows(int[] nArray) {
        this.model.setSelectedRows(nArray);
    }

    public boolean rowHeightMayChange() {
        if (this.rowHeightMayChange == null) {
            this.rowHeightMayChange = false;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!this.rowHeightMayChange(i)) continue;
                this.rowHeightMayChange = true;
                break;
            }
        }
        return this.rowHeightMayChange;
    }

    public boolean rowHeightMayChange(int n) {
        Key<?> key = this.model.getColumnKey(this.toModel(n));
        return key instanceof StrKey && ((StrKey)key).isMultiLine();
    }

    public ValueError getError(Integer n, Integer n2) {
        return this.model.getError(n, this.toModel(n2));
    }

    public boolean isError() {
        return this.model.isError();
    }

    public void beginValueChange() {
        this.model.beginValueChange();
    }

    public void endValueChange() {
        this.model.endValueChange();
    }

    public void fireChangedEvent() {
        this.model.fireChangeEvent();
    }

    @Override
    public void tableChanged(GeneralTableModelEvent generalTableModelEvent) {
        switch (generalTableModelEvent.getType()) {
            case 0: {
                for (int[] nArray : this.getIntervals(generalTableModelEvent.getRows())) {
                    this.fireTableRowsInserted(nArray[0], nArray[1]);
                }
                break;
            }
            case 2: {
                if (generalTableModelEvent.rowIsAll()) {
                    this.fireTableRowsDeleted(0, this.getRowCount() - 1);
                    break;
                }
                for (int[] nArray : this.getIntervals(generalTableModelEvent.getRows())) {
                    this.fireTableRowsDeleted(nArray[0], nArray[1]);
                }
                break;
            }
            case 1: {
                if (generalTableModelEvent.rowIsAll()) {
                    this.fireTableDataChanged();
                    break;
                }
                if (generalTableModelEvent.columnIsAll()) {
                    for (int[] nArray : this.getIntervals(generalTableModelEvent.getRows())) {
                        this.fireTableRowsUpdated(nArray[0], nArray[1]);
                    }
                } else {
                    for (int i = 0; i < generalTableModelEvent.getRows().length; ++i) {
                        int n = this.toView(generalTableModelEvent.getColumns()[i]);
                        if (n < 0) continue;
                        this.fireTableCellUpdated(generalTableModelEvent.getRows()[i], n);
                    }
                }
                break;
            }
            case 3: {
                this.fireTableStructureChanged();
            }
        }
    }

    private int[][] getIntervals(int[] nArray) {
        int n = -1;
        int n2 = -1;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 < 0) continue;
            if (n == -1) {
                n = n3;
            } else if (n2 != n3 - 1) {
                arrayList.add(new int[]{n, n2});
                n = n3;
            }
            n2 = n3;
        }
        if (n != -1) {
            arrayList.add(new int[]{n, n2});
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
    }
}

