/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class VisibleTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean tooltip;
    private List<Integer> tabOffsets;
    private static final String TAB_REP = "        ";
    private Rectangle paintViewR = new Rectangle();
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();

    public VisibleTableCellRenderer(boolean bl) {
        this.tooltip = bl;
        this.tabOffsets = new ArrayList<Integer>();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.tabOffsets.clear();
        Object object2 = this.getText();
        int n3 = -1;
        int n4 = 0;
        while ((n3 = ((String)object2).indexOf(9, n4)) >= 0) {
            this.tabOffsets.add(n3);
            String string = ((String)object2).substring(0, n3);
            String string2 = "";
            if (n3 < ((String)object2).length()) {
                string2 = ((String)object2).substring(n3 + 1);
            }
            object2 = string + TAB_REP + string2;
            n4 = n3 + TAB_REP.length();
        }
        this.setText((String)object2);
        if (this.tooltip) {
            this.setToolTipText((String)object2);
        }
        return this;
    }

    private String layoutLabel(FontMetrics fontMetrics) {
        Insets insets = this.getInsets(null);
        String string = this.getText();
        Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = this.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = this.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, this.getIconTextGap());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.tabOffsets.isEmpty()) {
            String string = this.layoutLabel(graphics.getFontMetrics());
            int n = string.endsWith("...") ? string.length() - 3 : string.length();
            int n2 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), TAB_REP);
            int n3 = this.getHeight() - this.getInsets().bottom;
            Insets insets = this.getInsets();
            for (Integer n4 : this.tabOffsets) {
                if (n < n4 + TAB_REP.length()) break;
                int n5 = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string.substring(0, n4));
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics.getColor();
                graphics.setColor(Color.LIGHT_GRAY);
                graphics2D.drawRect((n5 += insets.left) + 1, insets.top, n2 - 2, n3 - insets.top);
                graphics.setColor(color);
            }
        }
    }
}

