/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.tree;

import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import com.ef_prime.rflow.core.common.tree.LazyGeneralTreeNode;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.common.component.Actions;
import com.ef_prime.rflow.ui.common.tree.GeneralTreeCellRenderer;
import com.ef_prime.rflow.ui.common.tree.UIGeneralTreeNode;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class GeneralTree
extends JTree
implements TreeWillExpandListener {
    protected ElementTreeActions actions = new ElementTreeActions();
    private Predicate<GeneralTreeNode> filter;

    public GeneralTree() {
        this.setModel(null);
        this.setEditable(true);
        this.addTreeWillExpandListener(this);
        this.setCellRenderer(new GeneralTreeCellRenderer());
        this.actions.installActions(this, false);
    }

    public void setRoot(GeneralTreeNode generalTreeNode, boolean bl) {
        UIGeneralTreeNode uIGeneralTreeNode = UIGeneralTreeNode.build(generalTreeNode, this.filter);
        this.setModel(new DefaultTreeModel(uIGeneralTreeNode, true));
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public UIGeneralTreeNode getRoot() {
        return (UIGeneralTreeNode)this.getModel().getRoot();
    }

    public void setFilter(Predicate<GeneralTreeNode> predicate) {
        this.filter = predicate;
    }

    public TreePath getTreePath(String[] stringArray) {
        UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)this.getModel().getRoot();
        ArrayList<UIGeneralTreeNode> arrayList = new ArrayList<UIGeneralTreeNode>();
        if (!uIGeneralTreeNode.getElement().getDisplayString().equals(stringArray[0])) {
            return null;
        }
        arrayList.add(uIGeneralTreeNode);
        UIGeneralTreeNode uIGeneralTreeNode2 = uIGeneralTreeNode;
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < uIGeneralTreeNode2.getChildCount(); ++j) {
                UIGeneralTreeNode uIGeneralTreeNode3 = (UIGeneralTreeNode)uIGeneralTreeNode2.getChildAt(j);
                if (!uIGeneralTreeNode3.getElement().getDisplayString().equals(string)) continue;
                arrayList.add(uIGeneralTreeNode3);
                uIGeneralTreeNode2 = uIGeneralTreeNode3;
                break;
            }
            if (arrayList.size() > i) continue;
            return null;
        }
        return new TreePath(arrayList.toArray(new UIGeneralTreeNode[0]));
    }

    public UIGeneralTreeNode getUINode(GeneralTreeNode generalTreeNode) {
        TreePath treePath = this.getUINodePath(generalTreeNode);
        if (treePath == null) {
            return null;
        }
        return (UIGeneralTreeNode)treePath.getLastPathComponent();
    }

    public TreePath getUINodePath(GeneralTreeNode generalTreeNode) {
        GeneralTreeNode[] generalTreeNodeArray = generalTreeNode.getPathToRoot();
        Object[] objectArray = new UIGeneralTreeNode[generalTreeNodeArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 0) {
                objectArray[i] = (UIGeneralTreeNode)this.getModel().getRoot();
                continue;
            }
            Object object = objectArray[i - 1];
            for (int j = 0; j < ((UIGeneralTreeNode)object).getChildCount(); ++j) {
                UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)((UIGeneralTreeNode)object).getChildAt(j);
                GeneralTreeNode generalTreeNode2 = uIGeneralTreeNode.getElement();
                if (!generalTreeNode2.equals(generalTreeNodeArray[i])) continue;
                objectArray[i] = uIGeneralTreeNode;
            }
            if (objectArray[i] != null) continue;
            return null;
        }
        return new TreePath(objectArray);
    }

    public void refresh() {
        this.refresh((UIGeneralTreeNode)this.getModel().getRoot());
    }

    public void refresh(GeneralTreeNode generalTreeNode) {
        this.refresh(this.getUINode(generalTreeNode));
    }

    public void refresh(Collection<GeneralTreeNode> collection) {
        HashSet<GeneralTreeNode> hashSet = new HashSet<GeneralTreeNode>();
        int n = Integer.MAX_VALUE;
        for (GeneralTreeNode generalTreeNode : collection) {
            int n2 = generalTreeNode.getPathToRoot().length;
            if (n > n2) {
                n = n2;
                hashSet.clear();
                hashSet.add(generalTreeNode);
                continue;
            }
            if (n != n2) continue;
            hashSet.add(generalTreeNode);
        }
        for (GeneralTreeNode generalTreeNode : hashSet) {
            this.refresh(this.getUINode(generalTreeNode));
        }
    }

    public void refresh(UIGeneralTreeNode uIGeneralTreeNode) {
        if (uIGeneralTreeNode == null) {
            uIGeneralTreeNode = (UIGeneralTreeNode)this.getModel().getRoot();
        }
        uIGeneralTreeNode.refresh(this.filter);
        if (this.getModel() instanceof DefaultTreeModel) {
            this.getModel().nodeStructureChanged(uIGeneralTreeNode);
        }
    }

    @Override
    public boolean isPathEditable(TreePath treePath) {
        UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)treePath.getLastPathComponent();
        return uIGeneralTreeNode.getElement().isEditable();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        UIGeneralTreeNode uIGeneralTreeNode;
        JTree jTree = (JTree)treeExpansionEvent.getSource();
        if (!jTree.hasBeenExpanded(treeExpansionEvent.getPath()) && (uIGeneralTreeNode = (UIGeneralTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).getElement() instanceof LazyGeneralTreeNode) {
            LazyGeneralTreeNode lazyGeneralTreeNode = (LazyGeneralTreeNode)uIGeneralTreeNode.getElement();
            lazyGeneralTreeNode.removeChildren();
            lazyGeneralTreeNode.createChildren();
            uIGeneralTreeNode.update(this.filter);
        }
    }

    public static TreePath getPathToRoot(GeneralTreeNode generalTreeNode) {
        GeneralTreeNode[] generalTreeNodeArray = generalTreeNode.getPathToRoot();
        Object[] objectArray = new UIGeneralTreeNode[generalTreeNodeArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new UIGeneralTreeNode(generalTreeNodeArray[i]);
        }
        return new TreePath(objectArray);
    }

    protected class ElementTreeActions
    extends Actions {
        protected static final String REFRESH = "REFRESH";

        public ElementTreeActions() {
            this.put(REFRESH, new Refresh());
        }

        private class Refresh
        extends AbstractAction {
            public Refresh() {
                super(Messages.getString("Action.refresh"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = GeneralTree.this.getSelectionPath();
                if (treePath == null) {
                    GeneralTree.this.refresh();
                } else {
                    GeneralTree.this.refresh((UIGeneralTreeNode)treePath.getLastPathComponent());
                }
            }
        }
    }
}

