/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.common.tree;

import com.ef_prime.rflow.core.common.tree.GeneralTreeModel;
import com.ef_prime.rflow.core.common.tree.GeneralTreeModelEvent;
import com.ef_prime.rflow.core.common.tree.GeneralTreeModelEventHandler;
import com.ef_prime.rflow.core.common.tree.GeneralTreeNode;
import com.ef_prime.rflow.ui.common.tree.UIGeneralTreeNode;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UIGeneralTreeModel
implements TreeModel,
GeneralTreeModelEventHandler {
    private GeneralTreeModel model;
    private UIGeneralTreeNode root;
    private Queue<TreeModelListener> listeners = new ConcurrentLinkedQueue<TreeModelListener>();

    public UIGeneralTreeModel(GeneralTreeModel generalTreeModel) {
        this(generalTreeModel, null);
    }

    public UIGeneralTreeModel(GeneralTreeModel generalTreeModel, Predicate<GeneralTreeNode> predicate) {
        this.model = generalTreeModel;
        this.root = UIGeneralTreeNode.build(generalTreeModel.getRootNode(), predicate);
        generalTreeModel.addObserver(this);
    }

    public GeneralTreeModel getModel() {
        return this.model;
    }

    public void unloadModel() {
        this.model.removeObserver(this);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object object, int n) {
        UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)object;
        return uIGeneralTreeNode.getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)object;
        return uIGeneralTreeNode.getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)object;
        return uIGeneralTreeNode.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        UIGeneralTreeNode uIGeneralTreeNode = (UIGeneralTreeNode)object;
        return uIGeneralTreeNode.getIndex((UIGeneralTreeNode)object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    private UIGeneralTreeNode[] toUITreePath(GeneralTreeNode[] generalTreeNodeArray) {
        if (generalTreeNodeArray.length == 0 || this.root != generalTreeNodeArray[0]) {
            return new UIGeneralTreeNode[0];
        }
        ArrayList<UIGeneralTreeNode> arrayList = new ArrayList<UIGeneralTreeNode>();
        arrayList.add(this.root);
        UIGeneralTreeNode uIGeneralTreeNode = this.root;
        for (int i = 1; i < generalTreeNodeArray.length; ++i) {
            GeneralTreeNode generalTreeNode = generalTreeNodeArray[i];
            for (int j = 0; j < uIGeneralTreeNode.getChildCount(); ++j) {
                UIGeneralTreeNode uIGeneralTreeNode2 = (UIGeneralTreeNode)uIGeneralTreeNode.getChildAt(j);
                if (uIGeneralTreeNode2.getElement() != generalTreeNode) continue;
                arrayList.add(uIGeneralTreeNode2);
                uIGeneralTreeNode = uIGeneralTreeNode2;
                break;
            }
            if (arrayList.size() > i) continue;
            return new UIGeneralTreeNode[0];
        }
        return arrayList.toArray(new UIGeneralTreeNode[arrayList.size()]);
    }

    @Override
    public void treeNodesChanged(GeneralTreeModelEvent generalTreeModelEvent) {
        Object[] objectArray = this.toUITreePath(generalTreeModelEvent.getPath().getPathToRoot());
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesChanged(new TreeModelEvent((Object)this, objectArray, generalTreeModelEvent.getChildIndices(), null));
        }
    }

    @Override
    public void treeNodesInserted(GeneralTreeModelEvent generalTreeModelEvent) {
        Object[] objectArray = this.toUITreePath(generalTreeModelEvent.getPath().getPathToRoot());
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesInserted(new TreeModelEvent((Object)this, objectArray, generalTreeModelEvent.getChildIndices(), null));
        }
    }

    @Override
    public void treeNodesRemoved(GeneralTreeModelEvent generalTreeModelEvent) {
        TreePath treePath = new TreePath(this.toUITreePath(generalTreeModelEvent.getPath().getPathToRoot()));
        Object object = treePath.getLastPathComponent();
        Object[] objectArray = new Object[generalTreeModelEvent.getChildIndices().length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getChild(object, generalTreeModelEvent.getChildIndices()[i]);
        }
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeNodesRemoved(new TreeModelEvent((Object)this, treePath, generalTreeModelEvent.getChildIndices(), objectArray));
        }
    }

    @Override
    public void treeStructureChanged(GeneralTreeModelEvent generalTreeModelEvent) {
        Object[] objectArray = this.toUITreePath(generalTreeModelEvent.getPath().getPathToRoot());
        for (TreeModelListener treeModelListener : this.listeners) {
            treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, objectArray));
        }
    }
}

